/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.model.updates.IUpdateListener;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;

public abstract class AbstractMassSpectra
implements IMassSpectra {
    private List<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
    private String converterId = "";
    private String name = "";
    private List<IUpdateListener> updateListeners = new ArrayList<IUpdateListener>();

    @Override
    public void addMassSpectrum(IScanMSD massSpectrum) {
        if (massSpectrum != null) {
            this.massSpectra.add(massSpectrum);
        }
    }

    @Override
    public void addMassSpectra(Collection<? extends IScanMSD> massSpectra) {
        for (IScanMSD iScanMSD : massSpectra) {
            this.addMassSpectrum(iScanMSD);
        }
    }

    @Override
    public void removeMassSpectrum(IScanMSD massSpectrum) {
        if (massSpectrum != null) {
            this.massSpectra.remove(massSpectrum);
        }
    }

    @Override
    public IScanMSD getMassSpectrum(int i) {
        IScanMSD massSpectrum = null;
        if (i > 0 && i <= this.massSpectra.size()) {
            massSpectrum = this.massSpectra.get(--i);
        }
        return massSpectrum;
    }

    @Override
    public int size() {
        return this.massSpectra.size();
    }

    @Override
    public List<IScanMSD> getList() {
        return this.massSpectra;
    }

    @Override
    public String getConverterId() {
        return this.converterId;
    }

    @Override
    public void setConverterId(String converterId) {
        this.converterId = converterId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void update() {
        for (IUpdateListener updateListener : this.updateListeners) {
            updateListener.update();
        }
    }

    @Override
    public void addUpdateListener(IUpdateListener updateListener) {
        this.updateListeners.add(updateListener);
    }

    @Override
    public void removeUpdateListener(IUpdateListener updateListener) {
        this.updateListeners.remove(updateListener);
    }
}

