/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.model.core.AbstractPeakModel;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;

public abstract class AbstractPeakModelMSD
extends AbstractPeakModel
implements IPeakModelMSD {
    private static final long serialVersionUID = -673699436662069257L;

    public AbstractPeakModelMSD(IPeakMassSpectrum peakMaximum, IPeakIntensityValues peakIntensityValues, float startBackgroundAbundance, float stopBackgroundAbundance) throws IllegalArgumentException, PeakException {
        super((IScan)peakMaximum, peakIntensityValues, startBackgroundAbundance, stopBackgroundAbundance);
    }

    @Override
    public IPeakMassSpectrum getPeakMassSpectrum() {
        IScan peakMaximum = this.getPeakMaximum();
        if (peakMaximum instanceof IPeakMassSpectrum) {
            return (IPeakMassSpectrum)peakMaximum;
        }
        return null;
    }

    @Override
    public IPeakMassSpectrum getPeakMassSpectrum(int retentionTime) {
        float intensity;
        IPeakMassSpectrum peakMaximum = this.getPeakMassSpectrum();
        if (peakMaximum != null && retentionTime >= this.getStartRetentionTime() && retentionTime <= this.getStopRetentionTime() && (intensity = this.getIntensity(retentionTime)) >= 0.0f) {
            PeakMassSpectrum ms = new PeakMassSpectrum(peakMaximum, intensity);
            return ms;
        }
        return null;
    }
}

