/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.quantitation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationPeaksMSD;

public abstract class AbstractQuantitationPeaksMSD
implements IQuantitationPeaksMSD {
    private static final Logger logger = Logger.getLogger(AbstractQuantitationPeaksMSD.class);
    private String concentrationUnit;
    private List<IQuantitationPeakMSD> quantitationPeaks;

    public AbstractQuantitationPeaksMSD(String concentrationUnit) {
        this.concentrationUnit = concentrationUnit;
        this.quantitationPeaks = new ArrayList<IQuantitationPeakMSD>();
    }

    @Override
    public List<IQuantitationPeakMSD> getQuantitationPeaks() {
        return this.quantitationPeaks;
    }

    @Override
    public void addQuantitationPeak(IQuantitationPeakMSD quantitationPeakMSD) {
        if (quantitationPeakMSD != null && this.concentrationUnit.equals(quantitationPeakMSD.getConcentrationUnit())) {
            this.quantitationPeaks.add(quantitationPeakMSD);
        } else {
            logger.warn((Object)"The IQuantitationPeakMSD cause it has a different concentration unit.");
        }
    }

    @Override
    public void removeQuantitationPeak(IQuantitationPeakMSD quantitationPeakMSD) {
        this.quantitationPeaks.remove(quantitationPeakMSD);
    }
}

