/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.filter.core.chromatogram;

import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.IChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public abstract class AbstractChromatogramFilter
implements IChromatogramFilter {
    private static final String DESCRIPTION = "Chromatogram Filter";

    @Override
    public IProcessingInfo validate(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validateChromatogramSelection(chromatogramSelection));
        processingInfo.addMessages(this.validateFilterSettings(chromatogramFilterSettings));
        return processingInfo;
    }

    private IProcessingInfo validateChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramSelection == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The chromatogram selection is not valid.");
        } else if (chromatogramSelection.getChromatogram() == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The chromatogram is not valid.");
        }
        return processingInfo;
    }

    private IProcessingInfo validateFilterSettings(IChromatogramFilterSettings chromatogramFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramFilterSettings == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings are not valid.");
        }
        return processingInfo;
    }
}

