/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.model.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.identifier.chromatogram.IChromatogramTargetCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.AbstractChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;

public abstract class AbstractChromatogramCSD
extends AbstractChromatogram
implements IChromatogramCSD {
    private List<IChromatogramPeakCSD> peaks = new ArrayList<IChromatogramPeakCSD>();
    private Set<IChromatogramTargetCSD> targets = new HashSet<IChromatogramTargetCSD>();
    private INoiseCalculator noiseCalculator;

    public AbstractChromatogramCSD() {
        String noiseCalculatorId = PreferenceSupplier.getSelectedNoiseCalculatorId();
        this.noiseCalculator = NoiseCalculator.getNoiseCalculator((String)noiseCalculatorId);
        if (this.noiseCalculator != null) {
            int segmentWidth = PreferenceSupplier.getSelectedSegmentWidth();
            this.noiseCalculator.setChromatogram((IChromatogram)this, segmentWidth);
        }
    }

    public void recalculateTheNoiseFactor() {
        if (this.noiseCalculator != null) {
            this.noiseCalculator.recalculate();
        }
    }

    public float getSignalToNoiseRatio(float abundance) {
        if (this.noiseCalculator != null) {
            return this.noiseCalculator.getSignalToNoiseRatio(abundance);
        }
        return 0.0f;
    }

    @Override
    public IScanCSD getSupplierScan(int scan) {
        IScan storedScan;
        int position = scan;
        if (position > 0 && position <= this.getScans().size() && (storedScan = (IScan)this.getScans().get(--position)) instanceof IScanCSD) {
            return (IScanCSD)storedScan;
        }
        return null;
    }

    @Override
    public List<IChromatogramPeakCSD> getPeaks() {
        return this.peaks;
    }

    @Override
    public List<IChromatogramPeakCSD> getPeaks(IChromatogramSelectionCSD chromatogramSelection) {
        ArrayList<IChromatogramPeakCSD> peakList = new ArrayList<IChromatogramPeakCSD>();
        if (chromatogramSelection != null) {
            int startRetentionTime = chromatogramSelection.getStartRetentionTime();
            int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
            for (IChromatogramPeakCSD peak : this.peaks) {
                int peakRetentionTime = peak.getPeakModel().getRetentionTimeAtPeakMaximum();
                if (peakRetentionTime < startRetentionTime || peakRetentionTime > stopRetentionTime) continue;
                peakList.add(peak);
            }
        }
        return peakList;
    }

    @Override
    public void addPeak(IChromatogramPeakCSD peak) {
        if (!this.peaks.contains(peak) && peak.getPeakModel().getWidthByInflectionPoints() > 0) {
            this.peaks.add(peak);
        }
    }

    @Override
    public void removePeak(IChromatogramPeakCSD peak) {
        this.peaks.remove(peak);
    }

    @Override
    public void removePeaks(List<IChromatogramPeakCSD> peaksToDelete) {
        this.peaks.removeAll(peaksToDelete);
    }

    @Override
    public void removeAllPeaks() {
        this.peaks.clear();
    }

    @Override
    public int getNumberOfPeaks() {
        return this.peaks.size();
    }

    @Override
    public IChromatogramPeakCSD getPeak(int retentionTime) {
        IChromatogramPeakCSD selectedPeak = null;
        for (IChromatogramPeakCSD peak : this.peaks) {
            int peakStartRetentionTime = peak.getPeakModel().getStartRetentionTime();
            int peakStopRetentionTime = peak.getPeakModel().getStopRetentionTime();
            if (retentionTime < peakStartRetentionTime || retentionTime > peakStopRetentionTime) continue;
            selectedPeak = peak;
            break;
        }
        return selectedPeak;
    }

    public void fireUpdate(IChromatogramSelection chromatogramSelection) {
        if (chromatogramSelection instanceof ChromatogramSelectionCSD) {
            ((ChromatogramSelectionCSD)chromatogramSelection).update(true);
        }
    }

    public double getPeakIntegratedArea() {
        double integratedArea = 0.0;
        for (IChromatogramPeakCSD peak : this.peaks) {
            integratedArea += peak.getIntegratedArea();
        }
        return integratedArea;
    }

    @Override
    public void addTarget(IChromatogramTargetCSD chromatogramTarget) {
        if (chromatogramTarget != null) {
            this.targets.add(chromatogramTarget);
        }
    }

    @Override
    public void removeTarget(IChromatogramTargetCSD chromatogramTarget) {
        this.targets.remove(chromatogramTarget);
    }

    @Override
    public void removeTargets(List<IChromatogramTargetCSD> targetsToRemove) {
        this.targets.removeAll(targetsToRemove);
    }

    public void removeAllTargets() {
        this.targets.clear();
    }

    @Override
    public List<IChromatogramTargetCSD> getTargets() {
        ArrayList<IChromatogramTargetCSD> targetList = new ArrayList<IChromatogramTargetCSD>(this.targets);
        return targetList;
    }
}

