/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

import java.util.Random;
import org.ejml.alg.block.BlockMultiplication;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.ConvertMatrixType;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.RandomMatrices;

public class BlockMatrixOps {
    public static void convert(DenseMatrix64F src, BlockMatrix64F dst) {
        ConvertMatrixType.convert(src, dst);
    }

    public static void convertRowToBlock(int numRows, int numCols, int blockLength, double[] data, double[] tmp) {
        int minLength = Math.min(blockLength, numRows) * numCols;
        if (tmp.length < minLength) {
            throw new IllegalArgumentException("tmp must be at least " + minLength + " long ");
        }
        int i = 0;
        while (i < numRows) {
            int blockHeight = Math.min(blockLength, numRows - i);
            System.arraycopy(data, i * numCols, tmp, 0, blockHeight * numCols);
            int j = 0;
            while (j < numCols) {
                int blockWidth = Math.min(blockLength, numCols - j);
                int indexDst = i * numCols + blockHeight * j;
                int indexSrcRow = j;
                int k = 0;
                while (k < blockHeight) {
                    System.arraycopy(tmp, indexSrcRow, data, indexDst, blockWidth);
                    indexDst += blockWidth;
                    indexSrcRow += numCols;
                    ++k;
                }
                j += blockLength;
            }
            i += blockLength;
        }
    }

    public static DenseMatrix64F convert(BlockMatrix64F src, DenseMatrix64F dst) {
        return ConvertMatrixType.convert(src, dst);
    }

    public static void convertBlockToRow(int numRows, int numCols, int blockLength, double[] data, double[] tmp) {
        int minLength = Math.min(blockLength, numRows) * numCols;
        if (tmp.length < minLength) {
            throw new IllegalArgumentException("tmp must be at least " + minLength + " long and not " + tmp.length);
        }
        int i = 0;
        while (i < numRows) {
            int blockHeight = Math.min(blockLength, numRows - i);
            System.arraycopy(data, i * numCols, tmp, 0, blockHeight * numCols);
            int j = 0;
            while (j < numCols) {
                int blockWidth = Math.min(blockLength, numCols - j);
                int indexSrc = blockHeight * j;
                int indexDstRow = i * numCols + j;
                int k = 0;
                while (k < blockHeight) {
                    System.arraycopy(tmp, indexSrc, data, indexDstRow, blockWidth);
                    indexSrc += blockWidth;
                    indexDstRow += numCols;
                    ++k;
                }
                j += blockLength;
            }
            i += blockLength;
        }
    }

    public static void convertTranSrc(DenseMatrix64F src, BlockMatrix64F dst) {
        if (src.numRows != dst.numCols || src.numCols != dst.numRows) {
            throw new IllegalArgumentException("Incompatible matrix shapes.");
        }
        int i = 0;
        while (i < dst.numRows) {
            int blockHeight = Math.min(dst.blockLength, dst.numRows - i);
            int j = 0;
            while (j < dst.numCols) {
                int blockWidth = Math.min(dst.blockLength, dst.numCols - j);
                int indexDst = i * dst.numCols + blockHeight * j;
                int indexSrc = j * src.numCols + i;
                int l = 0;
                while (l < blockWidth) {
                    int rowSrc = indexSrc + l * src.numCols;
                    int rowDst = indexDst + l;
                    int k = 0;
                    while (k < blockHeight) {
                        dst.data[rowDst] = src.data[rowSrc++];
                        ++k;
                        rowDst += blockWidth;
                    }
                    ++l;
                }
                j += dst.blockLength;
            }
            i += dst.blockLength;
        }
    }

    public static void mult(BlockMatrix64F A, BlockMatrix64F B, BlockMatrix64F C) {
        if (A.numCols != B.numRows) {
            throw new IllegalArgumentException("Columns in A are incompatible with rows in B");
        }
        if (A.numRows != C.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in C");
        }
        if (B.numCols != C.numCols) {
            throw new IllegalArgumentException("Columns in B are incompatible with columns in C");
        }
        if (A.blockLength != B.blockLength || A.blockLength != C.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int blockLength = A.blockLength;
        D1Submatrix64F Asub = new D1Submatrix64F(A, 0, A.numRows, 0, A.numCols);
        D1Submatrix64F Bsub = new D1Submatrix64F(B, 0, B.numRows, 0, B.numCols);
        D1Submatrix64F Csub = new D1Submatrix64F(C, 0, C.numRows, 0, C.numCols);
        BlockMultiplication.mult(blockLength, Asub, Bsub, Csub);
    }

    public static void multTransA(BlockMatrix64F A, BlockMatrix64F B, BlockMatrix64F C) {
        if (A.numRows != B.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in B");
        }
        if (A.numCols != C.numRows) {
            throw new IllegalArgumentException("Columns in A are incompatible with rows in C");
        }
        if (B.numCols != C.numCols) {
            throw new IllegalArgumentException("Columns in B are incompatible with columns in C");
        }
        if (A.blockLength != B.blockLength || A.blockLength != C.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int blockLength = A.blockLength;
        D1Submatrix64F Asub = new D1Submatrix64F(A, 0, A.numRows, 0, A.numCols);
        D1Submatrix64F Bsub = new D1Submatrix64F(B, 0, B.numRows, 0, B.numCols);
        D1Submatrix64F Csub = new D1Submatrix64F(C, 0, C.numRows, 0, C.numCols);
        BlockMultiplication.multTransA(blockLength, Asub, Bsub, Csub);
    }

    public static void multTransB(BlockMatrix64F A, BlockMatrix64F B, BlockMatrix64F C) {
        if (A.numCols != B.numCols) {
            throw new IllegalArgumentException("Columns in A are incompatible with columns in B");
        }
        if (A.numRows != C.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in C");
        }
        if (B.numRows != C.numCols) {
            throw new IllegalArgumentException("Rows in B are incompatible with columns in C");
        }
        if (A.blockLength != B.blockLength || A.blockLength != C.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int blockLength = A.blockLength;
        D1Submatrix64F Asub = new D1Submatrix64F(A, 0, A.numRows, 0, A.numCols);
        D1Submatrix64F Bsub = new D1Submatrix64F(B, 0, B.numRows, 0, B.numCols);
        D1Submatrix64F Csub = new D1Submatrix64F(C, 0, C.numRows, 0, C.numCols);
        BlockMultiplication.multTransB(blockLength, Asub, Bsub, Csub);
    }

    public static BlockMatrix64F transpose(BlockMatrix64F A, BlockMatrix64F A_tran) {
        if (A_tran != null) {
            if (A.numRows != A_tran.numCols || A.numCols != A_tran.numRows) {
                throw new IllegalArgumentException("Incompatible dimensions.");
            }
            if (A.blockLength != A_tran.blockLength) {
                throw new IllegalArgumentException("Incompatible block size.");
            }
        } else {
            A_tran = new BlockMatrix64F(A.numCols, A.numRows, A.blockLength);
        }
        int i = 0;
        while (i < A.numRows) {
            int blockHeight = Math.min(A.blockLength, A.numRows - i);
            int j = 0;
            while (j < A.numCols) {
                int blockWidth = Math.min(A.blockLength, A.numCols - j);
                int indexA = i * A.numCols + blockHeight * j;
                int indexC = j * A_tran.numCols + blockWidth * i;
                BlockMatrixOps.transposeBlock(A, A_tran, indexA, indexC, blockWidth, blockHeight);
                j += A.blockLength;
            }
            i += A.blockLength;
        }
        return A_tran;
    }

    private static void transposeBlock(BlockMatrix64F A, BlockMatrix64F A_tran, int indexA, int indexC, int width, int height) {
        int i = 0;
        while (i < height) {
            int rowIndexC = indexC + i;
            int rowIndexA = indexA + width * i;
            int end = rowIndexA + width;
            while (rowIndexA < end) {
                A_tran.data[rowIndexC] = A.data[rowIndexA];
                rowIndexC += height;
                ++rowIndexA;
            }
            ++i;
        }
    }

    public static BlockMatrix64F createRandom(int numRows, int numCols, double min, double max, Random rand) {
        BlockMatrix64F ret = new BlockMatrix64F(numRows, numCols);
        RandomMatrices.setRandom(ret, min, max, rand);
        return ret;
    }

    public static BlockMatrix64F createRandom(int numRows, int numCols, double min, double max, Random rand, int blockLength) {
        BlockMatrix64F ret = new BlockMatrix64F(numRows, numCols, blockLength);
        RandomMatrices.setRandom(ret, min, max, rand);
        return ret;
    }

    public static BlockMatrix64F convert(DenseMatrix64F A, int blockLength) {
        BlockMatrix64F ret = new BlockMatrix64F(A.numRows, A.numCols, blockLength);
        BlockMatrixOps.convert(A, ret);
        return ret;
    }

    public static BlockMatrix64F convert(DenseMatrix64F A) {
        BlockMatrix64F ret = new BlockMatrix64F(A.numRows, A.numCols);
        BlockMatrixOps.convert(A, ret);
        return ret;
    }

    public static boolean isEquals(BlockMatrix64F A, BlockMatrix64F B) {
        if (A.blockLength != B.blockLength) {
            return false;
        }
        return MatrixFeatures.isEquals(A, B);
    }

    public static boolean isEquals(BlockMatrix64F A, BlockMatrix64F B, double tol) {
        if (A.blockLength != B.blockLength) {
            return false;
        }
        return MatrixFeatures.isEquals(A, B, tol);
    }

    public static void zeroTriangle(boolean upper, BlockMatrix64F A) {
        int blockLength = A.blockLength;
        if (upper) {
            int i = 0;
            while (i < A.numRows) {
                int h = Math.min(blockLength, A.numRows - i);
                int j = i;
                while (j < A.numCols) {
                    int l;
                    int k;
                    int w = Math.min(blockLength, A.numCols - j);
                    int index = i * A.numCols + h * j;
                    if (j == i) {
                        k = 0;
                        while (k < h) {
                            l = k + 1;
                            while (l < w) {
                                A.data[index + w * k + l] = 0.0;
                                ++l;
                            }
                            ++k;
                        }
                    } else {
                        k = 0;
                        while (k < h) {
                            l = 0;
                            while (l < w) {
                                A.data[index + w * k + l] = 0.0;
                                ++l;
                            }
                            ++k;
                        }
                    }
                    j += blockLength;
                }
                i += blockLength;
            }
        } else {
            int i = 0;
            while (i < A.numRows) {
                int h = Math.min(blockLength, A.numRows - i);
                int j = 0;
                while (j <= i) {
                    int k;
                    int w = Math.min(blockLength, A.numCols - j);
                    int index = i * A.numCols + h * j;
                    if (j == i) {
                        k = 0;
                        while (k < h) {
                            int z = Math.min(k, w);
                            int l = 0;
                            while (l < z) {
                                A.data[index + w * k + l] = 0.0;
                                ++l;
                            }
                            ++k;
                        }
                    } else {
                        k = 0;
                        while (k < h) {
                            int l = 0;
                            while (l < w) {
                                A.data[index + w * k + l] = 0.0;
                                ++l;
                            }
                            ++k;
                        }
                    }
                    j += blockLength;
                }
                i += blockLength;
            }
        }
    }

    public static void copyTriangle(boolean upper, BlockMatrix64F src, BlockMatrix64F dst) {
        if (src.blockLength != dst.blockLength) {
            throw new IllegalArgumentException("Block size is different");
        }
        if (src.numRows < dst.numRows) {
            throw new IllegalArgumentException("The src has fewer rows than dst");
        }
        if (src.numCols < dst.numCols) {
            throw new IllegalArgumentException("The src has fewer columns than dst");
        }
        int blockLength = src.blockLength;
        int numRows = Math.min(src.numRows, dst.numRows);
        int numCols = Math.min(src.numCols, dst.numCols);
        if (upper) {
            int i = 0;
            while (i < numRows) {
                int heightSrc = Math.min(blockLength, src.numRows - i);
                int heightDst = Math.min(blockLength, dst.numRows - i);
                int j = i;
                while (j < numCols) {
                    int k;
                    int widthSrc = Math.min(blockLength, src.numCols - j);
                    int widthDst = Math.min(blockLength, dst.numCols - j);
                    int indexSrc = i * src.numCols + heightSrc * j;
                    int indexDst = i * dst.numCols + heightDst * j;
                    if (j == i) {
                        k = 0;
                        while (k < heightDst) {
                            int l = k;
                            while (l < widthDst) {
                                dst.data[indexDst + widthDst * k + l] = src.data[indexSrc + widthSrc * k + l];
                                ++l;
                            }
                            ++k;
                        }
                    } else {
                        k = 0;
                        while (k < heightDst) {
                            System.arraycopy(src.data, indexSrc + widthSrc * k, dst.data, indexDst + widthDst * k, widthDst);
                            ++k;
                        }
                    }
                    j += blockLength;
                }
                i += blockLength;
            }
        } else {
            int i = 0;
            while (i < numRows) {
                int heightSrc = Math.min(blockLength, src.numRows - i);
                int heightDst = Math.min(blockLength, dst.numRows - i);
                int j = 0;
                while (j <= i) {
                    int k;
                    int widthSrc = Math.min(blockLength, src.numCols - j);
                    int widthDst = Math.min(blockLength, dst.numCols - j);
                    int indexSrc = i * src.numCols + heightSrc * j;
                    int indexDst = i * dst.numCols + heightDst * j;
                    if (j == i) {
                        k = 0;
                        while (k < heightDst) {
                            int z = Math.min(k + 1, widthDst);
                            int l = 0;
                            while (l < z) {
                                dst.data[indexDst + widthDst * k + l] = src.data[indexSrc + widthSrc * k + l];
                                ++l;
                            }
                            ++k;
                        }
                    } else {
                        k = 0;
                        while (k < heightDst) {
                            System.arraycopy(src.data, indexSrc + widthSrc * k, dst.data, indexDst + widthDst * k, widthDst);
                            ++k;
                        }
                    }
                    j += blockLength;
                }
                i += blockLength;
            }
        }
    }

    public static void set(BlockMatrix64F A, double value) {
        CommonOps.fill(A, value);
    }

    public static void setIdentity(BlockMatrix64F A) {
        int minLength = Math.min(A.numRows, A.numCols);
        CommonOps.fill(A, 0.0);
        int blockLength = A.blockLength;
        int i = 0;
        while (i < minLength) {
            int h = Math.min(blockLength, A.numRows - i);
            int w = Math.min(blockLength, A.numCols - i);
            int index = i * A.numCols + h * i;
            int m = Math.min(h, w);
            int k = 0;
            while (k < m) {
                A.data[index + k * w + k] = 1.0;
                ++k;
            }
            i += blockLength;
        }
    }

    public static BlockMatrix64F identity(int numRows, int numCols, int blockLength) {
        BlockMatrix64F A = new BlockMatrix64F(numRows, numCols, blockLength);
        int minLength = Math.min(numRows, numCols);
        int i = 0;
        while (i < minLength) {
            int h = Math.min(blockLength, A.numRows - i);
            int w = Math.min(blockLength, A.numCols - i);
            int index = i * A.numCols + h * i;
            int m = Math.min(h, w);
            int k = 0;
            while (k < m) {
                A.data[index + k * w + k] = 1.0;
                ++k;
            }
            i += blockLength;
        }
        return A;
    }

    public static void checkIdenticalShape(BlockMatrix64F A, BlockMatrix64F B) {
        if (A.blockLength != B.blockLength) {
            throw new IllegalArgumentException("Block size is different");
        }
        if (A.numRows != B.numRows) {
            throw new IllegalArgumentException("Number of rows is different");
        }
        if (A.numCols != B.numCols) {
            throw new IllegalArgumentException("NUmber of columns is different");
        }
    }

    public static void extractAligned(BlockMatrix64F src, BlockMatrix64F dst) {
        if (src.blockLength != dst.blockLength) {
            throw new IllegalArgumentException("Block size is different");
        }
        if (src.numRows < dst.numRows) {
            throw new IllegalArgumentException("The src has fewer rows than dst");
        }
        if (src.numCols < dst.numCols) {
            throw new IllegalArgumentException("The src has fewer columns than dst");
        }
        int blockLength = src.blockLength;
        int numRows = Math.min(src.numRows, dst.numRows);
        int numCols = Math.min(src.numCols, dst.numCols);
        int i = 0;
        while (i < numRows) {
            int heightSrc = Math.min(blockLength, src.numRows - i);
            int heightDst = Math.min(blockLength, dst.numRows - i);
            int j = 0;
            while (j < numCols) {
                int widthSrc = Math.min(blockLength, src.numCols - j);
                int widthDst = Math.min(blockLength, dst.numCols - j);
                int indexSrc = i * src.numCols + heightSrc * j;
                int indexDst = i * dst.numCols + heightDst * j;
                int k = 0;
                while (k < heightDst) {
                    System.arraycopy(src.data, indexSrc + widthSrc * k, dst.data, indexDst + widthDst * k, widthDst);
                    ++k;
                }
                j += blockLength;
            }
            i += blockLength;
        }
    }

    public static boolean blockAligned(int blockLength, D1Submatrix64F A) {
        if (A.col0 % blockLength != 0) {
            return false;
        }
        if (A.row0 % blockLength != 0) {
            return false;
        }
        if (A.col1 % blockLength != 0 && A.col1 != A.original.numCols) {
            return false;
        }
        return A.row1 % blockLength == 0 || A.row1 == A.original.numRows;
    }
}

