/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class TridiagonalDecompositionHouseholderOrig_D64 {
    DenseMatrix64F QT = new DenseMatrix64F(this.N, this.N);
    int N = 1;
    double[] w = new double[this.N];
    double[] gammas;
    double[] b = new double[this.N];

    public TridiagonalDecompositionHouseholderOrig_D64() {
        this.gammas = new double[this.N];
    }

    public DenseMatrix64F getQT() {
        return this.QT;
    }

    public DenseMatrix64F getT(DenseMatrix64F T) {
        if (T == null) {
            T = new DenseMatrix64F(this.N, this.N);
        } else {
            if (this.N != T.numRows || this.N != T.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            T.zero();
        }
        T.data[0] = this.QT.data[0];
        T.data[1] = this.QT.data[1];
        int i = 1;
        while (i < this.N - 1) {
            T.set(i, i, this.QT.get(i, i));
            T.set(i, i + 1, this.QT.get(i, i + 1));
            T.set(i, i - 1, this.QT.get(i - 1, i));
            ++i;
        }
        T.data[(this.N - 1) * this.N + this.N - 1] = this.QT.data[(this.N - 1) * this.N + this.N - 1];
        T.data[(this.N - 1) * this.N + this.N - 2] = this.QT.data[(this.N - 2) * this.N + this.N - 1];
        return T;
    }

    public DenseMatrix64F getQ(DenseMatrix64F Q) {
        int i;
        if (Q == null) {
            Q = new DenseMatrix64F(this.N, this.N);
            i = 0;
            while (i < this.N) {
                Q.data[i * this.N + i] = 1.0;
                ++i;
            }
        } else {
            if (this.N != Q.numRows || this.N != Q.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            CommonOps.setIdentity(Q);
        }
        i = 0;
        while (i < this.N) {
            this.w[i] = 0.0;
            ++i;
        }
        int j = this.N - 2;
        while (j >= 0) {
            this.w[j + 1] = 1.0;
            int i2 = j + 2;
            while (i2 < this.N) {
                this.w[i2] = this.QT.get(j, i2);
                ++i2;
            }
            QrHelperFunctions_D64.rank1UpdateMultR(Q, this.w, this.gammas[j + 1], j + 1, j + 1, this.N, this.b);
            --j;
        }
        return Q;
    }

    public void decompose(DenseMatrix64F A) {
        this.init(A);
        int k = 1;
        while (k < this.N) {
            this.similarTransform(k);
            ++k;
        }
    }

    private void similarTransform(int k) {
        double[] t = this.QT.data;
        double max = 0.0;
        int rowU = (k - 1) * this.N;
        int i = k;
        while (i < this.N) {
            double val = Math.abs(t[rowU + i]);
            if (val > max) {
                max = val;
            }
            ++i;
        }
        if (max > 0.0) {
            double gamma;
            double tau = 0.0;
            int i2 = k;
            while (i2 < this.N) {
                int n = rowU + i2;
                double d = t[n] / max;
                t[n] = d;
                double val = d;
                tau += val * val;
                ++i2;
            }
            tau = Math.sqrt(tau);
            if (t[rowU + k] < 0.0) {
                tau = -tau;
            }
            double nu = t[rowU + k] + tau;
            t[rowU + k] = 1.0;
            int i3 = k + 1;
            while (i3 < this.N) {
                int n = rowU + i3;
                t[n] = t[n] / nu;
                ++i3;
            }
            this.gammas[k] = gamma = nu / tau;
            this.householderSymmetric(k, gamma);
            t[rowU + k] = -tau * max;
        } else {
            this.gammas[k] = 0.0;
        }
    }

    public void householderSymmetric(int row, double gamma) {
        int startU = (row - 1) * this.N;
        int i = row;
        while (i < this.N) {
            double total = 0.0;
            int j = row;
            while (j < this.N) {
                total += this.QT.data[i * this.N + j] * this.QT.data[startU + j];
                ++j;
            }
            this.w[i] = -gamma * total;
            ++i;
        }
        double alpha = 0.0;
        int i2 = row;
        while (i2 < this.N) {
            alpha += this.QT.data[startU + i2] * this.w[i2];
            ++i2;
        }
        alpha *= -0.5 * gamma;
        i2 = row;
        while (i2 < this.N) {
            int n = i2;
            this.w[n] = this.w[n] + alpha * this.QT.data[startU + i2];
            ++i2;
        }
        i2 = row;
        while (i2 < this.N) {
            double ww = this.w[i2];
            double uu = this.QT.data[startU + i2];
            int j = i2;
            while (j < this.N) {
                int n = i2 * this.N + j;
                double d = this.QT.data[n] + (ww * this.QT.data[startU + j] + this.w[j] * uu);
                this.QT.data[n] = d;
                this.QT.data[j * this.N + i2] = d;
                ++j;
            }
            ++i2;
        }
    }

    public void init(DenseMatrix64F A) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("Must be square");
        }
        if (A.numCols != this.N) {
            this.N = A.numCols;
            this.QT.reshape(this.N, this.N, false);
            if (this.w.length < this.N) {
                this.w = new double[this.N];
                this.gammas = new double[this.N];
                this.b = new double[this.N];
            }
        }
        this.QT.set(A);
    }

    public double getGamma(int index) {
        return this.gammas[index];
    }
}

