/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixDimensionException;

public class MatrixMatrixMult {
    public static void mult_reorder(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps.fill(c, 0.0);
            return;
        }
        int indexCbase = 0;
        int endOfKLoop = b.numRows * b.numCols;
        int i = 0;
        while (i < a.numRows) {
            int indexA = i * a.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + b.numCols;
            double valA = a.get(indexA++);
            while (indexB < end) {
                c.set(indexC++, valA * b.get(indexB++));
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + b.numCols;
                valA = a.get(indexA++);
                while (indexB < end) {
                    c.plus(indexC++, valA * b.get(indexB++));
                }
            }
            indexCbase += c.numCols;
            ++i;
        }
    }

    public static void mult_small(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        int i = 0;
        while (i < a.numRows) {
            int j = 0;
            while (j < b.numCols) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + b.numRows;
                while (indexA < end) {
                    total += a.get(indexA++) * b.get(indexB);
                    indexB += b.numCols;
                }
                c.set(cIndex++, total);
                ++j;
            }
            aIndexStart += a.numCols;
            ++i;
        }
    }

    public static void mult_aux(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c, double[] aux) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b.numRows];
        }
        int j = 0;
        while (j < b.numCols) {
            int k = 0;
            while (k < b.numRows) {
                aux[k] = b.unsafe_get(k, j);
                ++k;
            }
            int indexA = 0;
            int i = 0;
            while (i < a.numRows) {
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numRows) {
                    total += a.get(indexA++) * aux[k2++];
                }
                c.set(i * c.numCols + j, total);
                ++i;
            }
            ++j;
        }
    }

    public static void multTransA_reorder(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps.fill(c, 0.0);
            return;
        }
        int i = 0;
        while (i < a.numCols) {
            int indexC_start = i * c.numCols;
            double valA = a.get(i);
            int indexB = 0;
            int end = indexB + b.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                c.set(indexC++, valA * b.get(indexB++));
            }
            int k = 1;
            while (k < a.numRows) {
                valA = a.unsafe_get(k, i);
                end = indexB + b.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    c.plus(indexC++, valA * b.get(indexB++));
                }
                ++k;
            }
            ++i;
        }
    }

    public static void multTransA_small(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int i = 0;
        while (i < a.numCols) {
            int j = 0;
            while (j < b.numCols) {
                int indexA = i;
                int indexB = j;
                int end = indexB + b.numRows * b.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a.get(indexA) * b.get(indexB);
                    indexA += a.numCols;
                    indexB += b.numCols;
                }
                c.set(cIndex++, total);
                ++j;
            }
            ++i;
        }
    }

    public static void multTransAB(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int i = 0;
        while (i < a.numCols) {
            int indexB = 0;
            int j = 0;
            while (j < b.numRows) {
                int indexA = i;
                int end = indexB + b.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a.get(indexA) * b.get(indexB++);
                    indexA += a.numCols;
                }
                c.set(cIndex++, total);
                ++j;
            }
            ++i;
        }
    }

    public static void multTransAB_aux(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c, double[] aux) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[a.numRows];
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps.fill(c, 0.0);
            return;
        }
        int indexC = 0;
        int i = 0;
        while (i < a.numCols) {
            int k = 0;
            while (k < b.numCols) {
                aux[k] = a.unsafe_get(k, i);
                ++k;
            }
            int j = 0;
            while (j < b.numRows) {
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numCols) {
                    total += aux[k2] * b.unsafe_get(j, k2);
                    ++k2;
                }
                c.set(indexC++, total);
                ++j;
            }
            ++i;
        }
    }

    public static void multTransB(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int aIndexStart = 0;
        int xA = 0;
        while (xA < a.numRows) {
            int end = aIndexStart + b.numCols;
            int indexB = 0;
            int xB = 0;
            while (xB < b.numRows) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += a.get(indexA++) * b.get(indexB++);
                }
                c.set(cIndex++, total);
                ++xB;
            }
            aIndexStart += a.numCols;
            ++xA;
        }
    }

    public static void multAdd_reorder(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int indexCbase = 0;
        int endOfKLoop = b.numRows * b.numCols;
        int i = 0;
        while (i < a.numRows) {
            int indexA = i * a.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + b.numCols;
            double valA = a.get(indexA++);
            while (indexB < end) {
                c.plus(indexC++, valA * b.get(indexB++));
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + b.numCols;
                valA = a.get(indexA++);
                while (indexB < end) {
                    c.plus(indexC++, valA * b.get(indexB++));
                }
            }
            indexCbase += c.numCols;
            ++i;
        }
    }

    public static void multAdd_small(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        int i = 0;
        while (i < a.numRows) {
            int j = 0;
            while (j < b.numCols) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + b.numRows;
                while (indexA < end) {
                    total += a.get(indexA++) * b.get(indexB);
                    indexB += b.numCols;
                }
                c.plus(cIndex++, total);
                ++j;
            }
            aIndexStart += a.numCols;
            ++i;
        }
    }

    public static void multAdd_aux(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c, double[] aux) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b.numRows];
        }
        int j = 0;
        while (j < b.numCols) {
            int k = 0;
            while (k < b.numRows) {
                aux[k] = b.unsafe_get(k, j);
                ++k;
            }
            int indexA = 0;
            int i = 0;
            while (i < a.numRows) {
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numRows) {
                    total += a.get(indexA++) * aux[k2++];
                }
                c.plus(i * c.numCols + j, total);
                ++i;
            }
            ++j;
        }
    }

    public static void multAddTransA_reorder(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int i = 0;
        while (i < a.numCols) {
            int indexC_start = i * c.numCols;
            double valA = a.get(i);
            int indexB = 0;
            int end = indexB + b.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                c.plus(indexC++, valA * b.get(indexB++));
            }
            int k = 1;
            while (k < a.numRows) {
                valA = a.unsafe_get(k, i);
                end = indexB + b.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    c.plus(indexC++, valA * b.get(indexB++));
                }
                ++k;
            }
            ++i;
        }
    }

    public static void multAddTransA_small(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int i = 0;
        while (i < a.numCols) {
            int j = 0;
            while (j < b.numCols) {
                int indexA = i;
                int indexB = j;
                int end = indexB + b.numRows * b.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a.get(indexA) * b.get(indexB);
                    indexA += a.numCols;
                    indexB += b.numCols;
                }
                c.plus(cIndex++, total);
                ++j;
            }
            ++i;
        }
    }

    public static void multAddTransAB(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int i = 0;
        while (i < a.numCols) {
            int indexB = 0;
            int j = 0;
            while (j < b.numRows) {
                int indexA = i;
                int end = indexB + b.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a.get(indexA) * b.get(indexB++);
                    indexA += a.numCols;
                }
                c.plus(cIndex++, total);
                ++j;
            }
            ++i;
        }
    }

    public static void multAddTransAB_aux(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c, double[] aux) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[a.numRows];
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int indexC = 0;
        int i = 0;
        while (i < a.numCols) {
            int k = 0;
            while (k < b.numCols) {
                aux[k] = a.unsafe_get(k, i);
                ++k;
            }
            int j = 0;
            while (j < b.numRows) {
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numCols) {
                    total += aux[k2] * b.unsafe_get(j, k2);
                    ++k2;
                }
                c.plus(indexC++, total);
                ++j;
            }
            ++i;
        }
    }

    public static void multAddTransB(RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int aIndexStart = 0;
        int xA = 0;
        while (xA < a.numRows) {
            int end = aIndexStart + b.numCols;
            int indexB = 0;
            int xB = 0;
            while (xB < b.numRows) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += a.get(indexA++) * b.get(indexB++);
                }
                c.plus(cIndex++, total);
                ++xB;
            }
            aIndexStart += a.numCols;
            ++xA;
        }
    }

    public static void mult_reorder(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps.fill(c, 0.0);
            return;
        }
        int indexCbase = 0;
        int endOfKLoop = b.numRows * b.numCols;
        int i = 0;
        while (i < a.numRows) {
            int indexA = i * a.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + b.numCols;
            double valA = alpha * a.get(indexA++);
            while (indexB < end) {
                c.set(indexC++, valA * b.get(indexB++));
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + b.numCols;
                valA = alpha * a.get(indexA++);
                while (indexB < end) {
                    c.plus(indexC++, valA * b.get(indexB++));
                }
            }
            indexCbase += c.numCols;
            ++i;
        }
    }

    public static void mult_small(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        int i = 0;
        while (i < a.numRows) {
            int j = 0;
            while (j < b.numCols) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + b.numRows;
                while (indexA < end) {
                    total += a.get(indexA++) * b.get(indexB);
                    indexB += b.numCols;
                }
                c.set(cIndex++, alpha * total);
                ++j;
            }
            aIndexStart += a.numCols;
            ++i;
        }
    }

    public static void mult_aux(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c, double[] aux) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b.numRows];
        }
        int j = 0;
        while (j < b.numCols) {
            int k = 0;
            while (k < b.numRows) {
                aux[k] = b.unsafe_get(k, j);
                ++k;
            }
            int indexA = 0;
            int i = 0;
            while (i < a.numRows) {
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numRows) {
                    total += a.get(indexA++) * aux[k2++];
                }
                c.set(i * c.numCols + j, alpha * total);
                ++i;
            }
            ++j;
        }
    }

    public static void multTransA_reorder(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps.fill(c, 0.0);
            return;
        }
        int i = 0;
        while (i < a.numCols) {
            int indexC_start = i * c.numCols;
            double valA = alpha * a.get(i);
            int indexB = 0;
            int end = indexB + b.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                c.set(indexC++, valA * b.get(indexB++));
            }
            int k = 1;
            while (k < a.numRows) {
                valA = alpha * a.unsafe_get(k, i);
                end = indexB + b.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    c.plus(indexC++, valA * b.get(indexB++));
                }
                ++k;
            }
            ++i;
        }
    }

    public static void multTransA_small(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int i = 0;
        while (i < a.numCols) {
            int j = 0;
            while (j < b.numCols) {
                int indexA = i;
                int indexB = j;
                int end = indexB + b.numRows * b.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a.get(indexA) * b.get(indexB);
                    indexA += a.numCols;
                    indexB += b.numCols;
                }
                c.set(cIndex++, alpha * total);
                ++j;
            }
            ++i;
        }
    }

    public static void multTransAB(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int i = 0;
        while (i < a.numCols) {
            int indexB = 0;
            int j = 0;
            while (j < b.numRows) {
                int indexA = i;
                int end = indexB + b.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a.get(indexA) * b.get(indexB++);
                    indexA += a.numCols;
                }
                c.set(cIndex++, alpha * total);
                ++j;
            }
            ++i;
        }
    }

    public static void multTransAB_aux(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c, double[] aux) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[a.numRows];
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps.fill(c, 0.0);
            return;
        }
        int indexC = 0;
        int i = 0;
        while (i < a.numCols) {
            int k = 0;
            while (k < b.numCols) {
                aux[k] = a.unsafe_get(k, i);
                ++k;
            }
            int j = 0;
            while (j < b.numRows) {
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numCols) {
                    total += aux[k2] * b.unsafe_get(j, k2);
                    ++k2;
                }
                c.set(indexC++, alpha * total);
                ++j;
            }
            ++i;
        }
    }

    public static void multTransB(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int aIndexStart = 0;
        int xA = 0;
        while (xA < a.numRows) {
            int end = aIndexStart + b.numCols;
            int indexB = 0;
            int xB = 0;
            while (xB < b.numRows) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += a.get(indexA++) * b.get(indexB++);
                }
                c.set(cIndex++, alpha * total);
                ++xB;
            }
            aIndexStart += a.numCols;
            ++xA;
        }
    }

    public static void multAdd_reorder(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int indexCbase = 0;
        int endOfKLoop = b.numRows * b.numCols;
        int i = 0;
        while (i < a.numRows) {
            int indexA = i * a.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + b.numCols;
            double valA = alpha * a.get(indexA++);
            while (indexB < end) {
                c.plus(indexC++, valA * b.get(indexB++));
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + b.numCols;
                valA = alpha * a.get(indexA++);
                while (indexB < end) {
                    c.plus(indexC++, valA * b.get(indexB++));
                }
            }
            indexCbase += c.numCols;
            ++i;
        }
    }

    public static void multAdd_small(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        int i = 0;
        while (i < a.numRows) {
            int j = 0;
            while (j < b.numCols) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + b.numRows;
                while (indexA < end) {
                    total += a.get(indexA++) * b.get(indexB);
                    indexB += b.numCols;
                }
                c.plus(cIndex++, alpha * total);
                ++j;
            }
            aIndexStart += a.numCols;
            ++i;
        }
    }

    public static void multAdd_aux(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c, double[] aux) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b.numRows];
        }
        int j = 0;
        while (j < b.numCols) {
            int k = 0;
            while (k < b.numRows) {
                aux[k] = b.unsafe_get(k, j);
                ++k;
            }
            int indexA = 0;
            int i = 0;
            while (i < a.numRows) {
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numRows) {
                    total += a.get(indexA++) * aux[k2++];
                }
                c.plus(i * c.numCols + j, alpha * total);
                ++i;
            }
            ++j;
        }
    }

    public static void multAddTransA_reorder(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int i = 0;
        while (i < a.numCols) {
            int indexC_start = i * c.numCols;
            double valA = alpha * a.get(i);
            int indexB = 0;
            int end = indexB + b.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                c.plus(indexC++, valA * b.get(indexB++));
            }
            int k = 1;
            while (k < a.numRows) {
                valA = alpha * a.unsafe_get(k, i);
                end = indexB + b.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    c.plus(indexC++, valA * b.get(indexB++));
                }
                ++k;
            }
            ++i;
        }
    }

    public static void multAddTransA_small(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int i = 0;
        while (i < a.numCols) {
            int j = 0;
            while (j < b.numCols) {
                int indexA = i;
                int indexB = j;
                int end = indexB + b.numRows * b.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a.get(indexA) * b.get(indexB);
                    indexA += a.numCols;
                    indexB += b.numCols;
                }
                c.plus(cIndex++, alpha * total);
                ++j;
            }
            ++i;
        }
    }

    public static void multAddTransAB(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int i = 0;
        while (i < a.numCols) {
            int indexB = 0;
            int j = 0;
            while (j < b.numRows) {
                int indexA = i;
                int end = indexB + b.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a.get(indexA) * b.get(indexB++);
                    indexA += a.numCols;
                }
                c.plus(cIndex++, alpha * total);
                ++j;
            }
            ++i;
        }
    }

    public static void multAddTransAB_aux(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c, double[] aux) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[a.numRows];
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int indexC = 0;
        int i = 0;
        while (i < a.numCols) {
            int k = 0;
            while (k < b.numCols) {
                aux[k] = a.unsafe_get(k, i);
                ++k;
            }
            int j = 0;
            while (j < b.numRows) {
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numCols) {
                    total += aux[k2] * b.unsafe_get(j, k2);
                    ++k2;
                }
                c.plus(indexC++, alpha * total);
                ++j;
            }
            ++i;
        }
    }

    public static void multAddTransB(double alpha, RowD1Matrix64F a, RowD1Matrix64F b, RowD1Matrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int aIndexStart = 0;
        int xA = 0;
        while (xA < a.numRows) {
            int end = aIndexStart + b.numCols;
            int indexB = 0;
            int xB = 0;
            while (xB < b.numRows) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += a.get(indexA++) * b.get(indexB++);
                }
                c.plus(cIndex++, alpha * total);
                ++xB;
            }
            aIndexStart += a.numCols;
            ++xA;
        }
    }
}

