/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.densed2.mult;

import org.ejml.data.DenseD2Matrix64F;
import org.ejml.ops.MatrixDimensionException;

public class MatrixMatrixMult_D2 {
    public static void mult_small(DenseD2Matrix64F a, DenseD2Matrix64F b, DenseD2Matrix64F c) {
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        double[][] dataA = a.data;
        double[][] dataB = b.data;
        double[][] dataR = c.data;
        int i = 0;
        while (i < a.numRows) {
            double[] dataAi = dataA[i];
            double[] dataRi = dataR[i];
            int j = 0;
            while (j < b.numCols) {
                double total = 0.0;
                int k = 0;
                while (k < a.numCols) {
                    total += dataAi[k] * dataB[k][j];
                    ++k;
                }
                dataRi[j] = total;
                ++j;
            }
            ++i;
        }
    }

    public static void mult_aux(DenseD2Matrix64F a, DenseD2Matrix64F b, DenseD2Matrix64F c, double[] aux) {
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b.numRows];
        }
        double[][] dataA = a.data;
        double[][] dataB = b.data;
        double[][] dataR = c.data;
        int j = 0;
        while (j < b.numCols) {
            int k = 0;
            while (k < b.numRows) {
                aux[k] = dataB[k][j];
                ++k;
            }
            int i = 0;
            while (i < a.numRows) {
                double[] dataAi = dataA[i];
                double total = 0.0;
                int k2 = 0;
                while (k2 < b.numRows) {
                    total += dataAi[k2] * aux[k2++];
                }
                dataR[i][j] = total;
                ++i;
            }
            ++j;
        }
    }
}

