/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.ui.export.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.ChromatogramReports;
import org.eclipse.chemclipse.chromatogram.xxd.report.ui.export.wizards.ReportSupplierSelectionWizardPage;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.converter.processing.chromatogram.IChromatogramMSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.ux.extension.msd.ui.wizards.ChromatogramSelectionWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ChromatogramReportExportWizard
extends Wizard
implements IExportWizard {
    private static final Logger logger = Logger.getLogger(ChromatogramReportExportWizard.class);
    private static final String DESCRIPTION = "Chromatogram Report";
    private static final String CONVERTER_ID = "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse";
    private ChromatogramSelectionWizardPage chromatogramSelectionWizardPage;
    private ReportSupplierSelectionWizardPage reportSupplierSelectionWizardPage;

    public ChromatogramReportExportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Chromatogram Report Wizard");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.chromatogramSelectionWizardPage = new ChromatogramSelectionWizardPage(DESCRIPTION, "Select (*.ocb) chromatograms for reporting", null);
        this.addPage((IWizardPage)this.chromatogramSelectionWizardPage);
        this.reportSupplierSelectionWizardPage = new ReportSupplierSelectionWizardPage(DESCRIPTION, "Select the report provider", null);
        this.addPage((IWizardPage)this.reportSupplierSelectionWizardPage);
    }

    public boolean performFinish() {
        final List<String> inputFiles = this.getInputFiles();
        final Map<String, String> reportSupplier = this.getReportSupplier();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    Set reportSupplierIds = reportSupplier.keySet();
                    for (String reportSupplierId : reportSupplierIds) {
                        for (String inputFile : inputFiles) {
                            File chromatogramFile = new File(inputFile);
                            IChromatogramMSDImportConverterProcessingInfo processingInfo = ChromatogramConverterMSD.convert((File)chromatogramFile, (String)ChromatogramReportExportWizard.CONVERTER_ID, (IProgressMonitor)monitor);
                            try {
                                boolean appendReport;
                                IChromatogramMSD chromatogram = processingInfo.getChromatogram();
                                if (chromatogram == null) continue;
                                String reportFolderOrFile = (String)reportSupplier.get(reportSupplierId);
                                File chromatogramReportFile = new File(reportFolderOrFile);
                                if (chromatogramReportFile.isDirectory()) {
                                    appendReport = false;
                                    if (!reportFolderOrFile.endsWith(File.separator)) {
                                        reportFolderOrFile = String.valueOf(reportFolderOrFile) + File.separator;
                                    }
                                    chromatogramReportFile = new File(String.valueOf(reportFolderOrFile) + chromatogram.getName());
                                } else {
                                    appendReport = true;
                                }
                                ChromatogramReports.generate((File)chromatogramReportFile, (boolean)appendReport, (IChromatogram)chromatogram, (String)reportSupplierId, (IProgressMonitor)monitor);
                            }
                            catch (TypeCastException e) {
                                logger.warn((Object)e);
                            }
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
            this.showErrorMessage();
            return false;
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
            this.showErrorMessage();
            return false;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)DESCRIPTION, (String)"The reports have been created successfully.");
        return true;
    }

    private List<String> getInputFiles() {
        TableItem[] items;
        ArrayList<String> inputFiles = new ArrayList<String>();
        Table inputFilesTable = this.chromatogramSelectionWizardPage.getTable();
        TableItem[] tableItemArray = items = inputFilesTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            inputFiles.add(item.getText(1));
            ++n2;
        }
        return inputFiles;
    }

    private Map<String, String> getReportSupplier() {
        TableItem[] items;
        HashMap<String, String> reportSupplier = new HashMap<String, String>();
        Table reportSupplierTable = this.reportSupplierSelectionWizardPage.getTable();
        TableItem[] tableItemArray = items = reportSupplierTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String reportFolder = item.getText(1);
            String reportSupplierId = item.getText(2);
            reportSupplier.put(reportSupplierId, reportFolder);
            ++n2;
        }
        return reportSupplier;
    }

    private void showErrorMessage() {
        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"An error has occurred reporting the chromatograms.");
    }
}

