/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.processor;

import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.stat.StatUtils;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.settings.ISupplierFilterSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.core.runtime.IProgressMonitor;

public class SavitzkyGolayProcessor {
    public IChromatogramFilterResult smooth(IChromatogramSelection chromatogramSelection, boolean validatePositive, ISupplierFilterSettings supplierFilterSettings, IProgressMonitor monitor) {
        ChromatogramFilterResult chromatogramFilterResult;
        try {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            TotalScanSignalExtractor signalExtractor = new TotalScanSignalExtractor(chromatogram);
            ITotalScanSignals totalScanSignals = signalExtractor.getTotalScanSignals(chromatogramSelection, validatePositive);
            double[] sgTic = this.smooth(totalScanSignals, supplierFilterSettings, monitor);
            int i = 0;
            for (ITotalScanSignal signal : totalScanSignals.getTotalScanSignals()) {
                signal.setTotalSignal((float)sgTic[i++]);
            }
            int startScan = totalScanSignals.getStartScan();
            int stopScan = totalScanSignals.getStopScan();
            int scan = startScan;
            while (scan <= stopScan) {
                monitor.subTask("Set Savitzky-Golay TIC: " + scan);
                IScan scanRecord = chromatogram.getScan(scan);
                float intensity = totalScanSignals.getTotalScanSignal(scan).getTotalSignal();
                if (validatePositive && intensity <= 0.0f) {
                    intensity = 0.1f;
                }
                scanRecord.adjustTotalSignal(intensity);
                ++scan;
            }
            chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.OK, "The Savitzky-Golay filter has been applied successfully.");
        }
        catch (ChromatogramIsNullException chromatogramIsNullException) {
            chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.EXCEPTION, "Something has gone wrong to apply the Savitzky-Golay filter.");
        }
        return chromatogramFilterResult;
    }

    public double[] smooth(double[] ticValues, ISupplierFilterSettings supplierFilterSettings, IProgressMonitor monitor) {
        return this.smoothValues(ticValues, supplierFilterSettings);
    }

    public double[] smooth(ITotalScanSignals totalScanSignals, ISupplierFilterSettings supplierFilterSettings, IProgressMonitor monitor) {
        int size = totalScanSignals.size();
        double[] ticValues = new double[size];
        int column = 0;
        for (ITotalScanSignal signal : totalScanSignals.getTotalScanSignals()) {
            ticValues[column++] = signal.getTotalSignal();
        }
        return this.smoothValues(ticValues, supplierFilterSettings);
    }

    private double[] smoothValues(double[] ticValues, ISupplierFilterSettings supplierFilterSettings) {
        int derivative = supplierFilterSettings.getDerivative();
        int order = supplierFilterSettings.getOrder();
        int width = supplierFilterSettings.getWidth();
        int p = this.calculateP(width);
        int size = ticValues.length;
        width = Math.max(5, 1 + 2 * Math.round((width - 1) / 2));
        order = (int)StatUtils.min((double[])new double[]{Math.max(0, order), 5.0, width - 1});
        derivative = Math.min(Math.max(0, derivative), order);
        RealMatrix x = this.getX(width, order);
        double[] coefficients = this.calculateCoefficient(derivative, order);
        double[][] weights = this.getWeights(width, order, derivative);
        double[] middleWeights = weights[derivative];
        double[] newTicValues = new double[size];
        double[][] startStopWeights = new double[order - derivative + 1][weights[0].length];
        int i = derivative;
        int k = 0;
        while (i <= order) {
            int j = 0;
            while (j < weights[0].length) {
                startStopWeights[k][j] = weights[i][j];
                ++j;
            }
            ++i;
            ++k;
        }
        i = 0;
        while (i < coefficients.length) {
            double coefficient = coefficients[i];
            int j = 0;
            while (j < startStopWeights[i].length) {
                double[] dArray = startStopWeights[i];
                int n = j++;
                dArray[n] = dArray[n] * coefficient;
            }
            ++i;
        }
        this.processStart(p, order, derivative, width, x, ticValues, newTicValues, startStopWeights);
        this.processMiddle(p, ticValues, newTicValues, middleWeights, coefficients);
        this.processEnd(p, order, derivative, width, x, ticValues, newTicValues, startStopWeights);
        return newTicValues;
    }

    private void processStart(int p, int order, int derivative, int width, RealMatrix x, double[] ticValues, double[] newTicValues, double[][] startStopWeights) {
        double[][] uStart = new double[p][order - derivative + 1];
        int i = 0;
        while (i < p) {
            int j = 0;
            while (j < order - derivative + 1) {
                uStart[i][j] = x.getEntry(i, j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < p) {
            double[] values = new double[width];
            int j = 0;
            while (j < width) {
                double newVal = 0.0;
                int k = 0;
                while (k < order - derivative + 1) {
                    newVal += uStart[i][k] * startStopWeights[k][j];
                    ++k;
                }
                values[j] = newVal;
                ++j;
            }
            double newTic = 0.0;
            int j2 = 0;
            while (j2 < width) {
                newTic += ticValues[j2] * values[j2];
                ++j2;
            }
            newTicValues[i] = newTic;
            ++i;
        }
    }

    private void processMiddle(int p, double[] ticValues, double[] newTicValues, double[] middleWeights, double[] coefficients) {
        int i = p;
        while (i < ticValues.length - p) {
            double newTic = 0.0;
            int j = -p;
            int k = 0;
            while (j <= p) {
                double ticValue = ticValues[i + j];
                double sgValue = middleWeights[k];
                newTic += ticValue * sgValue * coefficients[0];
                ++j;
                ++k;
            }
            newTicValues[i] = newTic;
            ++i;
        }
    }

    private void processEnd(int p, int order, int derivative, int width, RealMatrix x, double[] ticValues, double[] newTicValues, double[][] startStopWeights) {
        double[][] uEnd = new double[p][order - derivative + 1];
        int i = p + 1;
        int k = 0;
        while (i < x.getRowDimension()) {
            int j = 0;
            while (j < order - derivative + 1) {
                uEnd[k][j] = x.getEntry(i, j);
                ++j;
            }
            ++i;
            ++k;
        }
        i = ticValues.length - p;
        int m = 0;
        while (i < ticValues.length) {
            int k2;
            double[] values = new double[width];
            int j = 0;
            while (j < width) {
                double newVal = 0.0;
                k2 = 0;
                while (k2 < order - derivative + 1) {
                    newVal += uEnd[m][k2] * startStopWeights[k2][j];
                    ++k2;
                }
                values[j] = newVal;
                ++j;
            }
            double newTic = 0.0;
            int j2 = 0;
            k2 = ticValues.length - width;
            while (j2 < width) {
                newTic += ticValues[k2] * values[j2];
                ++j2;
                ++k2;
            }
            newTicValues[i] = newTic;
            ++i;
            ++m;
        }
    }

    private double[][] getWeights(int width, int order, int derivative) {
        RealMatrix x = this.getX(width, order);
        RealMatrix dm = MatrixUtils.createRealIdentityMatrix((int)width);
        QRDecomposition qrDecomposition = new QRDecomposition(x);
        RealMatrix q = qrDecomposition.getQ();
        RealMatrix r2 = qrDecomposition.getR();
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(x);
        int r = singularValueDecomposition.getRank();
        RealMatrix q2 = q.getSubMatrix(0, q.getRowDimension() - 1, 0, r - 1);
        RealMatrix r3 = r2.getSubMatrix(0, r - 1, 0, r2.getColumnDimension() - 1);
        RealMatrix weights2 = new LUDecomposition(r3).getSolver().getInverse().multiply(q2.transpose().multiply(dm));
        double[][] weights = new double[weights2.getRowDimension()][weights2.getColumnDimension()];
        int i = 0;
        while (i < weights2.getRowDimension()) {
            int j = 0;
            while (j < weights2.getColumnDimension()) {
                weights[i][j] = weights2.getEntry(i, j);
                ++j;
            }
            ++i;
        }
        return weights;
    }

    private RealMatrix getX(int width, int order) {
        int rows = width;
        int columns = 1 + order;
        int p = this.calculateP(width);
        double[][] t1 = this.createT1(rows, columns, -p);
        double[][] t2 = this.createT2(rows, columns, 0);
        return MatrixUtils.createRealMatrix((double[][])this.calculateX(t1, t2));
    }

    private int calculateP(int width) {
        return (width - 1) / 2;
    }

    private double[][] createT1(int rows, int columns, int min) {
        double[][] array = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                array[i][j] = min;
                ++j;
            }
            ++min;
            ++i;
        }
        return array;
    }

    private double[][] createT2(int rows, int columns, int min) {
        double[][] array = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int value = min;
            int j = 0;
            while (j < columns) {
                array[i][j] = value++;
                ++j;
            }
            ++i;
        }
        return array;
    }

    private double[][] calculateX(double[][] t1, double[][] t2) {
        int rows = t1.length;
        int columns = t1[0].length;
        double[][] array = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                array[i][j] = Math.pow(t1[i][j], t2[i][j]);
                ++j;
            }
            ++i;
        }
        return array;
    }

    private double[] calculateCoefficient(int derivative, int order) {
        double[] result;
        if (derivative > 0) {
            int j;
            int val1 = order + 1 - derivative;
            double[][] t3 = this.createOnes(derivative, 1);
            double[] t4 = this.createArray(val1, 1);
            double[][] t34 = new double[t3.length][t4.length];
            int i = 0;
            while (i < t3.length) {
                double valt3 = t3[i][0];
                int j2 = 0;
                while (j2 < t4.length) {
                    t34[i][j2] = valt3 * t4[j2];
                    ++j2;
                }
                ++i;
            }
            double[] t5 = this.createArray(derivative, 0);
            double[][] t6 = this.createOnes(1, val1);
            double[][] t56 = new double[t5.length][t6[0].length];
            int i2 = 0;
            while (i2 < t5.length) {
                double valt5 = t5[i2];
                j = 0;
                while (j < t6[0].length) {
                    t56[i2][j] = valt5 * t6[0][j];
                    ++j;
                }
                ++i2;
            }
            int size = t34[0].length;
            result = new double[size];
            int rows = t34.length;
            int columns = t34[0].length;
            j = 0;
            while (j < columns) {
                double product = 1.0;
                int i3 = 0;
                while (i3 < rows) {
                    product *= t34[i3][j] + t56[i3][j];
                    ++i3;
                }
                result[j] = product;
                ++j;
            }
        } else {
            int size = order + 1;
            result = new double[size];
            int i = 0;
            while (i < size) {
                result[i] = 1.0;
                ++i;
            }
        }
        return result;
    }

    private double[][] createOnes(int rows, int columns) {
        double[][] array = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                array[i][j] = 1.0;
                ++j;
            }
            ++i;
        }
        return array;
    }

    private double[] createArray(int size, int start) {
        double[] array = new double[size];
        int value = start;
        int i = 0;
        while (i < size) {
            array[i] = value++;
            ++i;
        }
        return array;
    }
}

