/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.report.chromatogram.AbstractChromatogramReportGenerator;
import org.eclipse.chemclipse.chromatogram.xxd.report.processing.ChromatogramReportProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.report.processing.IChromatogramReportProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.report.settings.IChromatogramReportSettings;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.internal.support.SpecificationValidator;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.io.ChromatogramReport;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.settings.IChemClipseChromatogramReportSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReportGenerator
extends AbstractChromatogramReportGenerator {
    private static final Logger logger = Logger.getLogger(ChromatogramReportGenerator.class);

    public IChromatogramReportProcessingInfo generate(File file, boolean append, IChromatogram chromatogram, IChromatogramReportSettings chromatogramReportSettings, IProgressMonitor monitor) {
        List<IChromatogram> chromatograms = this.getChromatogramList(chromatogram);
        IChemClipseChromatogramReportSettings settings = this.getSettings(chromatogramReportSettings);
        return this.report(file, append, chromatograms, settings, monitor);
    }

    public IChromatogramReportProcessingInfo generate(File file, boolean append, IChromatogram chromatogram, IProgressMonitor monitor) {
        List<IChromatogram> chromatograms = this.getChromatogramList(chromatogram);
        IChemClipseChromatogramReportSettings settings = this.getSettings(null);
        return this.report(file, append, chromatograms, settings, monitor);
    }

    public IChromatogramReportProcessingInfo generate(File file, boolean append, List<IChromatogram> chromatograms, IChromatogramReportSettings chromatogramReportSettings, IProgressMonitor monitor) {
        IChemClipseChromatogramReportSettings settings = this.getSettings(chromatogramReportSettings);
        return this.report(file, append, chromatograms, settings, monitor);
    }

    public IChromatogramReportProcessingInfo generate(File file, boolean append, List<IChromatogram> chromatograms, IProgressMonitor monitor) {
        IChemClipseChromatogramReportSettings settings = this.getSettings(null);
        return this.report(file, append, chromatograms, settings, monitor);
    }

    private IChromatogramReportProcessingInfo report(File file, boolean append, List<IChromatogram> chromatograms, IChemClipseChromatogramReportSettings chromatogramReportSettings, IProgressMonitor monitor) {
        ChromatogramReportProcessingInfo processingInfo = new ChromatogramReportProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file = SpecificationValidator.validateSpecification(file));
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            ChromatogramReport chromatogramReport = new ChromatogramReport();
            try {
                chromatogramReport.generate(file, append, chromatograms, chromatogramReportSettings, monitor);
                processingInfo.setFile(file);
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("ChemClipse Chromatogram Report", "The report couldn't be created. An error occured.");
            }
        }
        return processingInfo;
    }

    private List<IChromatogram> getChromatogramList(IChromatogram chromatogram) {
        ArrayList<IChromatogram> chromatograms = new ArrayList<IChromatogram>();
        chromatograms.add(chromatogram);
        return chromatograms;
    }

    private IChemClipseChromatogramReportSettings getSettings(IChromatogramReportSettings chromatogramReportSettings) {
        if (chromatogramReportSettings == null) {
            return PreferenceSupplier.getChromatogramReportSettings();
        }
        if (chromatogramReportSettings instanceof IChemClipseChromatogramReportSettings) {
            return (IChemClipseChromatogramReportSettings)chromatogramReportSettings;
        }
        return PreferenceSupplier.getChromatogramReportSettings();
    }
}

