/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.ULocale;
import java.util.BitSet;
import java.util.Locale;

public final class UScript {
    public static final int INVALID_CODE = -1;
    public static final int COMMON = 0;
    public static final int INHERITED = 1;
    public static final int ARABIC = 2;
    public static final int ARMENIAN = 3;
    public static final int BENGALI = 4;
    public static final int BOPOMOFO = 5;
    public static final int CHEROKEE = 6;
    public static final int COPTIC = 7;
    public static final int CYRILLIC = 8;
    public static final int DESERET = 9;
    public static final int DEVANAGARI = 10;
    public static final int ETHIOPIC = 11;
    public static final int GEORGIAN = 12;
    public static final int GOTHIC = 13;
    public static final int GREEK = 14;
    public static final int GUJARATI = 15;
    public static final int GURMUKHI = 16;
    public static final int HAN = 17;
    public static final int HANGUL = 18;
    public static final int HEBREW = 19;
    public static final int HIRAGANA = 20;
    public static final int KANNADA = 21;
    public static final int KATAKANA = 22;
    public static final int KHMER = 23;
    public static final int LAO = 24;
    public static final int LATIN = 25;
    public static final int MALAYALAM = 26;
    public static final int MONGOLIAN = 27;
    public static final int MYANMAR = 28;
    public static final int OGHAM = 29;
    public static final int OLD_ITALIC = 30;
    public static final int ORIYA = 31;
    public static final int RUNIC = 32;
    public static final int SINHALA = 33;
    public static final int SYRIAC = 34;
    public static final int TAMIL = 35;
    public static final int TELUGU = 36;
    public static final int THAANA = 37;
    public static final int THAI = 38;
    public static final int TIBETAN = 39;
    public static final int CANADIAN_ABORIGINAL = 40;
    public static final int UCAS = 40;
    public static final int YI = 41;
    public static final int TAGALOG = 42;
    public static final int HANUNOO = 43;
    public static final int BUHID = 44;
    public static final int TAGBANWA = 45;
    public static final int BRAILLE = 46;
    public static final int CYPRIOT = 47;
    public static final int LIMBU = 48;
    public static final int LINEAR_B = 49;
    public static final int OSMANYA = 50;
    public static final int SHAVIAN = 51;
    public static final int TAI_LE = 52;
    public static final int UGARITIC = 53;
    public static final int KATAKANA_OR_HIRAGANA = 54;
    public static final int BUGINESE = 55;
    public static final int GLAGOLITIC = 56;
    public static final int KHAROSHTHI = 57;
    public static final int SYLOTI_NAGRI = 58;
    public static final int NEW_TAI_LUE = 59;
    public static final int TIFINAGH = 60;
    public static final int OLD_PERSIAN = 61;
    public static final int BALINESE = 62;
    public static final int BATAK = 63;
    public static final int BLISSYMBOLS = 64;
    public static final int BRAHMI = 65;
    public static final int CHAM = 66;
    public static final int CIRTH = 67;
    public static final int OLD_CHURCH_SLAVONIC_CYRILLIC = 68;
    public static final int DEMOTIC_EGYPTIAN = 69;
    public static final int HIERATIC_EGYPTIAN = 70;
    public static final int EGYPTIAN_HIEROGLYPHS = 71;
    public static final int KHUTSURI = 72;
    public static final int SIMPLIFIED_HAN = 73;
    public static final int TRADITIONAL_HAN = 74;
    public static final int PAHAWH_HMONG = 75;
    public static final int OLD_HUNGARIAN = 76;
    public static final int HARAPPAN_INDUS = 77;
    public static final int JAVANESE = 78;
    public static final int KAYAH_LI = 79;
    public static final int LATIN_FRAKTUR = 80;
    public static final int LATIN_GAELIC = 81;
    public static final int LEPCHA = 82;
    public static final int LINEAR_A = 83;
    public static final int MANDAIC = 84;
    public static final int MANDAEAN = 84;
    public static final int MAYAN_HIEROGLYPHS = 85;
    public static final int MEROITIC_HIEROGLYPHS = 86;
    public static final int MEROITIC = 86;
    public static final int NKO = 87;
    public static final int ORKHON = 88;
    public static final int OLD_PERMIC = 89;
    public static final int PHAGS_PA = 90;
    public static final int PHOENICIAN = 91;
    public static final int MIAO = 92;
    public static final int PHONETIC_POLLARD = 92;
    public static final int RONGORONGO = 93;
    public static final int SARATI = 94;
    public static final int ESTRANGELO_SYRIAC = 95;
    public static final int WESTERN_SYRIAC = 96;
    public static final int EASTERN_SYRIAC = 97;
    public static final int TENGWAR = 98;
    public static final int VAI = 99;
    public static final int VISIBLE_SPEECH = 100;
    public static final int CUNEIFORM = 101;
    public static final int UNWRITTEN_LANGUAGES = 102;
    public static final int UNKNOWN = 103;
    public static final int CARIAN = 104;
    public static final int JAPANESE = 105;
    public static final int LANNA = 106;
    public static final int LYCIAN = 107;
    public static final int LYDIAN = 108;
    public static final int OL_CHIKI = 109;
    public static final int REJANG = 110;
    public static final int SAURASHTRA = 111;
    public static final int SIGN_WRITING = 112;
    public static final int SUNDANESE = 113;
    public static final int MOON = 114;
    public static final int MEITEI_MAYEK = 115;
    public static final int IMPERIAL_ARAMAIC = 116;
    public static final int AVESTAN = 117;
    public static final int CHAKMA = 118;
    public static final int KOREAN = 119;
    public static final int KAITHI = 120;
    public static final int MANICHAEAN = 121;
    public static final int INSCRIPTIONAL_PAHLAVI = 122;
    public static final int PSALTER_PAHLAVI = 123;
    public static final int BOOK_PAHLAVI = 124;
    public static final int INSCRIPTIONAL_PARTHIAN = 125;
    public static final int SAMARITAN = 126;
    public static final int TAI_VIET = 127;
    public static final int MATHEMATICAL_NOTATION = 128;
    public static final int SYMBOLS = 129;
    public static final int BAMUM = 130;
    public static final int LISU = 131;
    public static final int NAKHI_GEBA = 132;
    public static final int OLD_SOUTH_ARABIAN = 133;
    public static final int BASSA_VAH = 134;
    public static final int DUPLOYAN = 135;
    @Deprecated
    public static final int DUPLOYAN_SHORTAND = 135;
    public static final int ELBASAN = 136;
    public static final int GRANTHA = 137;
    public static final int KPELLE = 138;
    public static final int LOMA = 139;
    public static final int MENDE = 140;
    public static final int MEROITIC_CURSIVE = 141;
    public static final int OLD_NORTH_ARABIAN = 142;
    public static final int NABATAEAN = 143;
    public static final int PALMYRENE = 144;
    public static final int KHUDAWADI = 145;
    public static final int SINDHI = 145;
    public static final int WARANG_CITI = 146;
    public static final int AFAKA = 147;
    public static final int JURCHEN = 148;
    public static final int MRO = 149;
    public static final int NUSHU = 150;
    public static final int SHARADA = 151;
    public static final int SORA_SOMPENG = 152;
    public static final int TAKRI = 153;
    public static final int TANGUT = 154;
    public static final int WOLEAI = 155;
    public static final int ANATOLIAN_HIEROGLYPHS = 156;
    public static final int KHOJKI = 157;
    public static final int TIRHUTA = 158;
    public static final int CAUCASIAN_ALBANIAN = 159;
    public static final int MAHAJANI = 160;
    public static final int AHOM = 161;
    public static final int HATRAN = 162;
    public static final int MODI = 163;
    public static final int MULTANI = 164;
    public static final int PAU_CIN_HAU = 165;
    public static final int SIDDHAM = 166;
    public static final int ADLAM = 167;
    public static final int BHAIKSUKI = 168;
    public static final int MARCHEN = 169;
    public static final int NEWA = 170;
    public static final int OSAGE = 171;
    public static final int HAN_WITH_BOPOMOFO = 172;
    public static final int JAMO = 173;
    public static final int SYMBOLS_EMOJI = 174;
    @Deprecated
    public static final int CODE_LIMIT = 175;
    private static final ScriptUsage[] usageValues = ScriptUsage.values();

    private static int[] getCodesFromLocale(ULocale locale) {
        int scriptCode;
        String lang = locale.getLanguage();
        if (lang.equals("ja")) {
            return new int[]{22, 20, 17};
        }
        if (lang.equals("ko")) {
            return new int[]{18, 17};
        }
        String script = locale.getScript();
        if (lang.equals("zh") && script.equals("Hant")) {
            return new int[]{17, 5};
        }
        if (script.length() != 0 && (scriptCode = UScript.getCodeFromName(script)) != -1) {
            if (scriptCode == 73 || scriptCode == 74) {
                scriptCode = 17;
            }
            return new int[]{scriptCode};
        }
        return null;
    }

    private static int[] findCodeFromLocale(ULocale locale) {
        int[] result = UScript.getCodesFromLocale(locale);
        if (result != null) {
            return result;
        }
        ULocale likely = ULocale.addLikelySubtags(locale);
        return UScript.getCodesFromLocale(likely);
    }

    public static final int[] getCode(Locale locale) {
        return UScript.findCodeFromLocale(ULocale.forLocale(locale));
    }

    public static final int[] getCode(ULocale locale) {
        return UScript.findCodeFromLocale(locale);
    }

    public static final int[] getCode(String nameOrAbbrOrLocale) {
        int propNum;
        int[] scripts;
        boolean triedCode = false;
        if (nameOrAbbrOrLocale.indexOf(95) < 0 && nameOrAbbrOrLocale.indexOf(45) < 0) {
            int propNum2 = UCharacter.getPropertyValueEnumNoThrow(4106, nameOrAbbrOrLocale);
            if (propNum2 != -1) {
                return new int[]{propNum2};
            }
            triedCode = true;
        }
        if ((scripts = UScript.findCodeFromLocale(new ULocale(nameOrAbbrOrLocale))) != null) {
            return scripts;
        }
        if (!triedCode && (propNum = UCharacter.getPropertyValueEnumNoThrow(4106, nameOrAbbrOrLocale)) != -1) {
            return new int[]{propNum};
        }
        return null;
    }

    public static final int getCodeFromName(String nameOrAbbr) {
        int propNum = UCharacter.getPropertyValueEnumNoThrow(4106, nameOrAbbr);
        return propNum == -1 ? -1 : propNum;
    }

    public static final int getScript(int codepoint) {
        if (codepoint >= 0 & codepoint <= 0x10FFFF) {
            int scriptX = UCharacterProperty.INSTANCE.getAdditional(codepoint, 0) & 0xC000FF;
            if (scriptX < 0x400000) {
                return scriptX;
            }
            if (scriptX < 0x800000) {
                return 0;
            }
            if (scriptX < 0xC00000) {
                return 1;
            }
            return UCharacterProperty.INSTANCE.m_scriptExtensions_[scriptX & 0xFF];
        }
        throw new IllegalArgumentException(Integer.toString(codepoint));
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean hasScript(int c, int sc) {
        scriptX = UCharacterProperty.INSTANCE.getAdditional(c, 0) & 0xC000FF;
        if (scriptX < 0x400000) {
            return sc == scriptX;
        }
        scriptExtensions = UCharacterProperty.INSTANCE.m_scriptExtensions_;
        scx = scriptX & 255;
        if (scriptX >= 0xC00000) {
            scx = scriptExtensions[scx + 1];
        }
        if (sc <= 32767) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            ++scx;
lbl11:
            // 2 sources

            ** while (sc > scriptExtensions[scx])
        }
lbl12:
        // 1 sources

        return sc == (scriptExtensions[scx] & 32767);
    }

    public static final int getScriptExtensions(int c, BitSet set) {
        char sx;
        set.clear();
        int scriptX = UCharacterProperty.INSTANCE.getAdditional(c, 0) & 0xC000FF;
        if (scriptX < 0x400000) {
            set.set(scriptX);
            return scriptX;
        }
        char[] scriptExtensions = UCharacterProperty.INSTANCE.m_scriptExtensions_;
        int scx = scriptX & 0xFF;
        if (scriptX >= 0xC00000) {
            scx = scriptExtensions[scx + 1];
        }
        int length = 0;
        do {
            sx = scriptExtensions[scx++];
            set.set(sx & Short.MAX_VALUE);
            ++length;
        } while (sx < '\u8000');
        return -length;
    }

    public static final String getName(int scriptCode) {
        return UCharacter.getPropertyValueName(4106, scriptCode, 1);
    }

    public static final String getShortName(int scriptCode) {
        return UCharacter.getPropertyValueName(4106, scriptCode, 0);
    }

    public static final String getSampleString(int script) {
        int sampleChar = ScriptMetadata.getScriptProps(script) & 0x1FFFFF;
        if (sampleChar != 0) {
            return new StringBuilder().appendCodePoint(sampleChar).toString();
        }
        return "";
    }

    public static final ScriptUsage getUsage(int script) {
        return usageValues[ScriptMetadata.getScriptProps(script) >> 21 & 7];
    }

    public static final boolean isRightToLeft(int script) {
        return (ScriptMetadata.getScriptProps(script) & 0x1000000) != 0;
    }

    public static final boolean breaksBetweenLetters(int script) {
        return (ScriptMetadata.getScriptProps(script) & 0x2000000) != 0;
    }

    public static final boolean isCased(int script) {
        return (ScriptMetadata.getScriptProps(script) & 0x4000000) != 0;
    }

    private UScript() {
    }

    private static final class ScriptMetadata {
        private static final int UNKNOWN = 0x200000;
        private static final int EXCLUSION = 0x400000;
        private static final int LIMITED_USE = 0x600000;
        private static final int ASPIRATIONAL = 0x800000;
        private static final int RECOMMENDED = 0xA00000;
        private static final int RTL = 0x1000000;
        private static final int LB_LETTERS = 0x2000000;
        private static final int CASED = 0x4000000;
        private static final int[] SCRIPT_PROPS;

        static {
            int[] nArray = new int[175];
            nArray[0] = 0xA00040;
            nArray[1] = 10486536;
            nArray[2] = 27264552;
            nArray[3] = 77595953;
            nArray[4] = 10488213;
            nArray[5] = 44052741;
            nArray[6] = 73405380;
            nArray[7] = 71304162;
            nArray[8] = 77595695;
            nArray[9] = 0x4410414;
            nArray[10] = 10488069;
            nArray[11] = 10490528;
            nArray[12] = 10490067;
            nArray[13] = 4260656;
            nArray[14] = 77595561;
            nArray[15] = 10488469;
            nArray[16] = 10488341;
            nArray[17] = 44063575;
            nArray[18] = 0xA0AC00;
            nArray[19] = 27264464;
            nArray[20] = 44052555;
            nArray[21] = 10488981;
            nArray[22] = 44052651;
            nArray[23] = 44046208;
            nArray[24] = 44043941;
            nArray[25] = 77594700;
            nArray[26] = 10489109;
            nArray[27] = 8394790;
            nArray[28] = 44044288;
            nArray[29] = 4200079;
            nArray[30] = 4260608;
            nArray[31] = 10488597;
            nArray[32] = 4200096;
            nArray[33] = 10489221;
            nArray[34] = 23070480;
            nArray[35] = 10488725;
            nArray[36] = 10488853;
            nArray[37] = 27264908;
            nArray[38] = 44043799;
            nArray[39] = 10489664;
            nArray[40] = 8393920;
            nArray[41] = 41984648;
            nArray[42] = 4200195;
            nArray[43] = 4200227;
            nArray[44] = 4200259;
            nArray[45] = 4200291;
            nArray[46] = 2107406;
            nArray[47] = 21039104;
            nArray[48] = 6297856;
            nArray[49] = 0x410000;
            nArray[50] = 4260992;
            nArray[51] = 4260944;
            nArray[52] = 39852368;
            nArray[53] = 4260736;
            nArray[55] = 4200960;
            nArray[56] = 71314432;
            nArray[57] = 21039616;
            nArray[58] = 6334464;
            nArray[59] = 39852416;
            nArray[60] = 8400176;
            nArray[61] = 4260768;
            nArray[62] = 6298373;
            nArray[63] = 6298560;
            nArray[65] = 4263941;
            nArray[66] = 0x60AA00;
            nArray[71] = 4272467;
            nArray[73] = 44063575;
            nArray[74] = 44063575;
            nArray[75] = 4287260;
            nArray[76] = 88149153;
            nArray[78] = 6334852;
            nArray[79] = 6334730;
            nArray[82] = 6298624;
            nArray[83] = 4261447;
            nArray[84] = 23070784;
            nArray[86] = 21039488;
            nArray[87] = 23070666;
            nArray[88] = 21040128;
            nArray[89] = 4260715;
            nArray[90] = 4237376;
            nArray[91] = 21039360;
            nArray[92] = 8482560;
            nArray[99] = 6333769;
            nArray[101] = 4268032;
            nArray[103] = 2162128;
            nArray[104] = 4260512;
            nArray[105] = 44052555;
            nArray[106] = 39852576;
            nArray[107] = 4260480;
            nArray[108] = 21039392;
            nArray[109] = 6298714;
            nArray[110] = 4237616;
            nArray[111] = 6334594;
            nArray[112] = 4315216;
            nArray[113] = 6298499;
            nArray[115] = 6335424;
            nArray[116] = 21039168;
            nArray[117] = 21039872;
            nArray[118] = 6361347;
            nArray[119] = 0xA0AC00;
            nArray[120] = 4264067;
            nArray[121] = 21039832;
            nArray[122] = 21039968;
            nArray[123] = 21040015;
            nArray[125] = 21039936;
            nArray[126] = 20973568;
            nArray[127] = 39889536;
            nArray[130] = 0x60A6A0;
            nArray[131] = 6333648;
            nArray[133] = 21039712;
            nArray[134] = 4287206;
            nArray[135] = 4308000;
            nArray[136] = 4261120;
            nArray[137] = 4264725;
            nArray[140] = 21096450;
            nArray[141] = 21039520;
            nArray[142] = 21039765;
            nArray[143] = 21039254;
            nArray[144] = 21039219;
            nArray[145] = 4264638;
            nArray[146] = 71375028;
            nArray[149] = 4287055;
            nArray[151] = 4264323;
            nArray[152] = 4264144;
            nArray[153] = 4265600;
            nArray[154] = 37847593;
            nArray[156] = 0x414400;
            nArray[157] = 4264456;
            nArray[158] = 0x411484;
            nArray[159] = 4261175;
            nArray[160] = 4264274;
            nArray[161] = 37820183;
            nArray[162] = 21039348;
            nArray[163] = 4265486;
            nArray[164] = 4264591;
            nArray[165] = 4266688;
            nArray[166] = 4265358;
            nArray[167] = 90302729;
            nArray[168] = 4267022;
            nArray[169] = 4267122;
            nArray[170] = 6362130;
            nArray[171] = 73467061;
            nArray[172] = 44063575;
            nArray[173] = 10490130;
            SCRIPT_PROPS = nArray;
        }

        private ScriptMetadata() {
        }

        private static final int getScriptProps(int script) {
            if (script >= 0 && script < SCRIPT_PROPS.length) {
                return SCRIPT_PROPS[script];
            }
            return 0;
        }
    }

    public static enum ScriptUsage {
        NOT_ENCODED,
        UNKNOWN,
        EXCLUDED,
        LIMITED_USE,
        ASPIRATIONAL,
        RECOMMENDED;

    }
}

