/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.support.IdentificationSupport;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.support.IntegrationSupport;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.BatchProcessEditor;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.ResultsPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.runnables.BatchRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BatchProcessEditorPage
implements IMultiEditorPage {
    private static final Logger logger = Logger.getLogger(BatchProcessEditorPage.class);
    private FormToolkit toolkit;
    private int pageIndex;
    private IPeakIdentificationBatchJob peakIdentificationBatchJob;
    private Text reportFolderTextBox;
    private Button overrideReportsCheckBox;
    private Combo integratorComboBox;
    private Button reportIntegrationResultsCheckBox;
    private Combo identifierComboBox;
    private Button reportIdentificationResultsCheckBox;
    private IntegrationSupport integrationSupport = new IntegrationSupport();
    private IdentificationSupport identifiationSupport = new IdentificationSupport();

    public BatchProcessEditorPage(BatchProcessEditor editorPart, Composite container) {
        this.createPage(editorPart, container);
    }

    @Override
    public void setFocus() {
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void setPeakIdentificationBatchJob(IPeakIdentificationBatchJob peakIdentificationBatchJob) {
        if (peakIdentificationBatchJob != null) {
            this.reportFolderTextBox.setText(peakIdentificationBatchJob.getReportFolder());
            this.overrideReportsCheckBox.setSelection(peakIdentificationBatchJob.isOverrideReport());
            this.peakIdentificationBatchJob = peakIdentificationBatchJob;
            this.setIntegratorSelection();
            this.setIdentifierSelection();
        }
    }

    private void createPage(BatchProcessEditor editorPart, Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(parent);
        Composite scrolledFormComposite = scrolledForm.getBody();
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Peak Identification Batch Editor");
        this.createPropertiesSection(scrolledFormComposite, editorPart);
        this.createIntegratorAndIdentifierSection(scrolledFormComposite, editorPart);
        this.createExecuteSection(scrolledFormComposite, editorPart);
        this.pageIndex = editorPart.addPage((Control)parent);
    }

    private void createPropertiesSection(Composite parent, BatchProcessEditor editorPart) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Properties");
        section.setDescription("Use the properties to define where the reports shall be written to.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        Label label = this.toolkit.createLabel(client, "Select workspace to report the results:");
        label.setLayoutData((Object)gridData);
        this.createReportFolderSelection(editorPart, client);
        this.createOverrideReportsCheckBox(editorPart, client);
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createReportFolderSelection(final BatchProcessEditor editorPart, Composite client) {
        GridData gridData = new GridData(768);
        this.reportFolderTextBox = this.toolkit.createText(client, "", 0);
        this.reportFolderTextBox.setLayoutData((Object)gridData);
        Button button = this.toolkit.createButton(client, "Select ...", 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                DirectoryDialog dialog = new DirectoryDialog(shell);
                dialog.setText("Select report folder:");
                String reportFolder = dialog.open();
                if (reportFolder != null) {
                    BatchProcessEditorPage.this.reportFolderTextBox.setText(reportFolder);
                    if (BatchProcessEditorPage.this.peakIdentificationBatchJob != null) {
                        BatchProcessEditorPage.this.peakIdentificationBatchJob.setReportFolder(reportFolder);
                        editorPart.setDirty();
                    }
                }
            }
        });
    }

    private void createOverrideReportsCheckBox(final BatchProcessEditor editorPart, Composite client) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.heightHint = 30;
        this.overrideReportsCheckBox = this.toolkit.createButton(client, "Override reports", 32);
        this.overrideReportsCheckBox.setLayoutData((Object)gridData);
        this.overrideReportsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (BatchProcessEditorPage.this.peakIdentificationBatchJob != null) {
                    boolean overrideReport = !BatchProcessEditorPage.this.peakIdentificationBatchJob.isOverrideReport();
                    BatchProcessEditorPage.this.peakIdentificationBatchJob.setOverrideReport(overrideReport);
                    editorPart.setDirty();
                }
            }
        });
    }

    private void createIntegratorAndIdentifierSection(Composite parent, BatchProcessEditor editorPart) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Integrator/Identifier");
        section.setDescription("Select the integrator and identifier to batch process the peaks.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gridDataLabel = new GridData(768);
        gridDataLabel.horizontalIndent = 20;
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        gridData.heightHint = 30;
        this.createIntegratorSelection(client, gridData, gridDataLabel, editorPart);
        this.createIdentifierSelection(client, gridData, gridDataLabel, editorPart);
        Label label = this.toolkit.createLabel(client, "");
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createIntegratorSelection(Composite client, GridData gridData, GridData gridDataLabel, final BatchProcessEditor editorPart) {
        Label label = this.toolkit.createLabel(client, "Select an integrator:");
        label.setLayoutData((Object)gridDataLabel);
        this.integratorComboBox = new Combo(client, 8);
        this.integratorComboBox.setLayoutData((Object)gridData);
        this.integratorComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = BatchProcessEditorPage.this.integratorComboBox.getSelectionIndex();
                if (index >= 0) {
                    String name = BatchProcessEditorPage.this.integratorComboBox.getItem(index);
                    String processorId = BatchProcessEditorPage.this.integrationSupport.getIntegratorId(name);
                    BatchProcessEditorPage.this.peakIdentificationBatchJob.getPeakIntegrationEntry().setProcessorId(processorId);
                    editorPart.setDirty();
                }
            }
        });
        this.toolkit.createComposite((Composite)this.integratorComboBox);
        this.reportIntegrationResultsCheckBox = this.toolkit.createButton(client, "Report integration results", 32);
        this.reportIntegrationResultsCheckBox.setLayoutData((Object)gridData);
        this.reportIntegrationResultsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean report = BatchProcessEditorPage.this.reportIntegrationResultsCheckBox.getSelection();
                BatchProcessEditorPage.this.peakIdentificationBatchJob.getPeakIntegrationEntry().setReport(report);
                editorPart.setDirty();
            }
        });
    }

    private void setIntegratorSelection() {
        String[] integratorIds = this.integrationSupport.getPluginIds();
        String[] integratorList = this.integrationSupport.getIntegratorNames(integratorIds);
        this.integratorComboBox.setItems(integratorList);
        String integratorId = this.peakIdentificationBatchJob.getPeakIntegrationEntry().getProcessorId();
        int index = this.getIndex(integratorIds, integratorId);
        if (index >= 0) {
            this.integratorComboBox.select(index);
        } else if (!integratorId.equals("")) {
            this.integratorComboBox.add(integratorId);
        }
        this.integratorComboBox.add("");
        this.reportIntegrationResultsCheckBox.setSelection(this.peakIdentificationBatchJob.getPeakIntegrationEntry().isReport());
    }

    private void createIdentifierSelection(Composite client, GridData gridData, GridData gridDataLabel, final BatchProcessEditor editorPart) {
        Label label = this.toolkit.createLabel(client, "Select an identifier:");
        label.setLayoutData((Object)gridDataLabel);
        this.identifierComboBox = new Combo(client, 8);
        this.identifierComboBox.setLayoutData((Object)gridData);
        this.identifierComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = BatchProcessEditorPage.this.identifierComboBox.getSelectionIndex();
                if (index >= 0) {
                    String name = BatchProcessEditorPage.this.identifierComboBox.getItem(index);
                    String processorId = BatchProcessEditorPage.this.identifiationSupport.getIdentifierId(name);
                    BatchProcessEditorPage.this.peakIdentificationBatchJob.getPeakIdentificationEntry().setProcessorId(processorId);
                    editorPart.setDirty();
                }
            }
        });
        this.toolkit.createComposite((Composite)this.identifierComboBox);
        this.reportIdentificationResultsCheckBox = this.toolkit.createButton(client, "Report identification results", 32);
        this.reportIdentificationResultsCheckBox.setLayoutData((Object)gridData);
        this.reportIdentificationResultsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean report = BatchProcessEditorPage.this.reportIdentificationResultsCheckBox.getSelection();
                BatchProcessEditorPage.this.peakIdentificationBatchJob.getPeakIdentificationEntry().setReport(report);
                editorPart.setDirty();
            }
        });
    }

    private void setIdentifierSelection() {
        String[] identifierIds = this.identifiationSupport.getPluginIds();
        String[] identifierList = this.identifiationSupport.getIdentifierNames(identifierIds);
        this.identifierComboBox.setItems(identifierList);
        String identifierId = this.peakIdentificationBatchJob.getPeakIdentificationEntry().getProcessorId();
        int index = this.getIndex(identifierIds, identifierId);
        if (index >= 0) {
            this.identifierComboBox.select(index);
        } else if (!identifierId.equals("")) {
            this.identifierComboBox.add(identifierId);
        }
        this.identifierComboBox.add("");
        this.reportIdentificationResultsCheckBox.setSelection(this.peakIdentificationBatchJob.getPeakIdentificationEntry().isReport());
    }

    private int getIndex(String[] array, String value) {
        int index = -1;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            ++index;
            if (entry.equals(value)) {
                return index;
            }
            ++n2;
        }
        return -1;
    }

    private void createExecuteSection(Composite parent, BatchProcessEditor editorPart) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Progress");
        section.setDescription("Run the batch job, after the entries have been edited.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        gridData.heightHint = 30;
        Label label = this.toolkit.createLabel(client, "1. Edit the input,process and output entries.");
        label.setLayoutData((Object)gridData);
        this.createInputFilesPageHyperlink(editorPart, client, gridData);
        this.createOutputFilesPageHyperlink(editorPart, client, gridData);
        this.createBatchResultsPageHyperlink(editorPart, client, gridData);
        label = this.toolkit.createLabel(client, "2. Run the batch process job after selecting the input files.");
        label.setLayoutData((Object)gridData);
        this.createProcessHyperlink(editorPart, client, gridData);
        label = this.toolkit.createLabel(client, "");
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createInputFilesPageHyperlink(final BatchProcessEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        imageHyperlink.setText("Configure input files");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                editorPart.setActivePage("ifp");
            }
        });
    }

    private void createOutputFilesPageHyperlink(final BatchProcessEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        imageHyperlink.setText("Configure output files");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                editorPart.setActivePage("ofp");
            }
        });
    }

    private void createBatchResultsPageHyperlink(final BatchProcessEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        imageHyperlink.setText("Peak Integration/Identification results");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                editorPart.setActivePage("prp");
            }
        });
    }

    private void createProcessHyperlink(final BatchProcessEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 64);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        imageHyperlink.setText("Run the batch process");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IPath path;
                String filePath;
                Display display = Display.getCurrent();
                if (editorPart.isDirty()) {
                    editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                if ((filePath = (path = ((IFileEditorInput)editorPart.getEditorInput()).getFile().getLocation()).toFile().toString()) != null && !filePath.equals("")) {
                    BatchRunnable runnable = new BatchRunnable(filePath);
                    ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
                    try {
                        ResultsPage.SelectionUpdateListener updateListener = new ResultsPage.SelectionUpdateListener();
                        updateListener.clear();
                        monitor.run(true, true, (IRunnableWithProgress)runnable);
                        editorPart.setActivePage("prp");
                        BatchProcessEditorPage.this.refreshWorkspace(path);
                    }
                    catch (InvocationTargetException ex) {
                        logger.warn((Object)ex);
                    }
                    catch (InterruptedException ex) {
                        logger.warn((Object)ex);
                    }
                }
            }
        });
    }

    private void refreshWorkspace(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String workspace = root.getLocation().toFile().toString();
        String file = path.toFile().getParent();
        String containerName = file.replace(workspace, "");
        IResource resource = root.findMember((IPath)new Path("/" + containerName));
        if (resource != null && resource.exists() && resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                container.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
    }
}

