/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.runnables;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.core.PeakIdentificationBatchProcess;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.io.PeakIdentificationBatchJobReader;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.report.IPeakIdentificationBatchProcessReport;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.ResultsPage;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class BatchRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(BatchRunnable.class);
    private File file;
    private String filePath;
    private PeakIdentificationBatchJobReader reader;

    public BatchRunnable(String filePath) {
        this.filePath = filePath;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.reader = new PeakIdentificationBatchJobReader();
        this.file = new File(this.filePath);
        try {
            monitor.beginTask("Peak Identification Batch Process", -1);
            IPeakIdentificationBatchJob peakIdentificationBatchJob = this.reader.read(this.file, monitor);
            PeakIdentificationBatchProcess batchProcess = new PeakIdentificationBatchProcess();
            IProcessingInfo processingInfo = batchProcess.execute(peakIdentificationBatchJob, monitor);
            try {
                IPeakIdentificationBatchProcessReport report = (IPeakIdentificationBatchProcessReport)processingInfo.getProcessingResult();
                ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
                ResultsPage.SelectionUpdateListener selectionUpdateListener = new ResultsPage.SelectionUpdateListener();
                selectionUpdateListener.update(report.getPeaks(), true);
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (FileIsNotReadableException e) {
            logger.warn((Object)e);
        }
        catch (FileIsEmptyException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }
}

