/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core;

import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.BaselineDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.BaselineDetectorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.IBaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.IBaselineDetectorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class BaselineDetector {
    private static final Logger logger = Logger.getLogger(BaselineDetector.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.baselineDetectorSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String DETECTOR_NAME = "detectorName";
    private static final String BASELINE_DETECTOR = "baselineDetector";
    private static final String DETECTOR_SETTINGS = "detectorSettings";
    private static final String NO_DETECTOR_AVAILABLE = "There is no baseline detector available.";

    private BaselineDetector() {
    }

    public static IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, String detectorId, IProgressMonitor monitor) {
        IBaselineDetector detector = BaselineDetector.getBaselineDetector(detectorId);
        IProcessingInfo processingInfo = detector != null ? detector.setBaseline(chromatogramSelection, baselineDetectorSettings, monitor) : BaselineDetector.getNoDetectorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, String detectorId, IProgressMonitor monitor) {
        IBaselineDetector detector = BaselineDetector.getBaselineDetector(detectorId);
        IProcessingInfo processingInfo = detector != null ? detector.setBaseline(chromatogramSelection, monitor) : BaselineDetector.getNoDetectorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IBaselineDetectorSupport getBaselineDetectorSupport() {
        IConfigurationElement[] extensions;
        BaselineDetectorSupport baselineDetectorSupport = new BaselineDetectorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            BaselineDetectorSupplier supplier = new BaselineDetectorSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setDetectorName(element.getAttribute(DETECTOR_NAME));
            if (element.getAttribute(DETECTOR_SETTINGS) != null) {
                try {
                    IBaselineDetectorSettings instance = (IBaselineDetectorSettings)element.createExecutableExtension(DETECTOR_SETTINGS);
                    supplier.setSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.warn((Object)e);
                    supplier.setSettingsClass(null);
                }
            }
            baselineDetectorSupport.add(supplier);
            ++n2;
        }
        return baselineDetectorSupport;
    }

    private static IBaselineDetector getBaselineDetector(String detectorId) {
        IConfigurationElement element = BaselineDetector.getConfigurationElement(detectorId);
        IBaselineDetector instance = null;
        if (element != null) {
            try {
                instance = (IBaselineDetector)element.createExecutableExtension(BASELINE_DETECTOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String detectorId) {
        IConfigurationElement[] elements;
        if ("".equals(detectorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(detectorId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IProcessingInfo getNoDetectorAvailableProcessingInfo() {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Baseline Detector", NO_DETECTOR_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

