/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram;

import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.ChromatogramCalculatorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.ChromatogramCalculatorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.IChromatogramCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.IChromatogramCalculatorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.settings.IChromatogramCalculatorSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramCalculator {
    private static final Logger logger = Logger.getLogger(ChromatogramCalculator.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.xxd.calculator.chromatogramCalculatorSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String CALCULATOR_NAME = "calculatorName";
    private static final String CALCULATOR = "calculator";
    private static final String CALCULATOR_SETTINGS = "calculatorSettings";
    private static final String PROCESSING_DESCRIPTION = "Chromatogram Calculator";
    private static final String NO_CHROMATOGRAM_CALCULATOR_AVAILABLE = "There is no chromatogram calculator available.";

    private ChromatogramCalculator() {
    }

    public static IProcessingInfo applyCalculator(IChromatogramSelection chromatogramSelection, IChromatogramCalculatorSettings chromatogramCalculatorSettings, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IChromatogramCalculator chromatogramCalculator = ChromatogramCalculator.getChromatogramCalculator(filterId);
        if (chromatogramCalculator != null) {
            processingInfo = chromatogramCalculator.applyCalculator(chromatogramSelection, chromatogramCalculatorSettings, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_CHROMATOGRAM_CALCULATOR_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo applyCalculator(IChromatogramSelection chromatogramSelection, String calculatorId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IChromatogramCalculator chromatogramCalculator = ChromatogramCalculator.getChromatogramCalculator(calculatorId);
        if (chromatogramCalculator != null) {
            processingInfo = chromatogramCalculator.applyCalculator(chromatogramSelection, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_CHROMATOGRAM_CALCULATOR_AVAILABLE);
        }
        return processingInfo;
    }

    public static IChromatogramCalculatorSupport getChromatogramCalculatorSupport() {
        IConfigurationElement[] extensions;
        ChromatogramCalculatorSupport calculatorSupport = new ChromatogramCalculatorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramCalculatorSupplier supplier = new ChromatogramCalculatorSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setCalculatorName(element.getAttribute(CALCULATOR_NAME));
            if (element.getAttribute(CALCULATOR_SETTINGS) != null) {
                try {
                    IChromatogramCalculatorSettings instance = (IChromatogramCalculatorSettings)element.createExecutableExtension(CALCULATOR_SETTINGS);
                    supplier.setSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.warn((Object)e);
                    supplier.setSettingsClass(null);
                }
            }
            calculatorSupport.add(supplier);
            ++n2;
        }
        return calculatorSupport;
    }

    private static IChromatogramCalculator getChromatogramCalculator(String calculatorId) {
        IConfigurationElement element = ChromatogramCalculator.getConfigurationElement(calculatorId);
        IChromatogramCalculator instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramCalculator)element.createExecutableExtension(CALCULATOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String calculatorId) {
        IConfigurationElement[] elements;
        if ("".equals(calculatorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(calculatorId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

