/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.core;

import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.AbstractBaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator.SnipCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.BaselineDetectorSettings;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BaselineDetector
extends AbstractBaselineDetector {
    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(chromatogramSelection, baselineDetectorSettings, monitor);
        if (!processingInfo.hasErrorMessages() && baselineDetectorSettings instanceof BaselineDetectorSettings) {
            BaselineDetector.calculateBaseline(chromatogramSelection, (BaselineDetectorSettings)baselineDetectorSettings, monitor);
        }
        return processingInfo;
    }

    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        BaselineDetectorSettings baselineDetectorSettings = PreferenceSupplier.getBaselineDetectorSettings();
        return this.setBaseline(chromatogramSelection, (IBaselineDetectorSettings)baselineDetectorSettings, monitor);
    }

    public static void calculateBaseline(IChromatogramSelection<?, ?> chromatogramSelection, BaselineDetectorSettings detectorSettings, IProgressMonitor monitor) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        ScanRange scanRange = new ScanRange(startScan, stopScan);
        int iterations = detectorSettings.getIterations();
        int windowSize = detectorSettings.getWindowSize().getSize();
        if (scanRange.getWidth() <= windowSize) {
            return;
        }
        try {
            TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor(chromatogram);
            ITotalScanSignals totalIonSignals = totalScanSignalExtractor.getTotalScanSignals(startScan, stopScan);
            BaselineDetector.calculateSNIPBaseline(totalIonSignals, iterations, monitor);
            IBaselineModel baselineModel = chromatogram.getBaselineModel();
            BaselineDetector.applyBaseline(baselineModel, totalIonSignals, startScan, stopScan, monitor);
        }
        catch (ChromatogramIsNullException e) {
            return;
        }
    }

    private static void calculateSNIPBaseline(ITotalScanSignals totalIonSignals, int iterations, IProgressMonitor monitor) {
        int size = totalIonSignals.size();
        float[] intensityValues = new float[size];
        int counter = 0;
        for (ITotalScanSignal signal : totalIonSignals.getTotalScanSignals()) {
            intensityValues[counter++] = signal.getTotalSignal();
        }
        SnipCalculator.calculateBaselineIntensityValues(intensityValues, iterations, monitor);
        counter = 0;
        for (ITotalScanSignal signal : totalIonSignals.getTotalScanSignals()) {
            signal.setTotalSignal(intensityValues[counter++]);
        }
    }

    private static void applyBaseline(IBaselineModel baselineModel, ITotalScanSignals totalIonSignals, int startScan, int stopScan, IProgressMonitor monitor) {
        int size = stopScan - startScan;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Apply baseline", (int)size);
        try {
            int scan = startScan;
            while (scan < stopScan) {
                ITotalScanSignal actualTotalIonSignal = totalIonSignals.getTotalScanSignal(scan);
                ITotalScanSignal nextTotalIonSignal = totalIonSignals.getNextTotalScanSignal(scan);
                int startRetentionTime = actualTotalIonSignal.getRetentionTime();
                float startBackgroundAbundance = actualTotalIonSignal.getTotalSignal();
                int stopRetentionTime = nextTotalIonSignal.getRetentionTime();
                float stopBackgroundAbundance = nextTotalIonSignal.getTotalSignal();
                baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
                subMonitor.worked(1);
                ++scan;
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }
}

