/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.core;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.AbstractCombinedIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.combined.ICombinedIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.CombinedIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.ChromatogramIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.PeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.settings.CombinedIntegrationSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class CombinedIntegrator
extends AbstractCombinedIntegrator {
    private static final Logger logger = Logger.getLogger(CombinedIntegrator.class);

    public IProcessingInfo integrate(IChromatogramSelection chromatogramSelection, ICombinedIntegrationSettings integrationSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, integrationSettings);
        if (!processingInfo.hasErrorMessages() && integrationSettings instanceof CombinedIntegrationSettings) {
            try {
                CombinedIntegrationSettings combinedIntegrationSettings = (CombinedIntegrationSettings)integrationSettings;
                PeakIntegratorSupport peakIntegratorSupport = new PeakIntegratorSupport();
                IPeakIntegrationResults peakIntegrationResults = peakIntegratorSupport.calculatePeakIntegrationResults(chromatogramSelection, combinedIntegrationSettings.getPeakIntegrationSettings(), monitor);
                ChromatogramIntegratorSupport chromatogramIntegratorSupport = new ChromatogramIntegratorSupport();
                IChromatogramIntegrationResults chromatogramIntegrationResults = chromatogramIntegratorSupport.calculateChromatogramIntegrationResults(chromatogramSelection, combinedIntegrationSettings.getChromatogramIntegrationSettings(), monitor);
                CombinedIntegrationResult combinedIntegrationResult = new CombinedIntegrationResult(chromatogramIntegrationResults, peakIntegrationResults);
                processingInfo.setProcessingResult((Object)combinedIntegrationResult);
            }
            catch (ValueMustNotBeNullException e) {
                logger.warn((Object)e);
            }
        }
        return processingInfo;
    }

    public IProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        CombinedIntegrationSettings combinedIntegrationSettings = PreferenceSupplier.getCombinedIntegrationSettings();
        return this.integrate(chromatogramSelection, (ICombinedIntegrationSettings)combinedIntegrationSettings, monitor);
    }
}

