/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.core;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.AbstractPeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.PeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.settings.PeakIntegrationSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIntegrator
extends AbstractPeakIntegrator<IPeakIntegrationResults> {
    private static final Logger logger = Logger.getLogger(PeakIntegrator.class);

    public IProcessingInfo<IPeakIntegrationResults> integrate(IPeak peak, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(peak, peakIntegrationSettings);
        if (!processingInfo.hasErrorMessages() && peakIntegrationSettings instanceof PeakIntegrationSettings) {
            PeakIntegratorSupport firstDerivativePeakIntegratorSupport = new PeakIntegratorSupport();
            IPeakIntegrationResult peakIntegrationResult = firstDerivativePeakIntegratorSupport.calculatePeakIntegrationResult(peak, (PeakIntegrationSettings)peakIntegrationSettings, monitor);
            PeakIntegrationResults peakIntegrationResults = new PeakIntegrationResults();
            peakIntegrationResults.add(peakIntegrationResult);
            processingInfo.setProcessingResult((Object)peakIntegrationResults);
        }
        return processingInfo;
    }

    public IProcessingInfo<IPeakIntegrationResults> integrate(IPeak peak, IProgressMonitor monitor) {
        PeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(peak, (IPeakIntegrationSettings)peakIntegrationSettings, monitor);
    }

    public IProcessingInfo<IPeakIntegrationResults> integrate(List<? extends IPeak> peaks, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(peaks, peakIntegrationSettings);
        if (!processingInfo.hasErrorMessages() && peakIntegrationSettings instanceof PeakIntegrationSettings) {
            PeakIntegratorSupport firstDerivativePeakIntegratorSupport = new PeakIntegratorSupport();
            IPeakIntegrationResults peakIntegrationResults = firstDerivativePeakIntegratorSupport.calculatePeakIntegrationResults(peaks, (PeakIntegrationSettings)peakIntegrationSettings, monitor);
            processingInfo.setProcessingResult((Object)peakIntegrationResults);
        }
        return processingInfo;
    }

    public IProcessingInfo<IPeakIntegrationResults> integrate(List<? extends IPeak> peaks, IProgressMonitor monitor) {
        PeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(peaks, (IPeakIntegrationSettings)peakIntegrationSettings, monitor);
    }

    public IProcessingInfo<IPeakIntegrationResults> integrate(IChromatogramSelection<?, ?> chromatogramSelection, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(chromatogramSelection, peakIntegrationSettings);
        if (!processingInfo.hasErrorMessages() && peakIntegrationSettings instanceof PeakIntegrationSettings) {
            PeakIntegratorSupport firstDerivativePeakIntegratorSupport = new PeakIntegratorSupport();
            IPeakIntegrationResults peakIntegrationResults = firstDerivativePeakIntegratorSupport.calculatePeakIntegrationResults(chromatogramSelection, (PeakIntegrationSettings)peakIntegrationSettings, monitor);
            processingInfo.setProcessingResult((Object)peakIntegrationResults);
        }
        return processingInfo;
    }

    public IProcessingInfo<IPeakIntegrationResults> integrate(IChromatogramSelection<?, ?> chromatogramSelection, IProgressMonitor monitor) {
        PeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(chromatogramSelection, (IPeakIntegrationSettings)peakIntegrationSettings, monitor);
    }
}

