/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.model.core;

import org.eclipse.chemclipse.csd.model.core.AbstractPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.model.exceptions.PeakException;

public abstract class AbstractChromatogramPeakCSD
extends AbstractPeakCSD
implements IChromatogramPeakCSD {
    private IChromatogramCSD chromatogram;
    private static final float INITIAL_SN_VALUE = -1.0f;
    private float signalToNoiseRatio = -1.0f;

    public AbstractChromatogramPeakCSD(IPeakModelCSD peakModel, IChromatogramCSD chromatogram) throws IllegalArgumentException, PeakException {
        super(peakModel);
        this.validateChromatogram(chromatogram);
        this.validateRetentionTimes(chromatogram, peakModel);
        this.chromatogram = chromatogram;
    }

    public AbstractChromatogramPeakCSD(IPeakModelCSD peakModel, IChromatogramCSD chromatogram, String modelDescription) throws IllegalArgumentException, PeakException {
        this(peakModel, chromatogram);
        this.setModelDescription(modelDescription);
    }

    public int getScanMax() {
        int retentionTime = this.getPeakModel().getRetentionTimeAtPeakMaximum();
        return this.chromatogram.getScanNumber(retentionTime);
    }

    public float getSignalToNoiseRatio() {
        if (this.signalToNoiseRatio == -1.0f) {
            float totalSignal = this.getPeakModel().getPeakAbundance();
            this.signalToNoiseRatio = this.chromatogram.getSignalToNoiseRatio(totalSignal);
        }
        return this.signalToNoiseRatio;
    }

    @Override
    public int getWidthBaselineTotalInScans() {
        int start = this.chromatogram.getScanNumber(this.getPeakModel().getStartRetentionTime());
        if (start == 0) {
            return 0;
        }
        int stop = this.chromatogram.getScanNumber(this.getPeakModel().getStopRetentionTime());
        if (stop == 0) {
            return 0;
        }
        return stop - start + 1;
    }

    @Override
    public IChromatogramCSD getChromatogram() {
        return this.chromatogram;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractChromatogramPeakCSD other = (AbstractChromatogramPeakCSD)otherObject;
        return this.getPeakModel().equals(other.getPeakModel()) && this.chromatogram == other.getChromatogram();
    }

    public int hashCode() {
        return 7 * this.getPeakModel().hashCode() + 11 * this.chromatogram.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("peakModel=" + this.getPeakModel());
        builder.append(",");
        builder.append("chromatogram=" + this.chromatogram);
        builder.append("]");
        return builder.toString();
    }
}

