/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.supplier;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IMeasurementProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;

public interface IChromatogramSelectionProcessSupplier<SettingType>
extends IProcessSupplier<SettingType> {
    public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> var1, SettingType var2, ProcessExecutionContext var3) throws InterruptedException;

    public static ProcessExecutionConsumer<IChromatogramSelection<?, ?>> createConsumer(IChromatogramSelection<?, ?> chromatogramSelection) {
        if (chromatogramSelection == null) {
            return null;
        }
        return new ProcessExecutionConsumer<IChromatogramSelection<?, ?>>(chromatogramSelection){
            AtomicReference<IChromatogramSelection<?, ?>> result;
            {
                this.result = new AtomicReference<IChromatogramSelection>(iChromatogramSelection);
            }

            public <X> void execute(ProcessorPreferences<X> preferences, ProcessExecutionContext context) throws Exception {
                IProcessSupplier supplier = preferences.getSupplier();
                if (supplier instanceof IChromatogramSelectionProcessSupplier) {
                    IChromatogramSelectionProcessSupplier chromatogramSelectionProcessSupplier = (IChromatogramSelectionProcessSupplier)supplier;
                    this.updateResult(chromatogramSelectionProcessSupplier.apply((IChromatogramSelection<?, ?>)this.getResult(), preferences.getSettings(), context));
                } else if (supplier instanceof IMeasurementProcessSupplier) {
                    IMeasurementProcessSupplier measurementProcessSupplier = (IMeasurementProcessSupplier)supplier;
                    Object chromatogram = this.getResult().getChromatogram();
                    measurementProcessSupplier.applyProcessor(Collections.singleton(chromatogram), preferences.getSettings(), context);
                }
            }

            public <X> boolean canExecute(ProcessorPreferences<X> preferences) {
                IProcessSupplier supplier = preferences.getSupplier();
                return supplier instanceof IChromatogramSelectionProcessSupplier || supplier instanceof IMeasurementProcessSupplier;
            }

            private void updateResult(IChromatogramSelection<?, ?> newSelection) {
                this.result.set(newSelection);
            }

            public IChromatogramSelection<?, ?> getResult() {
                return this.result.get();
            }

            public ProcessExecutionConsumer<IChromatogramSelection<?, ?>> withResult(Object initialResult) {
                if (initialResult instanceof IChromatogramSelection) {
                    return IChromatogramSelectionProcessSupplier.createConsumer((IChromatogramSelection)initialResult);
                }
                return null;
            }
        };
    }
}

