/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.ui.support;

import javax.inject.Inject;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.ui.Activator;
import org.eclipse.chemclipse.processing.ui.parts.ProcessingInfoPart;
import org.eclipse.chemclipse.processing.ui.support.DynamicProcessingInfoUpdateNotifier;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.support.ui.workbench.PartSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;

@Creatable
public class ProcessingInfoViewSupport {
    private static final String TITLE = "An error/some errors occured.";
    private static final String MESSAGE = "Please check the 'Feedback' view.";
    @Inject
    private IEclipseContext eclipseContext;
    @Inject
    private DynamicProcessingInfoUpdateNotifier infoUpdateNotifier;
    @Inject
    private UISynchronize uiSynchronize;
    @Inject
    private PartSupport partSupport;
    private static final ProcessingInfoViewSupport INSTANCE = new ProcessingInfoViewSupport();

    static {
        ProcessingInfoViewSupport.INSTANCE.eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        ProcessingInfoViewSupport.INSTANCE.infoUpdateNotifier = (DynamicProcessingInfoUpdateNotifier)ContextInjectionFactory.make(DynamicProcessingInfoUpdateNotifier.class, (IEclipseContext)ProcessingInfoViewSupport.INSTANCE.eclipseContext);
        ProcessingInfoViewSupport.INSTANCE.uiSynchronize = new UISynchronize(){

            public void syncExec(Runnable runnable) {
                Display.getDefault().syncExec(runnable);
            }

            public void asyncExec(Runnable runnable) {
                Display.getDefault().asyncExec(runnable);
            }
        };
        ProcessingInfoViewSupport.INSTANCE.partSupport = ModelSupportAddon.getPartSupport();
    }

    public void update(MessageProvider messageProvider, final boolean focusProcessingInfoView) {
        if (messageProvider == null) {
            return;
        }
        if (messageProvider.hasErrorMessages()) {
            for (IProcessingMessage message : messageProvider.getMessages()) {
                if (message.getMessageType() != MessageType.ERROR) continue;
                ProcessingInfoViewSupport.logError(message.getDescription(), message.getMessage(), message.getException());
            }
        }
        try {
            this.infoUpdateNotifier.update(messageProvider);
        }
        catch (RuntimeException e) {
            ProcessingInfoViewSupport.logError(ProcessingInfoViewSupport.class.getName(), "calling infoUpdateNotifier failed", e);
        }
        if (messageProvider.hasErrorMessages()) {
            this.uiSynchronize.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = DisplayUtils.getShell();
                    if (shell != null) {
                        MessageBox messageBox = new MessageBox(shell, 8);
                        messageBox.setText(ProcessingInfoViewSupport.TITLE);
                        messageBox.setMessage(ProcessingInfoViewSupport.MESSAGE);
                        messageBox.open();
                    }
                    if (focusProcessingInfoView) {
                        try {
                            ProcessingInfoViewSupport.this.partSupport.focusPart(ProcessingInfoPart.ID);
                        }
                        catch (RuntimeException e) {
                            ProcessingInfoViewSupport.logError(ProcessingInfoViewSupport.class.getName(), "focus part failed", e);
                        }
                    }
                }
            });
        }
    }

    public void update(MessageProvider messageProvider) {
        if (messageProvider == null) {
            return;
        }
        this.update(messageProvider, messageProvider.hasErrorMessages());
    }

    public void showError(String description, String message, Throwable e) {
        DefaultProcessingResult errorResult = new DefaultProcessingResult();
        errorResult.addErrorMessage(description, message, e);
        this.update((MessageProvider)errorResult);
    }

    @Deprecated
    public static void updateProcessingInfoError(String description, String message, Throwable e) {
        DefaultProcessingResult errorResult = new DefaultProcessingResult();
        errorResult.addErrorMessage(description, message, e);
        ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)errorResult, true);
    }

    @Deprecated
    public static void updateProcessingInfo(MessageProvider processingInfo) {
        if (processingInfo == null) {
            return;
        }
        ProcessingInfoViewSupport.updateProcessingInfo(processingInfo, processingInfo.hasErrorMessages());
    }

    @Deprecated
    public static void updateProcessingInfo(MessageProvider processingInfo, boolean focusProcessingInfoView) {
        if (processingInfo == null) {
            return;
        }
        Display display = DisplayUtils.getDisplay();
        ProcessingInfoViewSupport.updateProcessingInfo(display, processingInfo, focusProcessingInfoView);
    }

    @Deprecated
    public static void updateProcessingInfo(Display display, MessageProvider processingInfo, boolean focusProcessingInfoView) {
        INSTANCE.update(processingInfo, focusProcessingInfoView);
    }

    private static void logError(String description, String message, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, description, message, e));
    }
}

