/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.core;

import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.core.MessageType;

public interface MessageConsumer {
    default public void addErrorMessage(String description, String message) {
        this.addErrorMessage(description, message, null);
    }

    default public void addErrorMessage(String description, String message, Throwable t) {
        this.addMessage(description, message, t, MessageType.ERROR);
    }

    default public void addInfoMessage(String description, String message, Throwable t) {
        this.addMessage(description, message, t, MessageType.INFO);
    }

    default public void addInfoMessage(String description, String message) {
        this.addInfoMessage(description, message, null);
    }

    default public void addWarnMessage(String description, String message) {
        this.addWarnMessage(description, message, null);
    }

    default public void addWarnMessage(String description, String message, Throwable t) {
        this.addMessage(description, message, t, MessageType.WARN);
    }

    default public void addMessage(String description, String message, MessageType type) {
        this.addMessage(description, message, null, type);
    }

    default public void addMessage(String description, String message, Throwable t, MessageType type) {
        this.addMessage(description, message, null, t, type);
    }

    public void addMessage(String var1, String var2, String var3, Throwable var4, MessageType var5);

    default public void addMessages(MessageProvider messageProvider) {
        if (messageProvider != null) {
            for (IProcessingMessage iProcessingMessage : messageProvider.getMessages()) {
                this.addMessage(iProcessingMessage.getDescription(), iProcessingMessage.getMessage(), iProcessingMessage.getException(), iProcessingMessage.getMessageType());
            }
        }
    }
}

