/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.methods;

import java.util.Set;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.methods.ProcessEntryProcessorPreferences;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;

public interface IProcessEntry
extends ProcessEntryContainer {
    public String getProcessorId();

    @Override
    public String getName();

    @Override
    public String getDescription();

    public String getSettings();

    public Set<DataCategory> getDataCategories();

    public void setSettings(String var1) throws IllegalArgumentException;

    public boolean isReadOnly();

    public ProcessEntryContainer getParent();

    default public <T> ProcessorPreferences<T> getPreferences(ProcessSupplierContext context) {
        return this.getPreferences(context.getSupplier(this.getProcessorId()));
    }

    default public <T> ProcessorPreferences<T> getPreferences(IProcessSupplier<T> supplier) {
        if (supplier == null) {
            return null;
        }
        return new ProcessEntryProcessorPreferences<T>(supplier, this);
    }

    default public boolean contentEquals(IProcessEntry other) {
        String otherSettings;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        String settings = this.getSettings();
        if (settings == null) {
            settings = "";
        }
        if ((otherSettings = other.getSettings()) == null) {
            otherSettings = "";
        }
        if (!otherSettings.equals(settings)) {
            return false;
        }
        if (!this.getProcessorId().equals(other.getProcessorId())) {
            return false;
        }
        return this.entriesEquals(other);
    }

    public static ProcessSupplierContext getContext(IProcessEntry entry, ProcessSupplierContext defaultContext) {
        IProcessEntry parent;
        IProcessSupplier supplier;
        ProcessEntryContainer container = entry.getParent();
        if (container instanceof IProcessEntry && (supplier = IProcessEntry.getContext(parent = (IProcessEntry)container, defaultContext).getSupplier(parent.getProcessorId())) instanceof ProcessSupplierContext) {
            return (ProcessSupplierContext)((Object)supplier);
        }
        return defaultContext;
    }
}

