/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.editors;

import org.eclipse.chemclipse.support.ui.editors.IExtendedEditorPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractExtendedEditorPage
implements IExtendedEditorPage {
    protected static final int HORIZONTAL_INDENT = 15;
    private FormToolkit toolkit;
    private Composite control;
    private ScrolledForm scrolledForm;

    public AbstractExtendedEditorPage(String pageName, Composite container, boolean fillBody) {
        this.control = new Composite(container, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.control.setBackground(Display.getCurrent().getSystemColor(1));
        this.toolkit = new FormToolkit(this.control.getDisplay());
        this.scrolledForm = this.toolkit.createScrolledForm(this.control);
        this.scrolledForm.setText(pageName);
        if (fillBody) {
            this.fillBody(this.scrolledForm);
        }
    }

    @Override
    public ScrolledForm getScrolledForm() {
        return this.scrolledForm;
    }

    @Override
    public FormToolkit getFormToolkit() {
        return this.toolkit;
    }

    @Override
    public Composite getControl() {
        return this.control;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    protected TableWrapLayout createFormTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.topMargin = 12;
        tableWrapLayout.bottomMargin = 12;
        tableWrapLayout.leftMargin = 6;
        tableWrapLayout.rightMargin = 6;
        tableWrapLayout.horizontalSpacing = 20;
        tableWrapLayout.verticalSpacing = 17;
        tableWrapLayout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        tableWrapLayout.numColumns = numColumns;
        return tableWrapLayout;
    }

    protected Section createSection(Composite parent, int colspan) {
        Section section = this.toolkit.createSection(parent, 64);
        section.clientVerticalSpacing = 2;
        section.setLayout((Layout)this.createSectionTableWrapLayout(true, 1));
        TableWrapData tableWrapData = new TableWrapData(256);
        tableWrapData.colspan = colspan;
        section.setLayoutData((Object)tableWrapData);
        return section;
    }

    protected Composite createClientInfo(Section section) {
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.marginTop = 2;
        gridLayout.marginLeft = 6;
        client.setLayout((Layout)gridLayout);
        return client;
    }

    protected Label createLabel(Composite client, String text) {
        Label label = this.toolkit.createLabel(client, text);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Text createText(Composite client, int style, String text) {
        Text textField = this.toolkit.createText(client, text, style);
        GridData gridData = new GridData(768);
        textField.setLayoutData((Object)gridData);
        return textField;
    }

    protected CLabel createCLabel(Composite client, String text, Image image, int horizontalIndent) {
        CLabel label = new CLabel(client, 16384);
        label.setText(text);
        label.setImage(image);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = horizontalIndent;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected TableWrapLayout createSectionTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.topMargin = 2;
        tableWrapLayout.bottomMargin = 2;
        tableWrapLayout.leftMargin = 2;
        tableWrapLayout.rightMargin = 2;
        tableWrapLayout.horizontalSpacing = 0;
        tableWrapLayout.verticalSpacing = 0;
        tableWrapLayout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        tableWrapLayout.numColumns = numColumns;
        return tableWrapLayout;
    }

    protected Section createSection(Composite parent, int colspan, String text, String description) {
        Section section = this.toolkit.createSection(parent, 450);
        section.clientVerticalSpacing = 2;
        section.setText(text);
        section.setDescription(description);
        section.setLayout((Layout)this.createSectionTableWrapLayout(true, 1));
        TableWrapData tableWrapData = new TableWrapData(256);
        tableWrapData.colspan = colspan;
        section.setLayoutData((Object)tableWrapData);
        return section;
    }

    protected Composite createClient(Section section) {
        return this.createClient(section, 1);
    }

    protected Composite createClient(Section section, int numColumns) {
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.marginTop = 10;
        gridLayout.marginLeft = 15;
        client.setLayout((Layout)gridLayout);
        return client;
    }
}

