/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.listener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.support.ui.listener.IFlowController;
import org.eclipse.chemclipse.support.ui.listener.INextListener;
import org.eclipse.chemclipse.support.ui.listener.IPreviousListener;
import org.eclipse.chemclipse.support.ui.listener.IProcessListener;
import org.eclipse.chemclipse.support.ui.listener.ISaveController;
import org.eclipse.chemclipse.support.ui.listener.ISaveListener;
import org.eclipse.chemclipse.support.ui.listener.IStatusUpdater;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractControllerComposite
extends Composite
implements IFlowController,
IStatusUpdater,
ISaveController {
    private List<INextListener> nextListeners = new ArrayList<INextListener>();
    private List<INextListener> nextSectionListeners = new ArrayList<INextListener>();
    private List<IPreviousListener> previousListeners = new ArrayList<IPreviousListener>();
    private List<IProcessListener> processListeners = new ArrayList<IProcessListener>();
    private ISaveListener saveListener = null;

    public AbstractControllerComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void addNextListener(INextListener nextListener) {
        this.nextListeners.add(nextListener);
    }

    @Override
    public void removeNextListener(INextListener nextListener) {
        this.nextListeners.remove(nextListener);
    }

    @Override
    public void addNextSectionListener(INextListener nextListener) {
        this.nextSectionListeners.add(nextListener);
    }

    @Override
    public void removeNextSectionListener(INextListener nextListener) {
        this.nextSectionListeners.remove(nextListener);
    }

    @Override
    public void addPreviousListener(IPreviousListener previousListener) {
        this.previousListeners.add(previousListener);
    }

    @Override
    public void removePreviousListener(IPreviousListener previousListener) {
        this.previousListeners.remove(previousListener);
    }

    @Override
    public void addProcessListener(IProcessListener processListener) {
        this.processListeners.add(processListener);
    }

    @Override
    public void removeProcessListener(IProcessListener processListener) {
        this.previousListeners.remove(processListener);
    }

    @Override
    public void setSaveListener(ISaveListener saveListener) {
        this.saveListener = saveListener;
    }

    protected void fireUpdateNext() {
        for (INextListener nextListener : this.nextListeners) {
            nextListener.nextAction();
        }
    }

    protected void fireUpdateNextLims() {
        for (INextListener nextListener : this.nextSectionListeners) {
            nextListener.nextAction();
        }
    }

    protected void fireUpdatePrevious() {
        for (IPreviousListener previousListener : this.previousListeners) {
            previousListener.previousAction();
        }
    }

    protected void fireSave() {
        if (this.saveListener != null) {
            this.saveListener.save();
        }
    }

    protected void processAction() {
        for (IProcessListener processListener : this.processListeners) {
            processListener.processAction();
        }
    }
}

