/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.support;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.support.util.FileUtil;

public class MassSpectrumIdentifier {
    private static List<ISupplier> suppliers;

    public static boolean isMassSpectrum(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (suppliers == null) {
            suppliers = MassSpectrumConverter.getMassSpectrumConverterSupport().getSupplier();
        } else {
            String baseFileName = file.toString().toLowerCase();
            if (FileUtil.fileHasExtension((File)file)) {
                for (ISupplier supplier : suppliers) {
                    String supplierExtension = supplier.getFileExtension().toLowerCase();
                    if (supplierExtension == "" || !baseFileName.endsWith(supplierExtension)) continue;
                    return supplier.isImportable();
                }
            } else {
                for (ISupplier supplier : suppliers) {
                    String supplierFileName = supplier.getFileName().toLowerCase();
                    if (supplierFileName == "" || !baseFileName.endsWith(supplierFileName)) continue;
                    return supplier.isImportable();
                }
            }
        }
        return false;
    }

    public static boolean isMassSpectrumDirectory(File file) {
        String directory = file.toString().toUpperCase();
        if (!file.isDirectory()) {
            return false;
        }
        if (suppliers == null) {
            suppliers = MassSpectrumConverter.getMassSpectrumConverterSupport().getSupplier();
        } else {
            for (ISupplier supplier : suppliers) {
                String directoryExtension = supplier.getDirectoryExtension().toUpperCase();
                if (directoryExtension == "" || !directory.endsWith(directoryExtension)) continue;
                return supplier.isImportable();
            }
        }
        return false;
    }
}

