/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.wsd.model.comparator.WavelengthValueComparator;
import org.eclipse.chemclipse.wsd.model.core.AbstractScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.implementation.ScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IWavelengthRange;
import org.eclipse.chemclipse.wsd.model.xwc.WavelengthRange;

public class ExtractedWavelengthSignal
implements IExtractedWavelengthSignal {
    private static final Logger logger = Logger.getLogger(ExtractedWavelengthSignal.class);
    private static final float NORMALIZATION_BASE = 1000.0f;
    private float[] abundanceValues;
    private int startWavelength;
    private int stopWavelength;
    private int retentionTime;
    private float retentionIndex;

    public ExtractedWavelengthSignal(double startWavelength, double stopWavelength) {
        int start = AbstractScanSignalWSD.getWavelength(startWavelength);
        int stop = AbstractScanSignalWSD.getWavelength(stopWavelength);
        start = start < 0 ? 0 : start;
        int n = stop = stop < 0 ? 0 : stop;
        if (startWavelength > stopWavelength) {
            this.startWavelength = stop;
            this.stopWavelength = start;
        } else {
            this.startWavelength = start;
            this.stopWavelength = stop;
        }
        int count = this.stopWavelength - this.startWavelength + 1;
        if (count > 0) {
            this.abundanceValues = new float[count];
        }
    }

    public ExtractedWavelengthSignal(List<IScanSignalWSD> wavelengths) {
        wavelengths = new ArrayList<IScanSignalWSD>(wavelengths);
        if (wavelengths != null && wavelengths.size() > 0) {
            Collections.sort(wavelengths, new WavelengthValueComparator());
            this.startWavelength = AbstractScanSignalWSD.getWavelength(wavelengths.get(0).getWavelength());
            this.stopWavelength = AbstractScanSignalWSD.getWavelength(wavelengths.get(wavelengths.size() - 1).getWavelength());
            int count = this.stopWavelength - this.startWavelength + 1;
            if (count > 0) {
                this.abundanceValues = new float[count];
            }
            for (IScanSignalWSD scanSignalWSD : wavelengths) {
                this.setAbundance(scanSignalWSD);
            }
        }
    }

    @Override
    public void setAbundance(IScanSignalWSD scanSignal, boolean removePreviousAbundance) {
        if (removePreviousAbundance) {
            int wavelengthActual = AbstractScanSignalWSD.getWavelength(scanSignal.getWavelength());
            if (this.isValidWavelength(wavelengthActual)) {
                int position = wavelengthActual - this.startWavelength;
                this.abundanceValues[position] = scanSignal.getAbundance();
            }
        } else {
            this.setAbundance(scanSignal);
        }
    }

    @Override
    public void setAbundance(IScanSignalWSD scanSignal) {
        int wavelengthActual = AbstractScanSignalWSD.getWavelength(scanSignal.getWavelength());
        if (this.isValidWavelength(wavelengthActual)) {
            int position;
            int n = position = wavelengthActual - this.startWavelength;
            this.abundanceValues[n] = this.abundanceValues[n] + scanSignal.getAbundance();
        }
    }

    @Override
    public void setAbundance(int wavelength, float abundance) {
        try {
            ScanSignalWSD defaultWavelength = new ScanSignalWSD(wavelength, abundance);
            this.setAbundance(defaultWavelength);
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public void setAbundance(int ion, float abundance, boolean removePreviousAbundance) {
        try {
            ScanSignalWSD defaultWavelength = new ScanSignalWSD(ion, abundance);
            this.setAbundance(defaultWavelength, removePreviousAbundance);
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public float getAbundance(int wavelength) {
        if (this.isValidWavelength(wavelength)) {
            int position = wavelength - this.startWavelength;
            return this.abundanceValues[position];
        }
        return 0.0f;
    }

    @Override
    public int getNumberOfWavelengthValues() {
        if (this.abundanceValues == null) {
            return 0;
        }
        return this.abundanceValues.length;
    }

    @Override
    public float getTotalSignal() {
        float totalSignal = 0.0f;
        if (this.abundanceValues != null && this.abundanceValues.length > 0) {
            totalSignal = Calculations.getSum((float[])this.abundanceValues);
        }
        return totalSignal;
    }

    @Override
    public int getWavelengthMaxIntensity() {
        if (this.abundanceValues.length == 0) {
            return 0;
        }
        float maxIntensity = this.getMaxIntensity();
        if (maxIntensity == 0.0f) {
            return 0;
        }
        int i = 0;
        while (i < this.abundanceValues.length) {
            if (this.abundanceValues[i] == maxIntensity) {
                return i + this.startWavelength;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public float getMaxIntensity() {
        return Calculations.getMax((float[])this.abundanceValues);
    }

    @Override
    public float getNthHighestIntensity(int n) {
        if (n <= 0 || n > this.abundanceValues.length) {
            return 0.0f;
        }
        float[] values = Arrays.copyOf(this.abundanceValues, this.abundanceValues.length);
        Arrays.sort(values);
        return values[values.length - n];
    }

    @Override
    public float getMinIntensity() {
        return Calculations.getMin((float[])this.abundanceValues);
    }

    @Override
    public float getMeanIntensity() {
        System.out.println("JUNIT");
        return Calculations.getMean((float[])this.abundanceValues);
    }

    @Override
    public float getMedianIntensity() {
        return Calculations.getMedian((float[])this.abundanceValues);
    }

    @Override
    public int getRetentionTime() {
        return this.retentionTime;
    }

    @Override
    public void setRetentionTime(int retentionTime) {
        if (retentionTime >= 0) {
            this.retentionTime = retentionTime;
        }
    }

    @Override
    public float getRetentionIndex() {
        return this.retentionIndex;
    }

    @Override
    public void setRetentionIndex(float retentionIndex) {
        if (retentionIndex >= 0.0f) {
            this.retentionIndex = retentionIndex;
        }
    }

    @Override
    public int getStartWavelength() {
        return this.startWavelength;
    }

    @Override
    public int getStopWavelength() {
        return this.stopWavelength;
    }

    @Override
    public IWavelengthRange getWavelengthRange() {
        WavelengthRange wavelengthRange = new WavelengthRange(this.startWavelength, this.stopWavelength);
        return wavelengthRange;
    }

    @Override
    public void normalize() {
        this.normalize(1000.0f);
    }

    @Override
    public void normalize(float normalizationBase) {
        float maxIntensity;
        if (normalizationBase > 0.0f && (maxIntensity = Calculations.getMax((float[])this.abundanceValues)) > 0.0f) {
            float factor = normalizationBase / maxIntensity;
            int i = 0;
            while (i < this.abundanceValues.length) {
                this.abundanceValues[i] = factor * this.abundanceValues[i];
                ++i;
            }
        }
    }

    private boolean isValidWavelength(int wavelength) {
        if (this.abundanceValues == null) {
            return false;
        }
        return wavelength >= this.startWavelength && wavelength <= this.stopWavelength;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ExtractedWavelengthSignal extractedWavelengthSignal = (ExtractedWavelengthSignal)otherObject;
        return this.startWavelength == extractedWavelengthSignal.startWavelength && this.stopWavelength == extractedWavelengthSignal.stopWavelength && this.getNumberOfWavelengthValues() == extractedWavelengthSignal.getNumberOfWavelengthValues() && this.getTotalSignal() == extractedWavelengthSignal.getTotalSignal();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.startWavelength).hashCode() + 9 * Integer.valueOf(this.stopWavelength).hashCode() + 11 * Integer.valueOf(this.getNumberOfWavelengthValues()).hashCode() + 13 * Float.valueOf(this.getTotalSignal()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startWavelength=" + this.startWavelength);
        builder.append(",");
        builder.append("stopWavelength=" + this.stopWavelength);
        builder.append(",");
        builder.append("numberOfWavelengthValues=" + this.getNumberOfWavelengthValues());
        builder.append(",");
        builder.append("totalSignal=" + this.getTotalSignal());
        builder.append("]");
        return builder.toString();
    }
}

