/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.io.IFileHelper;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.ChromatogramReaderCSD;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.IChromatogramCSDZipReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.implementation.ChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.implementation.PeakModelCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.columns.RetentionIndexEntry;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ChromatogramComparisonResult;
import org.eclipse.chemclipse.model.identifier.ChromatogramLibraryInformation;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.model.implementation.IntegrationEntry;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.implementation.QuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.InternalStandard;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ChromatogramReaderMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.support.history.EditInformation;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.ChromatogramReaderWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.BaselineElement;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.IBaselineElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChromatogramReader_1301
extends AbstractChromatogramReader
implements IChromatogramCSDZipReader {
    private static final Logger logger = Logger.getLogger(ChromatogramReader_1301.class);

    public IChromatogramCSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramCSD chromatogram = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                chromatogram = this.readFromZipFile(zipFile, "", file, monitor);
            }
        }
        return chromatogram;
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramCSD chromatogramOverview = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                chromatogramOverview = this.readFromZipFile(zipFile, "", file, monitor);
            }
        }
        return chromatogramOverview;
    }

    @Override
    public IChromatogramCSD read(ZipInputStream zipInputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readZipData(zipInputStream, directoryPrefix, null, monitor);
    }

    @Override
    public IChromatogramCSD read(ZipFile zipFile, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readFromZipFile(zipFile, directoryPrefix, null, monitor);
    }

    private IChromatogramCSD readFromZipFile(ZipFile zipFile, String directoryPrefix, File file, IProgressMonitor monitor) throws IOException {
        return this.readZipData(zipFile, directoryPrefix, file, monitor);
    }

    private IChromatogramCSD readZipData(Object object, String directoryPrefix, File file, IProgressMonitor monitor) throws IOException {
        VendorChromatogram chromatogram = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Read Chromatogram", (int)100);
        try {
            boolean closeStream;
            if (object instanceof ZipFile) {
                closeStream = true;
            } else if (object instanceof ZipInputStream) {
                closeStream = false;
            } else {
                return null;
            }
            chromatogram = new VendorChromatogram();
            this.readMethod(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/SYSTEM_SETTINGS"), closeStream, chromatogram);
            this.readScans(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/SCANS"), closeStream, chromatogram);
            this.readBaseline(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/BASELINE"), closeStream, chromatogram);
            subMonitor.worked(20);
            this.readPeaks(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/PEAKS"), closeStream, chromatogram);
            this.readArea(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/AREA"), closeStream, chromatogram);
            subMonitor.worked(20);
            this.readIdentification(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/IDENTIFICATION"), closeStream, chromatogram);
            this.readHistory(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/HISTORY"), closeStream, chromatogram);
            subMonitor.worked(20);
            this.readMiscellaneous(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/MISC"), closeStream, chromatogram);
            this.readSeparationColumn(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/SEPARATION_COLUMN"), closeStream, chromatogram);
            this.setAdditionalInformation(file, chromatogram);
            subMonitor.worked(20);
            try {
                int size = this.readChromatogramReferenceInfo(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "REFERENCE_INFO"), closeStream);
                this.readReferencedChromatograms(object, directoryPrefix, chromatogram, size, closeStream, monitor);
                subMonitor.worked(20);
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
        return chromatogram;
    }

    private void readMethod(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        IMethod method = chromatogram.getMethod();
        method.setInstrumentName(this.readString(dataInputStream));
        method.setIonSource(this.readString(dataInputStream));
        method.setSamplingRate(dataInputStream.readDouble());
        method.setSolventDelay(dataInputStream.readInt());
        method.setSourceHeater(dataInputStream.readDouble());
        method.setStopMode(this.readString(dataInputStream));
        method.setStopTime(dataInputStream.readInt());
        method.setTimeFilterPeakWidth(dataInputStream.readInt());
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readScans(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = dataInputStream.readInt();
            int relativeRetentionTime = dataInputStream.readInt();
            float totalSignal = dataInputStream.readFloat();
            VendorScan scanCSD = new VendorScan(retentionTime, totalSignal);
            scanCSD.setRelativeRetentionTime(relativeRetentionTime);
            int retentionTimeColumn1 = dataInputStream.readInt();
            int retentionTimeColumn2 = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            if (dataInputStream.readBoolean()) {
                int size = dataInputStream.readInt();
                int i = 0;
                while (i < size) {
                    RetentionIndexType retentionIndexType = RetentionIndexType.valueOf((String)this.readString(dataInputStream));
                    float retentionIndexAdditional = dataInputStream.readFloat();
                    scanCSD.setRetentionIndex(retentionIndexType, retentionIndexAdditional);
                    ++i;
                }
            }
            int timeSegmentId = dataInputStream.readInt();
            int cycleNumber = dataInputStream.readInt();
            scanCSD.setRetentionTimeColumn1(retentionTimeColumn1);
            scanCSD.setRetentionTimeColumn2(retentionTimeColumn2);
            scanCSD.setRetentionIndex(retentionIndex);
            scanCSD.setTimeSegmentId(timeSegmentId);
            scanCSD.setCycleNumber(cycleNumber);
            this.readScanIdentificationTargets(dataInputStream, scanCSD);
            chromatogram.addScan((IScan)scanCSD);
            ++scan;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readBaseline(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        int scans = dataInputStream.readInt();
        ArrayList<BaselineElement> baselineElements = new ArrayList<BaselineElement>();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = dataInputStream.readInt();
            float backgroundAbundance = dataInputStream.readFloat();
            BaselineElement baselineElement = new BaselineElement(retentionTime, backgroundAbundance);
            baselineElements.add(baselineElement);
            ++scan;
        }
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int index = 0;
        while (index < scans - 1) {
            IBaselineElement baselineElement = (IBaselineElement)baselineElements.get(index);
            IBaselineElement baselineElementNext = (IBaselineElement)baselineElements.get(index + 1);
            int startRetentionTime = baselineElement.getRetentionTime();
            float startBackgroundAbundance = baselineElement.getBackgroundAbundance();
            int stopRetentionTime = baselineElementNext.getRetentionTime();
            float stopBackgroundAbundance = baselineElementNext.getBackgroundAbundance();
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++index;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readPeaks(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        int numberOfPeaks = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeaks) {
            try {
                IChromatogramPeakCSD peak = this.readPeak(dataInputStream, chromatogram);
                chromatogram.addPeak((IPeak)peak);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private IChromatogramPeakCSD readPeak(DataInputStream dataInputStream, IChromatogramCSD chromatogram) throws IOException, IllegalArgumentException, PeakException {
        String detectorDescription = this.readString(dataInputStream);
        String quantifierDescription = this.readString(dataInputStream);
        boolean activeForAnalysis = dataInputStream.readBoolean();
        String integratorDescription = this.readString(dataInputStream);
        String modelDescription = this.readString(dataInputStream);
        PeakType peakType = PeakType.valueOf((String)this.readString(dataInputStream));
        int suggestedNumberOfComponents = dataInputStream.readInt();
        String peakName = this.readString(dataInputStream);
        List classifiers = IFileHelper.readStringCollection((DataInputStream)dataInputStream);
        float startBackgroundAbundance = dataInputStream.readFloat();
        float stopBackgroundAbundance = dataInputStream.readFloat();
        int retentionTime = dataInputStream.readInt();
        int relativeRetentionTime = dataInputStream.readInt();
        float totalSignalScan = dataInputStream.readFloat();
        VendorScan peakMaximum = new VendorScan(retentionTime, totalSignalScan);
        peakMaximum.setRelativeRetentionTime(relativeRetentionTime);
        int retentionTimeColumn1 = dataInputStream.readInt();
        int retentionTimeColumn2 = dataInputStream.readInt();
        float retentionIndexScan = dataInputStream.readFloat();
        if (dataInputStream.readBoolean()) {
            int size = dataInputStream.readInt();
            int i = 0;
            while (i < size) {
                RetentionIndexType retentionIndexType = RetentionIndexType.valueOf((String)this.readString(dataInputStream));
                float retentionIndexAdditional = dataInputStream.readFloat();
                peakMaximum.setRetentionIndex(retentionIndexType, retentionIndexAdditional);
                ++i;
            }
        }
        int timeSegmentId = dataInputStream.readInt();
        int cycleNumber = dataInputStream.readInt();
        peakMaximum.setRetentionIndex(retentionIndexScan);
        peakMaximum.setRetentionTimeColumn1(retentionTimeColumn1);
        peakMaximum.setRetentionTimeColumn2(retentionTimeColumn2);
        peakMaximum.setTimeSegmentId(timeSegmentId);
        peakMaximum.setCycleNumber(cycleNumber);
        int numberOfRetentionTimes = dataInputStream.readInt();
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        int i = 1;
        while (i <= numberOfRetentionTimes) {
            int retentionTimePeak = dataInputStream.readInt();
            float relativeIntensity = dataInputStream.readFloat();
            intensityValues.addIntensityValue(retentionTimePeak, relativeIntensity);
            ++i;
        }
        intensityValues.normalize();
        PeakModelCSD peakModel = new PeakModelCSD((IScan)peakMaximum, (IPeakIntensityValues)intensityValues, startBackgroundAbundance, stopBackgroundAbundance);
        ChromatogramPeakCSD peak = new ChromatogramPeakCSD((IPeakModelCSD)peakModel, chromatogram);
        peak.setDetectorDescription(detectorDescription);
        peak.setQuantifierDescription(quantifierDescription);
        peak.setActiveForAnalysis(activeForAnalysis);
        peak.setIntegratorDescription(integratorDescription);
        peak.setModelDescription(modelDescription);
        peak.setPeakType(peakType);
        peak.setSuggestedNumberOfComponents(suggestedNumberOfComponents);
        for (String c : classifiers) {
            peak.addClassifier(c);
        }
        List<IIntegrationEntry> integrationEntries = this.readIntegrationEntries(dataInputStream);
        peak.setIntegratedArea(integrationEntries, integratorDescription);
        this.readPeakIdentificationTargets(dataInputStream, (IPeakCSD)peak);
        this.readPeakQuantitationEntries(dataInputStream, (IPeakCSD)peak);
        List<IInternalStandard> internalStandards = this.readInternalStandards(dataInputStream);
        peak.addInternalStandards(internalStandards);
        String currentName = peak.getName();
        if (currentName == null || !currentName.equals(peakName)) {
            peak.setName(peakName);
        }
        return peak;
    }

    private void readArea(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        String integratorDescription = this.readString(dataInputStream);
        List<IIntegrationEntry> chromatogramIntegrationEntries = this.readIntegrationEntries(dataInputStream);
        this.readString(dataInputStream);
        List<IIntegrationEntry> backgroundIntegrationEntries = this.readIntegrationEntries(dataInputStream);
        chromatogram.setIntegratedArea(chromatogramIntegrationEntries, backgroundIntegrationEntries, integratorDescription);
        if (closeStream) {
            dataInputStream.close();
        }
    }

    @Override
    public String readString(DataInputStream dataInputStream) throws IOException {
        return IFileHelper.readString((DataInputStream)dataInputStream);
    }

    private void setAdditionalInformation(File file, IChromatogramCSD chromatogram) {
        int startRetentionTime;
        chromatogram.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
        chromatogram.setFile(file);
        int scanDelay = startRetentionTime = chromatogram.getStartRetentionTime();
        chromatogram.setScanDelay(scanDelay);
        int endRetentionTime = chromatogram.getStopRetentionTime();
        int scanInterval = endRetentionTime / chromatogram.getNumberOfScans();
        chromatogram.setScanInterval(scanInterval);
    }

    private List<IIntegrationEntry> readIntegrationEntries(DataInputStream dataInputStream) throws IOException {
        ArrayList<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
        int numberOfIntegrationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIntegrationEntries) {
            double integratedArea = dataInputStream.readDouble();
            IntegrationEntry integrationEntry = new IntegrationEntry(integratedArea);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
            ++i;
        }
        return integrationEntries;
    }

    private List<IInternalStandard> readInternalStandards(DataInputStream dataInputStream) throws IOException {
        ArrayList<IInternalStandard> internalStandards = new ArrayList<IInternalStandard>();
        int numberOfInternalStandards = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfInternalStandards) {
            String name = this.readString(dataInputStream);
            double concentration = dataInputStream.readDouble();
            String concentrationUnit = this.readString(dataInputStream);
            double responseFactor = dataInputStream.readDouble();
            String chemicalClass = this.readString(dataInputStream);
            InternalStandard internalStandard = new InternalStandard(name, concentration, concentrationUnit, responseFactor);
            internalStandard.setChemicalClass(chemicalClass);
            internalStandards.add((IInternalStandard)internalStandard);
            ++i;
        }
        return internalStandards;
    }

    private void readIdentification(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        int numberOfTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            int retentionTime = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            ChromatogramLibraryInformation libraryInformation = new ChromatogramLibraryInformation();
            libraryInformation.setRetentionTime(retentionTime);
            libraryInformation.setRetentionIndex(retentionIndex);
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            ChromatogramComparisonResult comparisonResult = new ChromatogramComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                IdentificationTarget identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                chromatogram.getTargets().add(identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readHistory(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        IEditHistory editHistory = chromatogram.getEditHistory();
        int numberOfEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfEntries) {
            long time = dataInputStream.readLong();
            String description = this.readString(dataInputStream);
            Date date = new Date(time);
            EditInformation editInformation = new EditInformation(date, description);
            editHistory.add((Object)editInformation);
            ++i;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readMiscellaneous(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        int numberOfEntries = dataInputStream.readInt();
        int i = 0;
        while (i < numberOfEntries) {
            String key = this.readString(dataInputStream);
            String value = this.readString(dataInputStream);
            chromatogram.putHeaderData(key, value);
            ++i;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readSeparationColumn(DataInputStream dataInputStream, boolean closeStream, IChromatogramCSD chromatogram) throws IOException {
        int numberOfEntries = dataInputStream.readInt();
        ISeparationColumnIndices separationColumnIndices = chromatogram.getSeparationColumnIndices();
        int i = 0;
        while (i < numberOfEntries) {
            String name = this.readString(dataInputStream);
            int retentionTime = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            RetentionIndexEntry retentionIndexEntry = new RetentionIndexEntry(retentionTime, retentionIndex, name);
            separationColumnIndices.put((IRetentionIndexEntry)retentionIndexEntry);
            ++i;
        }
        ISeparationColumn separationColumn = separationColumnIndices.getSeparationColumn();
        separationColumn.setName(this.readString(dataInputStream));
        separationColumn.setLength(this.readString(dataInputStream));
        separationColumn.setDiameter(this.readString(dataInputStream));
        separationColumn.setPhase(this.readString(dataInputStream));
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private int readChromatogramReferenceInfo(DataInputStream dataInputStream, boolean closeStream) throws IOException {
        int size = dataInputStream.readInt();
        if (closeStream) {
            dataInputStream.close();
        }
        return size;
    }

    private void readReferencedChromatograms(Object object, String directoryPrefix, IChromatogramCSD chromatogram, int size, boolean closeStream, IProgressMonitor monitor) throws IOException {
        int i = 0;
        while (i < size) {
            String directory = String.valueOf(directoryPrefix) + "CHROMATOGRAM_REFERENCE" + "_" + i + "/";
            DataInputStream dataInputStream = this.getDataInputStream(object, String.valueOf(directory) + "CHROMATOGRAM_TYPE");
            String dataType = this.readString(dataInputStream);
            if (closeStream) {
                dataInputStream.close();
            }
            this.parseChromatogram(object, dataType, directory, chromatogram, closeStream, monitor);
            ++i;
        }
    }

    private void parseChromatogram(Object object, String dataType, String directoryPrefix, IChromatogramCSD chromatogram, boolean closeStream, IProgressMonitor monitor) throws IOException {
        String directory = String.valueOf(directoryPrefix) + "CHROMATOGRAM_REFERENCE" + "/";
        if (object instanceof ZipFile) {
            ZipFile zipFile = (ZipFile)object;
            if (dataType.equals("MSD")) {
                ChromatogramReaderMSD chromatogramReaderMSD = new ChromatogramReaderMSD();
                IChromatogramMSD chromatogramMSD = chromatogramReaderMSD.read(zipFile, directory, monitor);
                chromatogram.addReferencedChromatogram((IChromatogram)chromatogramMSD);
            } else if (dataType.equals("CSD")) {
                ChromatogramReaderCSD chromatogramReaderCSD = new ChromatogramReaderCSD();
                IChromatogramCSD chromatogramCSD = chromatogramReaderCSD.read(zipFile, directory, monitor);
                chromatogram.addReferencedChromatogram((IChromatogram)chromatogramCSD);
            } else if (dataType.equals("WSD")) {
                ChromatogramReaderWSD chromatogramReaderWSD = new ChromatogramReaderWSD();
                IChromatogramWSD chromatogramWSD = chromatogramReaderWSD.read(zipFile, directory, monitor);
                chromatogram.addReferencedChromatogram((IChromatogram)chromatogramWSD);
            }
        }
    }

    private void readScanIdentificationTargets(DataInputStream dataInputStream, IScanCSD scanCSD) throws IOException {
        int numberOfTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            int retentionTime = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            LibraryInformation libraryInformation = new LibraryInformation();
            libraryInformation.setRetentionTime(retentionTime);
            libraryInformation.setRetentionIndex(retentionIndex);
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            ComparisonResult comparisonResult = new ComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                IdentificationTarget identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                scanCSD.getTargets().add(identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private void readPeakIdentificationTargets(DataInputStream dataInputStream, IPeakCSD peak) throws IOException {
        int numberOfPeakTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeakTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            int retentionTime = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
            libraryInformation.setRetentionTime(retentionTime);
            libraryInformation.setRetentionIndex(retentionIndex);
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            PeakComparisonResult comparisonResult = new PeakComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                IdentificationTarget identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                peak.getTargets().add(identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private void readPeakQuantitationEntries(DataInputStream dataInputStream, IPeakCSD peak) throws IOException {
        int numberOfQuantitationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfQuantitationEntries) {
            String name = this.readString(dataInputStream);
            String chemicalClass = this.readString(dataInputStream);
            double concentration = dataInputStream.readDouble();
            String concentrationUnit = this.readString(dataInputStream);
            double area = dataInputStream.readDouble();
            String calibrationMethod = this.readString(dataInputStream);
            boolean usedCrossZero = dataInputStream.readBoolean();
            String description = this.readString(dataInputStream);
            double signal = 0.0;
            boolean isSignal = dataInputStream.readBoolean();
            if (isSignal) {
                signal = dataInputStream.readDouble();
            }
            QuantitationEntry quantitationEntry = new QuantitationEntry(name, concentration, concentrationUnit, area);
            quantitationEntry.setSignal(signal);
            quantitationEntry.setChemicalClass(chemicalClass);
            quantitationEntry.setCalibrationMethod(calibrationMethod);
            quantitationEntry.setUsedCrossZero(usedCrossZero);
            quantitationEntry.setDescription(description);
            peak.addQuantitationEntry((IQuantitationEntry)quantitationEntry);
            ++i;
        }
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        if (version.equals("1.3.0.1")) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }
}

