/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.converter;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.AbstractChromatogramImportConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ChromatogramReaderMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.SpecificationValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChromatogramImportConverter
extends AbstractChromatogramImportConverter<IChromatogramMSD> {
    private static final Logger logger = Logger.getLogger(ChromatogramImportConverter.class);

    public IProcessingInfo<IChromatogramMSD> convert(File file, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Convert file " + file.getName()), (int)100);
        try {
            subMonitor.subTask("Validate");
            IProcessingInfo processingInfo = super.validate(file);
            if (!processingInfo.hasErrorMessages()) {
                file = SpecificationValidator.validateSpecification(file);
                subMonitor.worked(1);
                ChromatogramReaderMSD reader = new ChromatogramReaderMSD();
                monitor.subTask("Import Chromatogram");
                try {
                    IChromatogramMSD chromatogram = reader.read(file, (IProgressMonitor)subMonitor.split(99));
                    processingInfo.setProcessingResult((Object)chromatogram);
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                    processingInfo.addErrorMessage("Import Converter", "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
                }
            }
            IProcessingInfo iProcessingInfo = processingInfo;
            return iProcessingInfo;
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }

    public IProcessingInfo convertOverview(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file);
        if (!processingInfo.hasErrorMessages()) {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReaderMSD reader = new ChromatogramReaderMSD();
            try {
                IChromatogramOverview chromatogramOverview = reader.readOverview(file, monitor);
                processingInfo.setProcessingResult((Object)chromatogramOverview);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("Import Converter", "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

