/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods.GenericStreamMethodFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ObjectStreamMethodFormat
extends GenericStreamMethodFormat {
    protected ObjectStreamMethodFormat(String version) {
        super(version);
    }

    @Override
    protected final IProcessMethod deserialize(InputStream stream, MessageConsumer consumer, IProgressMonitor monitor) throws IOException {
        try {
            return this.readObjectFromStream(new ObjectInputStream(stream), consumer, monitor);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("corrupted stream", e);
        }
    }

    @Override
    protected final void serialize(OutputStream stream, IProcessMethod processMethod, MessageConsumer consumer, IProgressMonitor monitor) throws IOException {
        ObjectOutputStream objectStream = new ObjectOutputStream(stream);
        this.writeObjectToStream(objectStream, processMethod, consumer, monitor);
        objectStream.flush();
    }

    protected abstract void writeObjectToStream(ObjectOutputStream var1, IProcessMethod var2, MessageConsumer var3, IProgressMonitor var4) throws IOException;

    protected abstract IProcessMethod readObjectFromStream(ObjectInputStream var1, MessageConsumer var2, IProgressMonitor var3) throws IOException, ClassNotFoundException;

    public static <T> void readItems(ObjectInputStream stream, ObjectInputStreamDeserializer<T> deserializer, Consumer<? super T> consumer) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        int i = 0;
        while (i < count) {
            consumer.accept(deserializer.deserialize(stream));
            ++i;
        }
    }

    public static <T> void writeIterable(Iterable<T> iterable, ObjectOutputStream stream, ObjectOutputStreamSerializer<? super T> serializer) throws IOException {
        if (iterable == null) {
            stream.writeInt(0);
        } else {
            ArrayList list = new ArrayList();
            iterable.forEach(list::add);
            stream.writeInt(list.size());
            for (Object item : list) {
                serializer.serialize(item, stream);
            }
        }
    }

    public static <T> void writeArray(T[] array, ObjectOutputStream stream, ObjectOutputStreamSerializer<? super T> serializer) throws IOException {
        stream.writeInt(array.length);
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            serializer.serialize(item, stream);
            ++n2;
        }
    }

    public static <Key, Value> void writeMap(Map<Key, Value> map, ObjectOutputStream stream, ObjectOutputStreamSerializer<? super Key> keySerializer, ObjectOutputStreamSerializer<? super Value> valueSerializer) throws IOException {
        Set<Map.Entry<Key, Value>> entrySet = map.entrySet();
        stream.writeInt(entrySet.size());
        for (Map.Entry<Key, Value> entry : entrySet) {
            keySerializer.serialize(entry.getKey(), stream);
            valueSerializer.serialize(entry.getValue(), stream);
        }
    }

    public static <Key, Value> void readMap(ObjectInputStream stream, ObjectInputStreamDeserializer<? extends Key> keyDeserialization, ObjectInputStreamDeserializer<? extends Value> valueDeserialization, BiConsumer<? super Key, ? super Value> consumer) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        int i = 0;
        while (i < count) {
            Key key = keyDeserialization.deserialize(stream);
            Value value = valueDeserialization.deserialize(stream);
            consumer.accept(key, value);
            ++i;
        }
    }

    public static <T extends Enum<T>> ObjectInputStreamDeserializer<T> enumDeserialization(Class<T> type, T missingValue) {
        Enum[] constants = (Enum[])type.getEnumConstants();
        return stream -> {
            Object readObject = stream.readObject();
            Enum[] enumArray2 = constants;
            int n = constants.length;
            int n2 = 0;
            while (n2 < n) {
                Enum constant = enumArray2[n2];
                if (constant.name().equals(readObject)) {
                    return constant;
                }
                ++n2;
            }
            return missingValue;
        };
    }

    public static <T extends Enum<T>> void writeEnum(T enumValue, ObjectOutputStream stream) throws IOException {
        stream.writeObject(enumValue.name());
    }

    public static String readString(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        return (String)stream.readObject();
    }

    public static void writeString(String str, ObjectOutputStream stream) throws IOException {
        stream.writeObject(str);
    }

    public static interface ObjectInputStreamDeserializer<T> {
        public T deserialize(ObjectInputStream var1) throws IOException, ClassNotFoundException;
    }

    public static interface ObjectOutputStreamSerializer<T> {
        public void serialize(T var1, ObjectOutputStream var2) throws IOException;
    }
}

