/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.gson.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.msd.converter.supplier.gson.model.JsonMassspectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;

public class JsonPeakModelMSD
extends PeakModelMSD {
    private static final String KEY_PEAK_MODEL_MASS_SPECTRUM = "massspectrum";
    private static final String KEY_PEAK_MODEL_INTENSITIES = "intensities";
    private static final long serialVersionUID = 1L;

    private JsonPeakModelMSD(IPeakMassSpectrum peakMaximum, IPeakIntensityValues peakIntensityValues) throws IllegalArgumentException, PeakException {
        super(peakMaximum, peakIntensityValues);
    }

    public static void writePeakModel(JsonWriter writer, IPeakModelMSD peakModel) throws IOException {
        writer.beginObject();
        writer.name(KEY_PEAK_MODEL_MASS_SPECTRUM);
        JsonMassspectrum.writeMassspectrum(writer, (IScanMSD)peakModel.getPeakMassSpectrum());
        writer.name(KEY_PEAK_MODEL_INTENSITIES);
        JsonPeakModelMSD.writeIntensities(writer, peakModel);
        writer.endObject();
    }

    public static IPeakModelMSD readPeakModel(JsonElement jsonElement) throws IOException {
        JsonObject object = jsonElement.getAsJsonObject();
        IPeakIntensityValues intensities = JsonPeakModelMSD.readIntensities(object.get(KEY_PEAK_MODEL_INTENSITIES).getAsJsonArray());
        try {
            return new JsonPeakModelMSD(JsonMassspectrum.readMassspectrum(object.get(KEY_PEAK_MODEL_MASS_SPECTRUM)), intensities);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("can't read peaks from file", e);
        }
    }

    private static void writeIntensities(JsonWriter json, IPeakModelMSD peakModel) throws IOException {
        json.beginArray();
        List retentionTimes = peakModel.getRetentionTimes();
        for (Integer rt : retentionTimes) {
            float abundance = peakModel.getPeakAbundance(rt.intValue());
            json.value((double)rt.floatValue());
            json.value((double)abundance);
        }
        json.endArray();
    }

    private static IPeakIntensityValues readIntensities(JsonArray json) {
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        int i = 0;
        while (i < json.size()) {
            int rt = json.get(i).getAsInt();
            float abundance = json.get(i + 1).getAsFloat();
            intensityValues.addIntensityValue(rt, abundance);
            i += 2;
        }
        intensityValues.normalize();
        return intensityValues;
    }
}

