/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.codegen.ada.transformations;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.codegen.ada.Activator;
import org.polarsys.chess.codegen.ada.transformations.AcceleoCodeGen;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.m2m.transformations.TransUtil;
import org.polarsys.chess.monitoring.monitoringxml.AnalysisContext;
import org.polarsys.chess.monitoring.monitoringxml.Monitoring;
import org.polarsys.chess.monitoring.monitoringxml.MonitoringxmlFactory;
import org.polarsys.chess.monitoring.monitoringxml.Thread;
import org.polarsys.chess.multicore.model.CHTask;
import org.polarsys.chess.multicore.utils.QueryUtils;

public class Transformations {
    public static void performCodeGeneration(PapyrusMultiDiagramEditor editor, IFile model, IProgressMonitor monitor) throws Exception {
        ModelContent mc = TransUtil.loadModel((IFile)model);
        Model mi = (Model)mc.getContent().get(0);
        String codeGenDir = "src-gen_" + mi.getName();
        IFolder srcDir = model.getProject().getFolder(codeGenDir);
        CHESSProjectSupport.bundleToProjectCopy((String)"org.polarsys.chess.codegen.ada", (Plugin)Activator.getDefault(), (String)"src-lib", (IProject)model.getProject(), (String)codeGenDir, (boolean)false);
        CHESSProjectSupport.createFolder((IFolder)model.getProject().getFolder(String.valueOf(codeGenDir) + "/obj"));
        AcceleoCodeGen.runCodegen(model, (IContainer)srcDir, monitor);
    }

    public static void performXMLGeneration(IFile inputFile, String saAnalysisName, IProgressMonitor monitor) throws Exception {
        ModelContent mc = TransUtil.loadModel((IFile)inputFile);
        Model model = (Model)mc.getContent().get(0);
        String codeGenDir = "src-gen_" + model.getName();
        IFolder srcDir = inputFile.getProject().getFolder(codeGenDir);
        try {
            srcDir.create(false, true, null);
        }
        catch (Exception exception) {}
        MonitoringxmlFactory factory = MonitoringxmlFactory.eINSTANCE;
        Monitoring mon = factory.createMonitoring();
        AnalysisContext analysisContext = factory.createAnalysisContext();
        analysisContext.setName(saAnalysisName);
        mon.setAnalysisContext(analysisContext);
        EList instances = UMLUtils.getAllComponentInstances((Model)model, (boolean)false);
        EList tasks = QueryUtils.getCHTasksList((EList)instances);
        String taskName = "";
        for (CHTask chTask : tasks) {
            Thread thread = factory.createThread();
            taskName = chTask.getName();
            if (taskName.endsWith("_task")) {
                int ind = taskName.lastIndexOf("_task");
                taskName = taskName.substring(0, ind);
            }
            thread.setName(taskName);
            mon.getThreadNames().add((Object)thread);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createURI((String)(srcDir.getLocationURI() + "/monitoring.xml")));
        resource.getContents().add((Object)mon);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

