/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.validation.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.BoundedSubtype;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.CollectionType;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.polarsys.chess.contracts.integration.ToolIntegration;
import org.polarsys.chess.contracts.profile.chesscontract.ComponentInstance;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinement;
import org.polarsys.chess.contracts.profile.chesscontract.DataTypes.ContractTypes;

public class OCRAConstraints
extends AbstractModelConstraint {
    private static final String BLOCK = "SysML::Blocks::Block";
    private static final String FLOWPORT = "SysML::PortAndFlows::FlowPort";
    private static final String FLOWPORTMARTE = "MARTE::MARTE_DesignModel::GCM::FlowPort";
    private static final String SYSVIEW = "CHESS::Core::CHESSViews::SystemView";
    private static final String COMPVIEW = "CHESS::Core::CHESSViews::ComponentView";
    private static final String FORMPROP = "CHESSContract::FormalProperty";
    private static final String SYSTEM = "CHESSContract::System";
    private static final String SUBSYSTEM = "CHESSContract::SubSystem";
    private static final String CONTRACTPROP = "CHESSContract::ContractProperty";
    private static final String COMPINST = "CHESSContract::ComponentInstance";
    public static final String BOUNDEDSUBTYPE = "MARTE::MARTE_Annexes::VSL::DataTypes::BoundedSubtype";
    public static final String COLLECTIONTYPE = "MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType";

    public IStatus validate(IValidationContext ctx) {
        System.out.println("Checking model for NuSMV3 analysis tool");
        IStatus success = ctx.createSuccessStatus();
        IStatus failure = ctx.createFailureStatus(new Object[0]);
        ArrayList<? extends ConstraintStatus> allResults = new ArrayList<ConstraintStatus>();
        Model model = (Model)ctx.getTarget();
        Package sysView = null;
        Package compView = null;
        for (Package pkg : model.getNestedPackages()) {
            if (pkg.getAppliedStereotype(SYSVIEW) != null) {
                sysView = pkg;
            }
            if (pkg.getAppliedStereotype(COMPVIEW) == null) continue;
            compView = pkg;
        }
        if (sysView == null) {
            return failure;
        }
        ArrayList<Class> allBlocks = new ArrayList<Class>();
        ArrayList<Port> allFlowPorts = new ArrayList<Port>();
        ArrayList<Property> allProperties = new ArrayList<Property>();
        ArrayList<Association> allAssociations = new ArrayList<Association>();
        ArrayList<Connector> allConnectors = new ArrayList<Connector>();
        ArrayList<Constraint> allFormalProps = new ArrayList<Constraint>();
        ArrayList<Property> allContractProperties = new ArrayList<Property>();
        ArrayList<Parameter> allParameters = new ArrayList<Parameter>();
        for (Element elem : sysView.allOwnedElements()) {
            if (elem.getAppliedStereotype(BLOCK) != null || elem.getAppliedStereotype(SUBSYSTEM) != null || elem.getAppliedStereotype(SYSTEM) != null) {
                allBlocks.add((Class)elem);
            }
            if (elem instanceof Property) {
                if (elem.getAppliedStereotype(FLOWPORT) != null || elem.getAppliedStereotype(FLOWPORTMARTE) != null) {
                    allFlowPorts.add((Port)elem);
                } else if (elem.getAppliedStereotype(CONTRACTPROP) != null) {
                    allContractProperties.add((Property)elem);
                } else if (!(elem instanceof Port)) {
                    allProperties.add((Property)elem);
                }
            }
            if (elem instanceof Association) {
                allAssociations.add((Association)elem);
            }
            if (elem instanceof Connector) {
                allConnectors.add((Connector)elem);
            }
            if (elem instanceof Constraint && elem.getAppliedStereotype(FORMPROP) != null) {
                allFormalProps.add((Constraint)elem);
            }
            if (!(elem instanceof Parameter) || ((Parameter)elem).getOperation() == null) continue;
            allParameters.add((Parameter)elem);
        }
        for (Element elem : compView.allOwnedElements()) {
            if (elem instanceof Constraint && elem.getAppliedStereotype(FORMPROP) != null) {
                allFormalProps.add((Constraint)elem);
            }
            if (elem instanceof Property) {
                if (elem.getAppliedStereotype(CONTRACTPROP) != null) {
                    allContractProperties.add((Property)elem);
                } else if (!(elem instanceof Port) && !(elem.getOwner() instanceof DataType)) {
                    allProperties.add((Property)elem);
                }
            }
            if (!(elem instanceof Parameter) || ((Parameter)elem).getOperation() == null) continue;
            allParameters.add((Parameter)elem);
        }
        allResults.addAll(this.checkConstraintForeverAnalysis(sysView, allBlocks, allFlowPorts, allProperties, allAssociations, allConnectors, allFormalProps, allContractProperties, allParameters, ctx));
        if (allResults.size() > 0) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, allResults);
        }
        return success;
    }

    private Collection<? extends ConstraintStatus> checkConstraintForeverAnalysis(Package sysView, List<Class> allBlocks, List<Port> allFlowPorts, List<Property> allProperties, List<Association> allAssociations, List<Connector> allConnectors, List<Constraint> allFormalProps, List<Property> allContractProperties, List<Parameter> allParameters, IValidationContext ctx) {
        String errorMsg;
        ArrayList<ConstraintStatus> results = new ArrayList<ConstraintStatus>();
        for (Class block : allBlocks) {
            if (!this.checkName((NamedElement)block)) {
                errorMsg = "The Block named " + block.getName() + " contains unallowed character(s)";
                results.add(this.createConstraintStatus((EObject)block, errorMsg, ctx));
            }
            if (!this.hasAmbiguousAttributes(block)) continue;
            errorMsg = "There are 2 or more attributes with the same name in Block: " + block.getName();
            results.add(this.createConstraintStatus((EObject)block, errorMsg, ctx));
        }
        for (Port flowport : allFlowPorts) {
            if (flowport.getType() == null) {
                errorMsg = "The FlowPort " + flowport.getName() + " should be typed";
                results.add(this.createConstraintStatus((EObject)flowport, errorMsg, ctx));
            }
            if (!this.checkName((NamedElement)flowport)) {
                errorMsg = "The FlowPort named " + flowport.getName() + " contains unallowed character(s)";
                results.add(this.createConstraintStatus((EObject)flowport, errorMsg, ctx));
            }
            if (this.hasValidType((TypedElement)flowport)) continue;
            errorMsg = "The property named " + flowport.getName() + " refer to an unallowed type";
            results.add(this.createConstraintStatus((EObject)flowport, errorMsg, ctx));
        }
        for (Property prop : allProperties) {
            if (!this.checkName((NamedElement)prop)) {
                errorMsg = "The property named " + prop.getName() + " in block " + ((NamedElement)prop.getOwner()).getName() + " contains unallowed character(s)";
                results.add(this.createConstraintStatus((EObject)prop, errorMsg, ctx));
            }
            if (prop.getType().getAppliedStereotype(BLOCK) != null || prop.getType() instanceof Component || this.hasValidType((TypedElement)prop)) continue;
            errorMsg = "The property named " + prop.getName() + " in entity " + ((NamedElement)prop.getOwner()).getName() + " refer to an unallowed type";
            results.add(this.createConstraintStatus((EObject)prop, errorMsg, ctx));
        }
        for (Property contrProp : allContractProperties) {
            if (this.checkContractPropertyRefinement(contrProp)) continue;
            errorMsg = "Contract Refinement for " + contrProp.getName() + " is not correct (check weak guarantees)";
            results.add(this.createConstraintStatus((EObject)contrProp, errorMsg, ctx));
        }
        for (Association assoc : allAssociations) {
            if (assoc.getOwnedEnds().size() == 1) continue;
            errorMsg = "The association between " + ((Property)assoc.getMemberEnds().get(0)).getName() + " and " + ((Property)assoc.getMemberEnds().get(1)).getName() + " is not directed";
            results.add(this.createConstraintStatus((EObject)assoc, errorMsg, ctx));
        }
        for (Parameter param : allParameters) {
            if (this.hasValidType((TypedElement)param)) continue;
            errorMsg = "The Parameter named " + param.getName() + " in entity " + ((NamedElement)param.getOwner()).getName() + " refer to an unallowed type";
            results.add(this.createConstraintStatus((EObject)param, errorMsg, ctx));
        }
        for (Connector conn : allConnectors) {
            Property prSec;
            Port secondPort;
            Stereotype secondStereo;
            ConnectorEnd firstEnd = (ConnectorEnd)conn.getEnds().get(0);
            ConnectorEnd secondEnd = (ConnectorEnd)conn.getEnds().get(1);
            if (!(firstEnd.getRole() instanceof Port) || !(secondEnd.getRole() instanceof Port)) continue;
            Port firstPort = (Port)firstEnd.getRole();
            Stereotype firstStereo = firstPort.getAppliedStereotype(FLOWPORT);
            if (firstStereo == null) {
                firstStereo = firstPort.getAppliedStereotype(FLOWPORTMARTE);
            }
            if ((secondStereo = (secondPort = (Port)secondEnd.getRole()).getAppliedStereotype(FLOWPORT)) == null) {
                secondStereo = firstPort.getAppliedStereotype(FLOWPORTMARTE);
            }
            if (firstPort.getType() != null && secondPort.getType() != null && !firstPort.getType().getName().equals(secondPort.getType().getName())) {
                errorMsg = "This connector must connect ports of the same type";
                results.add(this.createConstraintStatus((EObject)conn, errorMsg, ctx));
            }
            if (firstStereo == null || secondStereo == null) continue;
            String firstDir = firstPort.getValue(firstStereo, "direction").toString();
            String secondDir = secondPort.getValue(secondStereo, "direction").toString();
            Property prFirst = firstEnd.getPartWithPort();
            if (prFirst == null ^ (prSec = secondEnd.getPartWithPort()) == null) {
                if (firstDir.equals(secondDir)) continue;
                errorMsg = "Connector " + conn.getQualifiedName() + " is delegating ports with incompatible direction";
                results.add(this.createConstraintStatus((EObject)conn, errorMsg, ctx));
                continue;
            }
            if (!firstDir.equals(secondDir)) continue;
            errorMsg = "Connector " + conn.getQualifiedName() + " is connecting ports with incompatible direction";
            results.add(this.createConstraintStatus((EObject)conn, errorMsg, ctx));
        }
        ToolIntegration checker = new ToolIntegration(null);
        for (Constraint formalProp : allFormalProps) {
            if (checker.checkFormalProperty(formalProp)) continue;
            errorMsg = "The formal property " + formalProp.getName() + " is not correct. Please check its syntax";
            results.add(this.createConstraintStatus((EObject)formalProp, errorMsg, ctx));
        }
        return results;
    }

    private boolean checkContractPropertyRefinement(Property prop) {
        ContractProperty contrProp = (ContractProperty)prop.getStereotypeApplication(prop.getAppliedStereotype(CONTRACTPROP));
        EList contrRefList = contrProp.getRefinedBy();
        if (contrRefList.size() == 0) {
            return true;
        }
        for (ContractRefinement contrRef : contrRefList) {
            ComponentInstance compInst;
            Property p;
            Stereotype stereo;
            ContractProperty cp = contrRef.getContract();
            ContractTypes ctype = cp.getContractType();
            if (ctype != ContractTypes.WEAK || (stereo = (p = contrRef.getInstance()).getAppliedStereotype(COMPINST)) == null || (compInst = (ComponentInstance)p.getStereotypeApplication(stereo)).getWeakGuarantees().contains((Object)cp)) continue;
            return false;
        }
        return true;
    }

    private boolean hasAmbiguousAttributes(Class block) {
        EList attributes = block.getAllAttributes();
        HashSet<String> names = new HashSet<String>();
        for (Property prop : attributes) {
            names.add(prop.getName());
        }
        return names.size() != attributes.size();
    }

    private boolean checkName(NamedElement elem) {
        return !elem.getName().contains(" ");
    }

    private boolean hasValidType(TypedElement typed) {
        BoundedSubtype subtype;
        Type type = typed.getType();
        if (type == null) {
            return false;
        }
        String typeName = type.getName();
        if (typeName.compareToIgnoreCase("integer") == 0 || typeName.compareToIgnoreCase("boolean") == 0 || typeName.compareTo("real") == 0 || typeName.compareToIgnoreCase("continuous") == 0 || typeName.compareTo("event") == 0) {
            return true;
        }
        if (type instanceof Signal) {
            return true;
        }
        if (type instanceof Enumeration) {
            return true;
        }
        Stereotype boundedste = type.getAppliedStereotype(BOUNDEDSUBTYPE);
        if (boundedste != null && (subtype = (BoundedSubtype)type.getStereotypeApplication(boundedste)).getBaseType().getName().compareToIgnoreCase("integer") == 0) {
            return true;
        }
        Stereotype collectiontypeStereo = type.getAppliedStereotype(COLLECTIONTYPE);
        if (collectiontypeStereo != null) {
            CollectionType collType = (CollectionType)type.getStereotypeApplication(collectiontypeStereo);
            Property collProp = collType.getCollectionAttrib();
            if (collProp == null) {
                return false;
            }
            return this.hasValidType((TypedElement)collProp);
        }
        return false;
    }

    private ConstraintStatus createConstraintStatus(EObject object, String errorMsg, IValidationContext ctx) {
        ArrayList<EObject> resultLocus = new ArrayList<EObject>();
        resultLocus.add(object);
        return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)object, resultLocus, (int)4, (int)3, (String)errorMsg, null);
    }
}

