/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaResourcesPlatform;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaAnalysisContext;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.m2m.transformations.PIMPSMTransformationVERDE;
import org.polarsys.chess.m2m.transformations.TransUtil;
import org.polarsys.chess.m2m.transformations.TransformationResultsData;
import org.polarsys.chess.m2m.ui.AnalysisContextSelectionDialog;
import org.polarsys.chess.m2m.ui.SchedResultDialog;
import org.polarsys.chess.service.utils.CHESSEditorUtils;
import org.polarsys.chess.validator.command.ChessGenericValidateCommand;

public class QVToUIHandlerVERDE
extends AbstractHandler {
    private Shell activeShell = null;
    private Resource inResource = null;
    private String saAnalysisName;
    private String psmPackageName;

    private IProject getActiveProject(IEditorPart editor) {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IFile file = input.getFile();
        return file.getProject();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!CHESSEditorUtils.isCHESSProject((IEditorPart)editor)) {
            return null;
        }
        try {
            this.inResource = ResourceUtils.getUMLResource((ServicesRegistry)((PapyrusMultiDiagramEditor)editor).getServicesRegistry());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.activeShell, (String)"CHESS", (String)"Unable to load the model");
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.activeShell = window.getShell();
        String label = "Validate model for CHESS Core Constraints";
        Model model = (Model)this.inResource.getContents().get(0);
        ChessGenericValidateCommand chessValidateCommand = new ChessGenericValidateCommand(label, "org.polarsys.chess.validator", (EObject)model);
        boolean go = false;
        if (chessValidateCommand != null) {
            try {
                chessValidateCommand.executeCommand(null, null);
            }
            catch (ExecutionException executionException) {
                return null;
            }
            if (chessValidateCommand.getMarkers()) {
                Diagnostic diagnostic = chessValidateCommand.getDiagnostic();
                List diagList = diagnostic.getChildren();
                Boolean validationErrors = false;
                for (Iterator theDiag : diagList) {
                    if (!theDiag.getSource().equals("org.polarsys.chess.validator") || theDiag.getSeverity() <= 2) continue;
                    validationErrors = true;
                    break;
                }
                if (validationErrors.booleanValue() && !(go = MessageDialog.openQuestion((Shell)this.activeShell, (String)"Validation Problems", (String)"Errors found while validating the Model. Schedulability Analysis won't be performed correctly. Do you still want to continue?"))) {
                    return null;
                }
            }
        } else {
            MessageDialog.openError((Shell)this.activeShell, (String)"Schedulability Analysis", (String)"Problems while perfoming model validation before analysis");
        }
        ArrayList<Class> selection = new ArrayList<Class>();
        EList elemList = model.allOwnedElements();
        for (Element elem : elemList) {
            SaAnalysisContext saAnalysisCtx;
            if (!(elem instanceof Class) || elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null || ViewUtils.isPSMView((Package)ViewUtils.getView((EObject)elem)) || (saAnalysisCtx = (SaAnalysisContext)elem.getStereotypeApplication(elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext"))).getWorkload().size() != 0) continue;
            selection.add((Class)elem);
        }
        if (selection.size() == 0) {
            MessageDialog.openWarning((Shell)this.activeShell, (String)"CHESS", (String)"no suitable analysis contexts in the model");
            return null;
        }
        final ArrayList<CH_HwProcessor> chHwProcList = new ArrayList<CH_HwProcessor>();
        String contextQN = null;
        AnalysisContextSelectionDialog dialog = new AnalysisContextSelectionDialog(this.activeShell, selection, "Select Schedulability Context to analyze");
        if (dialog.open() != 0) {
            return null;
        }
        contextQN = dialog.getContext();
        if (contextQN == null || contextQN.isEmpty()) {
            return null;
        }
        Class contextClassTmp = null;
        for (Element elem : model.allOwnedElements()) {
            Stereotype saAnalysisContextStereo = elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext");
            if (saAnalysisContextStereo == null || !((NamedElement)elem).getQualifiedName().equals(contextQN)) continue;
            contextClassTmp = (Class)elem;
            SaAnalysisContext saAnalysisContext = (SaAnalysisContext)elem.getStereotypeApplication(saAnalysisContextStereo);
            List<CH_HwProcessor> tmpList = QVToUIHandlerVERDE.getPlatformChHwProcessors(saAnalysisContext, model);
            chHwProcList.addAll(tmpList);
            if (chHwProcList.isEmpty() || !UMLUtils.checkPlatformsInContext((SaAnalysisContext)saAnalysisContext, (Model)model)) {
                MessageDialog.openWarning((Shell)this.activeShell, (String)"CHESS", (String)"Context must specify a SW and a HW instance platform!");
                return null;
            }
            try {
                if (UMLUtils.checkAllocationToCores(chHwProcList, (Model)model)) continue;
                MessageDialog.openWarning((Shell)this.activeShell, (String)"CHESS", (String)"No partition or task allocated to Core!");
                return null;
            }
            catch (ModelError e) {
                e.printStackTrace();
            }
        }
        final Class contextClass = contextClassTmp;
        this.saAnalysisName = contextClass.getQualifiedName();
        this.psmPackageName = String.valueOf(contextClass.getName()) + "_PSM";
        Job job = new Job("Transforming"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TransformationResultsData result = null;
                    try {
                        result = QVToUIHandlerVERDE.this.executeTimingAnalysis(editor, monitor);
                        CHESSEditorUtils.reopenEditor((IEditorPart)editor, (Boolean)false);
                    }
                    finally {
                        QVToUIHandlerVERDE.this.getActiveProject(editor).refreshLocal(2, monitor);
                    }
                    try {
                        ModelContent inModel = TransUtil.loadModel(result.umlFile);
                        Model model = (Model)inModel.getContent().get(0);
                        QVToUIHandlerVERDE.this.openSchedAnalysisReport(model, result.res, chHwProcList, contextClass);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("Unable to load the model and so open the schedAnalysisReport");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new Status(4, "org.polarsys.chess.m2m", 1, "Error in transformation " + e.getMessage(), null);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job completed successfully");
                } else {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job did not complete successfully");
                }
            }
        });
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    public static List<CH_HwProcessor> getPlatformChHwProcessors(SaAnalysisContext saAnalysisContext, Model model) {
        CH_HwProcessor chHwProcessor = null;
        ArrayList<CH_HwProcessor> chHwProcessorList = new ArrayList<CH_HwProcessor>();
        EList platformList = saAnalysisContext.getPlatform();
        for (GaResourcesPlatform theGaResPlatform : platformList) {
            if (!(theGaResPlatform instanceof CHGaResourcePlatform)) continue;
            CHGaResourcePlatform chGaResPlat = (CHGaResourcePlatform)theGaResPlatform;
            Package thePackage = ViewUtils.getView((EObject)chGaResPlat.getBase_Package());
            if (ViewUtils.getCHESSDeploymentPackage((Model)model) != thePackage) continue;
            EList allElems = chGaResPlat.getBase_Package().allOwnedElements();
            for (Element theElement : allElems) {
                InstanceSpecification e;
                if (!(theElement instanceof InstanceSpecification) || (e = (InstanceSpecification)theElement).getQualifiedName() == null || !UMLUtils.isProcessorInstance((InstanceSpecification)e)) continue;
                chHwProcessor = (CH_HwProcessor)UMLUtils.getStereotypeApplication((Element)e, CH_HwProcessor.class);
                chHwProcessorList.add(chHwProcessor);
            }
        }
        return chHwProcessorList;
    }

    public TransformationResultsData executeTimingAnalysis(IEditorPart editor, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Transforming", 4);
        IFile inputFile = CHESSProjectSupport.resourceToFile((Resource)this.inResource);
        PIMPSMTransformationVERDE t = new PIMPSMTransformationVERDE();
        HashMap<String, String> configProps = new HashMap<String, String>();
        configProps.put("saAnalysis", this.saAnalysisName);
        configProps.put("analysisType", "Schedulability");
        t.setConfigProperty(configProps);
        t.setPsmPackageName(this.psmPackageName);
        TransformationResultsData result = t.performTimingAnalysisWithMAST((PapyrusMultiDiagramEditor)editor, inputFile, monitor);
        return result;
    }

    public void openSchedAnalysisReport(Model model, final String result, List<CH_HwProcessor> cpus, Class saAnalysisContextClass) {
        if (result == null) {
            return;
        }
        if (saAnalysisContextClass == null) {
            return;
        }
        if (saAnalysisContextClass.eIsProxy()) {
            saAnalysisContextClass = (Class)EcoreUtil.resolve((EObject)saAnalysisContextClass, (EObject)model);
        }
        final List hwResults = UMLUtils.getHWAnalysisResults((Class)saAnalysisContextClass);
        final List analysisResData = UMLUtils.getAnalysisResults((Class)saAnalysisContextClass);
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                SchedResultDialog dialog = new SchedResultDialog(shell, result, analysisResData, hwResults);
                if (dialog.open() == 0) {
                    System.out.println("OK");
                }
            }
        });
    }
}

