/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.multicore.model.CHCore;
import org.polarsys.chess.multicore.utils.QueryUtils;

public class CoreSelectorDialog
extends TrayDialog
implements SelectionListener,
ISelectionChangedListener,
IDoubleClickListener,
IElementSelectionListener {
    public static final int PARTITIONS_TO_CORES = 0;
    public static final int COMPONENTS_TO_CORES = 1;
    public static final int TASKS_TO_CORES = 2;
    private EList<CHCore> cores;
    Map<CHCore, LinkedHashSet<Object>> map;
    private Composite selectorSection;
    private Composite buttonsSection;
    private Button add;
    private Button remove;
    private Button addAll;
    private Button removeAll;
    private Tree selectedElements;
    private ILabelProvider labelProvider;
    private ReferenceSelector selector;
    private CHCore partitionSelected;
    private HashMap<CHCore, TreeViewer> selectedElementsViewers;
    private Map<CHCore, LinkedHashSet<Object>> result;

    public CoreSelectorDialog(Shell parentShell, ReferenceSelector referenceSelector, EList<CHCore> cores, Package pack, EList<Assign> assignments, int mode, String title) {
        super(parentShell);
        this.cores = cores;
        this.selector = referenceSelector;
        this.map = new HashMap<CHCore, LinkedHashSet<Object>>();
        if (mode == 0) {
            for (CHCore core : cores) {
                LinkedHashSet<Object> theCoresPartitions = QueryUtils.getPartitionsAssigned2Core(core, assignments);
                this.map.put(core, theCoresPartitions);
            }
        }
        if (mode == 1) {
            for (CHCore core : cores) {
                LinkedHashSet<Object> theCoresComponents = QueryUtils.getComponentsAssigned2Core(core, assignments);
                this.map.put(core, theCoresComponents);
            }
        }
        if (mode == 2) {
            for (CHCore core : cores) {
                LinkedHashSet<Object> theCoresTasks = QueryUtils.getTasksAssigned2Core(core, pack, assignments);
                this.map.put(core, theCoresTasks);
            }
        }
        this.selector.addElementSelectionListener((IElementSelectionListener)this);
        this.selectedElementsViewers = new HashMap();
        this.setTitle(title);
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        Composite selectorPane = new Composite(parent, 0);
        selectorPane.setLayout((Layout)new GridLayout(1, false));
        selectorPane.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite sc2 = new ScrolledComposite(parent, 2560);
        sc2.setLayoutData((Object)new GridData(4, 4, true, true));
        sc2.setExpandHorizontal(true);
        sc2.setExpandVertical(true);
        Composite selectedPane = new Composite((Composite)sc2, 0);
        selectedPane.setLayout((Layout)new GridLayout(1, false));
        selectedPane.setLayoutData((Object)new GridData(131072, 4, true, true));
        for (CHCore object : this.cores) {
            Composite selectedPane_ = new Composite(selectedPane, 0);
            selectedPane_.setLayout((Layout)new GridLayout(2, false));
            selectedPane_.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createListSection(object, selectedPane_);
        }
        sc2.setContent((Control)selectedPane);
        sc2.setMinSize(sc2.computeSize(-1, -1));
        sc2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                sc2.setMinSize(sc2.computeSize(-1, -1));
            }
        });
        this.createSelectorSection(selectorPane);
        return super.createDialogArea(parent);
    }

    private void createSelectorSection(Composite parent) {
        this.selectorSection = new Composite(parent, 0);
        this.selectorSection.setLayout((Layout)new FillLayout());
        this.selectorSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selector.createControls(this.selectorSection);
    }

    private void createControlsSection(CHCore partition, Composite parent) {
        this.buttonsSection = new Composite(parent, 0);
        this.buttonsSection.setLayout((Layout)new GridLayout(1, true));
        this.add = new Button(this.buttonsSection, 8);
        this.add.setImage(Activator.getDefault().getImage("/icons/arrow_right.gif"));
        this.add.addSelectionListener((SelectionListener)this);
        this.add.setToolTipText(Messages.MultipleValueSelectorDialog_AddSelectedElements);
        this.add.setData((Object)new WidgetData(1, partition));
        this.remove = new Button(this.buttonsSection, 8);
        this.remove.setImage(Activator.getDefault().getImage("/icons/arrow_left.gif"));
        this.remove.addSelectionListener((SelectionListener)this);
        this.remove.setToolTipText(Messages.MultipleValueEditor_RemoveSelectedElements);
        this.remove.setData((Object)new WidgetData(2, partition));
        this.addAll = new Button(this.buttonsSection, 8);
        this.addAll.setImage(Activator.getDefault().getImage("/icons/arrow_double.gif"));
        this.addAll.addSelectionListener((SelectionListener)this);
        this.addAll.setToolTipText(Messages.MultipleValueSelectorDialog_AddAllElements);
        this.addAll.setData((Object)new WidgetData(4, partition));
        this.removeAll = new Button(this.buttonsSection, 8);
        this.removeAll.setImage(Activator.getDefault().getImage("/icons/arrow_left_double.gif"));
        this.removeAll.addSelectionListener((SelectionListener)this);
        this.removeAll.setToolTipText(Messages.MultipleValueSelectorDialog_RemoveAllElements);
        this.removeAll.setData((Object)new WidgetData(3, partition));
    }

    private String getInstanceSpecificationName(CHCore instanceSpecification) {
        return instanceSpecification.toString();
    }

    private void createListSection(CHCore core, Composite parent) {
        Label lbl = new Label(parent, 0);
        lbl.setText(this.getInstanceSpecificationName(core));
        GridData lLbl = new GridData(0x1000000, 128, true, true, 2, 1);
        lbl.setLayoutData((Object)lLbl);
        this.createControlsSection(core, parent);
        this.selectedElements = new Tree(parent, 2818);
        GridData data = new GridData(4, 4, true, true);
        this.selectedElements.setLayoutData((Object)data);
        TreeViewer selectedElementsViewer = new TreeViewer(this.selectedElements);
        selectedElementsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        selectedElementsViewer.addDoubleClickListener((IDoubleClickListener)this);
        selectedElementsViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        if (this.labelProvider != null) {
            selectedElementsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        selectedElementsViewer.setInput(this.map.get(core));
        this.selectedElementsViewers.put(core, selectedElementsViewer);
    }

    public void widgetSelected(SelectionEvent e) {
        Object data = e.widget.getData();
        if (data != null && data instanceof WidgetData) {
            WidgetData wData = (WidgetData)data;
            if (wData.type == 1) {
                this.addAction(wData.partition);
            } else if (wData.type == 2) {
                this.removeAction(wData.partition);
            } else if (wData.type == 4) {
                this.addAllAction(wData.partition);
            } else if (wData.type == 3) {
                this.removeAllAction(wData.partition);
            }
        }
    }

    private void removeAllAction(CHCore partition) {
        TreeViewer selectedElementsViewer = this.selectedElementsViewers.get(partition);
        LinkedHashSet<Object> el = new LinkedHashSet<Object>();
        for (LinkedHashSet<Object> values : this.map.values()) {
            el.addAll(values);
        }
        LinkedHashSet<Object> el1 = this.map.get(partition);
        Object[] objectArray = el1.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            el.remove(element);
            el1.remove(element);
            ++n2;
        }
        this.selector.setSelectedElements(el.toArray());
        selectedElementsViewer.setSelection(null);
        selectedElementsViewer.refresh();
    }

    private void addAllAction(CHCore partition) {
        Object[] elements = this.selector.getAllElements();
        this.partitionSelected = partition;
        this.addElements(elements);
    }

    private void removeAction(CHCore partition) {
        TreeViewer selectedElementsViewer = this.selectedElementsViewers.get(partition);
        LinkedHashSet<Object> el = new LinkedHashSet<Object>();
        for (LinkedHashSet<Object> values : this.map.values()) {
            el.addAll(values);
        }
        IStructuredSelection selection = (IStructuredSelection)selectedElementsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        LinkedHashSet<Object> el1 = this.map.get(partition);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            el.remove(element);
            el1.remove(element);
            ++n2;
        }
        this.selector.setSelectedElements(el.toArray());
        selectedElementsViewer.setSelection(null);
        selectedElementsViewer.refresh();
    }

    private void addAction(CHCore partition) {
        Object[] elements = this.selector.getSelectedElements();
        this.partitionSelected = partition;
        this.addElements(elements);
    }

    private InstanceSpecification[] getSelectedElements() {
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void doubleClick(DoubleClickEvent event) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void setLabelProvider(ILabelProvider serv) {
        this.labelProvider = serv;
    }

    public void setMessage(String string) {
    }

    public void setTitle(String string) {
    }

    public void addElements(Object[] elements) {
        if (elements != null && this.partitionSelected != null) {
            new ArrayList();
            LinkedHashSet<Object> l = this.map.get(this.partitionSelected);
            l.addAll(Arrays.asList(elements));
            TreeViewer selectedElementsViewer = this.selectedElementsViewers.get(this.partitionSelected);
            selectedElementsViewer.refresh();
        }
    }

    protected void okPressed() {
        this.setResult(this.map);
        super.okPressed();
    }

    protected void setResult(Map<CHCore, LinkedHashSet<Object>> map_) {
        this.result = map_;
    }

    public Map<CHCore, LinkedHashSet<Object>> getResult() {
        return this.result;
    }

    class WidgetData {
        int type;
        CHCore partition;
        static final int ADD = 1;
        static final int REMOVE = 2;
        static final int RALL = 3;
        static final int AALL = 4;

        public WidgetData(int type, CHCore partition) {
            this.partition = partition;
            this.type = type;
        }
    }
}

