/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.partitioning;

import org.polarsys.chess.multicore.partitioning.Bin;

public class Task
implements Comparable<Task> {
    private String id;
    private Definition definition;
    private Float c;
    private Float d;
    private Float t;
    private Float u;
    private Float offset;
    private Bin owner;

    public Task(String _name, Float _c, Float _d, Float _t, Float _offset, Bin _owner) {
        this.id = _name;
        this.c = _c;
        this.d = _d;
        this.t = _t;
        this.definition = Definition.DEFINED_C_AND_T;
        this.offset = _offset;
        this.owner = _owner;
    }

    public Task(String _name, Float _u) {
        this.id = _name;
        this.u = _u;
        this.definition = Definition.DEFINED_U;
    }

    public void setOwner(Bin owner) {
        this.owner = owner;
    }

    public void setT(Float t) {
        this.t = t;
    }

    public Bin getOwner() {
        return this.owner;
    }

    public Float getT() {
        return this.t;
    }

    public String toString() {
        return new String("(name, C, D, T, offset, owner)\n(" + this.id + ", " + this.c + ", " + this.d + ", " + this.t + ", " + this.offset + ", " + this.owner + ")");
    }

    public Float getU() {
        if (this.definition == Definition.DEFINED_U) {
            return this.u;
        }
        return Float.valueOf(this.c.floatValue() / this.t.floatValue());
    }

    public String getId() {
        return this.id;
    }

    public void switchToDual() {
        if (this.definition == Definition.DEFINED_U) {
            this.u = Float.valueOf(1.0f - this.u.floatValue());
        } else {
            this.c = Float.valueOf(this.t.floatValue() - this.c.floatValue());
        }
    }

    @Override
    public int compareTo(Task o) {
        return this.getU().compareTo(o.getU());
    }

    private static enum Definition {
        DEFINED_C_AND_T,
        DEFINED_U;

    }
}

