/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.statebased;

import java.io.Serializable;
import java.util.Formatter;

public class DEEMProgressInformation
implements Serializable {
    private int iCurrent;
    private int iMin;
    private int iMax;

    public int getCurrent() {
        return this.iCurrent;
    }

    public int getMinimum() {
        return this.iMin;
    }

    public int getMaximum() {
        return this.iMax;
    }

    public int getMissing() {
        if (this.iMin - this.iCurrent > 0) {
            return this.iMin - this.iCurrent;
        }
        return 0;
    }

    public boolean minimumReached() {
        return this.getMissing() == 0;
    }

    public float getPercentToMax() {
        return (float)this.iCurrent / (float)this.iMax * 100.0f;
    }

    public String getPercentToMax(String format) {
        Formatter f = new Formatter();
        return f.format(format, Float.valueOf((float)this.iCurrent / (float)this.iMax * 100.0f)).toString();
    }

    public float getPercentToMin() {
        return (float)this.iCurrent / (float)this.iMin * 100.0f;
    }

    public String getPercentToMin(String format) {
        Formatter f = new Formatter();
        return f.format(format, Float.valueOf((float)this.iCurrent / (float)this.iMin * 100.0f)).toString();
    }

    public void setStatus(int min, int max, int current) {
        this.iMin = min;
        this.iMax = max;
        this.iCurrent = current;
    }

    public void setStatus(int current) {
        this.setStatus(this.getMinimum(), this.getMaximum(), current);
    }

    public String toString() {
        String s = String.valueOf(this.getCurrent()) + " of " + this.getMaximum() + " batches completed (";
        s = String.valueOf(s) + this.getPercentToMax("%.2f");
        s = String.valueOf(s) + "% of max";
        if (!this.minimumReached()) {
            s = String.valueOf(s) + " | " + this.getMissing() + " to min";
        }
        s = String.valueOf(s) + ")";
        return s;
    }
}

