/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.checkers.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.checkers.core.checkerManager.Checker;
import org.polarsys.chess.checkers.core.checkerManager.CheckerMessage;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;

public class IdentifiersChecker
extends Checker {
    protected Package systemViewPackage;
    private static final Logger logger = Logger.getLogger(IdentifiersChecker.class);
    private static final String checkerName = "IdentifierChecker";

    public IdentifiersChecker() {
        super(checkerName, IdentifiersChecker.getTags());
    }

    public IdentifiersChecker(int priority) {
        super(checkerName, IdentifiersChecker.getTags(), priority);
    }

    public IdentifiersChecker(Set<String> tags) {
        super(checkerName, tags);
    }

    public IdentifiersChecker(Set<String> tags, int priority) {
        super(checkerName, tags, priority);
    }

    @Override
    public List<CheckerMessage> check(IProgressMonitor monitor) throws Exception {
        ArrayList<CheckerMessage> messages = new ArrayList<CheckerMessage>();
        Collection blocks = null;
        try {
            blocks = EntityUtil.getInstance().getAllClasses(this.systemViewPackage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        monitor.beginTask(checkerName, blocks.size());
        for (Class block : blocks) {
            messages.addAll(this.processBlock(block));
            if (monitor.isCanceled()) {
                throw new Exception("Checker interrupted");
            }
            monitor.worked(1);
        }
        return messages;
    }

    protected List<CheckerMessage> processBlock(Class block) {
        EList<NamedElement> elements = this.filterElements(block);
        return this.processElements(elements);
    }

    protected List<CheckerMessage> processElements(EList<NamedElement> elements) {
        ArrayList<CheckerMessage> messages = new ArrayList<CheckerMessage>();
        for (NamedElement element : elements) {
            String name = element.getName();
            logger.debug((Object)("Processing " + name));
            if (this.isValidId(name)) continue;
            logger.debug((Object)("The element name is not a valid identifier: " + name));
            String msg = "The element name is not a valid identifier: " + name;
            messages.add(new CheckerMessage(msg, 1, element, checkerName));
        }
        return messages;
    }

    protected boolean isValidId(String id) {
        return SourceVersion.isIdentifier(id) && !SourceVersion.isKeyword(id);
    }

    protected EList<NamedElement> filterElements(Class block) {
        EList attributes = block.getOwnedAttributes();
        EList operations = block.getOwnedOperations();
        EList behaviors = block.getOwnedBehaviors();
        EList ports = block.getOwnedPorts();
        BasicEList elements = new BasicEList(attributes.size() + operations.size() + behaviors.size() + ports.size() + 1);
        elements.addAll((Collection)attributes);
        elements.addAll((Collection)operations);
        elements.addAll((Collection)behaviors);
        elements.addAll((Collection)ports);
        elements.add((Object)block);
        return elements;
    }

    private static Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.add("fast");
        tags.add("warnings");
        tags.add("sysml");
        return tags;
    }

    @Override
    public void init() throws Exception {
        this.systemViewPackage = EntityUtil.getInstance().getCurrentSystemView();
    }

    @Override
    public void initSync(Package systemViewPackage) throws Exception {
        this.systemViewPackage = systemViewPackage;
    }
}

