/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.profile.chesscontract.util;

import eu.fbk.eclipse.standardtools.utils.core.utils.EObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.BoundedSubtype;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.FlowPort;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.portandflows.FlowDirection;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BodyOwner;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.RedefinableTemplateSignature;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.VisibilityKind;
import org.polarsys.chess.chessmlprofile.AsyncCommunication.AsyncCommunication.FunctionTriggerEvent;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.chessmlprofile.StateMachines.PrioritizedTransition;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.StereotypeUtil;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.util.uml.UMLUtils;

public class EntityUtil {
    private static final Logger logger = Logger.getLogger(EntityUtil.class);
    public static final String BLOCK = "SysML::Blocks::Block";
    public static final String SYSTEM = "CHESSContract::System";
    public static final String FLOW_Port = "SysML::PortAndFlows::FlowPort";
    private static final String FLOW_Port_MARTE = "MARTE::MARTE_DesignModel::GCM::FlowPort";
    public static final String BOUNDED_TYPE = "MARTE::MARTE_Annexes::VSL::DataTypes::BoundedSubtype";
    private static final String COMP_TYPE = "CHESS::ComponentModel::ComponentType";
    private static final String COMP_IMPL = "CHESS::ComponentModel::ComponentImplementation";
    private static final String SYSTEM_VIEW = "CHESS::Core::CHESSViews::SystemView";
    private static final String ANALYSIS_VIEW = "CHESS::Core::CHESSViews::AnalysisView";
    public static final String INSTANTIATED_ARCHITECTURE_CONFIGURATION = "CHESS::ParameterizedArchitecture::InstantiatedArchitectureConfiguration";
    private static final String INTEGER_TYPE = "PrimitiveTypes::Integer";
    private static final String STRING_TYPE = "PrimitiveTypes::String";
    private static final String REAL_TYPE = "PrimitiveTypes::Real";
    private static final String BOOLEAN_TYPE = "PrimitiveTypes::Boolean";
    private static final String CHESS_CONTINUOUS_TYPE = "CHESSContract::DataTypes::Continuous";
    private static final String MARTE_IDEALCLOCK_TYPE = "MARTE_Library::TimeLibrary::IdealClock";
    private static final String MARTE_BOOLEAN_TYPE = "MARTE_Library::MARTE_PrimitivesTypes::Boolean";
    private static final String MARTE_REAL_TYPE = "MARTE_Library::MARTE_PrimitivesTypes::Real";
    private static final String MARTE_INTEGER_TYPE = "MARTE_Library::MARTE_PrimitivesTypes::Integer";
    private static final String FORMAL_PROP = "CHESSContract::FormalProperty";
    private static final String FAULTY_STATE_MACHINE = "CHESS::Dependability::ThreatsPropagation::ErrorModel";
    public static final String DELEGATION_CONST = "CHESSContract::DelegationConstraint";
    public static final String PRIORITIZED_TRANSITION = "CHESS::StateMachines::PrioritizedTransition";
    public static final String MACRO_DEFINITION = "CHESS::Expressions::MacroDefinition";
    public static final String PARAMETER_ASSUMPTIONS = "CHESS::Expressions::ParameterAssumptions";
    public static final String FUNCTION_TRIGGER_EVENT = "CHESS::AsyncCommunication::AsyncCommunication::FunctionTriggerEvent";
    private static final String DEFAULT_DELEGATION_PREFIX = "DelegConstr_";
    private static final String DEFAULT_PAR_ASSUMPTION_PREFIX = "ParamAssumption";
    private static final String DEFAULT_ASSOCIATION_NAME = "association";
    private static final String DEFAULT_ENUMERATION_NAME = "Enumeration";
    private static final String DEFAULT_SIGNAL_NAME = "Signal";
    private static final String DEFAULT_CONNECTOR_NAME = "connector";
    private static final String DEFAULT_DELEGATION_CONSTRAINT_LITERAL_STRING_NAME = "constraintSpec";
    private static final String DEFAULT_PAR_ASSUMPTION_LITERAL_STRING_NAME = "constraintSpec";
    private static final String DEFAULT_MACRO_DEFINITION_STRING_NAME = "constraintSpec";
    private static final String DEFAULT_PARAMETER_IN_NAME = "parameterIn";
    private static final String DEFAULT_PARAMETER_OUT_NAME = "parameterOut";
    private static final String DEFAULT_BOUNDEDTYPE_NAME = "BoundedInteger_";
    private static final String modelExtension = ".di";
    private Model umlLibrary = null;
    private Profile chessContractLibrary = null;
    private static EntityUtil entityUtilInstance;
    ModelExplorerView modelExplorerView;

    public static EntityUtil getInstance() {
        if (entityUtilInstance == null) {
            entityUtilInstance = new EntityUtil();
        }
        return entityUtilInstance;
    }

    public IFile getCurrentIFile() throws Exception {
        IEditorInput editorInput;
        IEditorPart editorPart;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (editorPart = page.getActiveEditor()) != null && (editorInput = editorPart.getEditorInput()) != null && editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public IEditorPart openCurrentModelIntoEditor(IFile file) throws Exception {
        IProject project = file.getProject();
        if (project == null) {
            throw new Exception("No project associated to the file " + file.getName());
        }
        IFile modelFile = null;
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource.getName().endsWith(modelExtension) && iResource.getType() == 1) {
                    modelFile = (IFile)iResource;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (modelFile == null) {
            throw new Exception("No model found in the project " + project.getName());
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            return IDE.openEditor((IWorkbenchPage)page, modelFile, (boolean)true);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public Model loadModel(String projectName, String fileName) {
        IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        logger.debug((Object)("wRoot: " + wRoot));
        IProject proj = wRoot.getProject(projectName);
        return this.loadModel(proj, fileName);
    }

    public Model loadModel(IProject proj, String fileName) {
        IFile file = proj.getFile(fileName);
        IPath loc = file.getLocation();
        logger.debug((Object)("loc: " + loc));
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(URI.createFileURI((String)loc.toString()), true);
        Model model = ResourceUtils.getModel((Resource)resource);
        return model;
    }

    public Package loadPackage(URI uri) {
        Package package_ = null;
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        catch (WrappedException we) {
            logger.error((Object)we.getMessage());
            System.exit(1);
        }
        return package_;
    }

    public Type getContinuousType() {
        Package dataTypes;
        Type type;
        if (this.chessContractLibrary == null) {
            this.chessContractLibrary = (Profile)this.loadPackage(URI.createURI((String)"pathmap://CHESSContract/CHESSContract.profile.uml"));
        }
        if ((type = (dataTypes = this.chessContractLibrary.getNestedPackage("DataTypes")).getOwnedType("Continuous")) != null) {
            logger.debug((Object)("Type '" + type.getQualifiedName() + "' found."));
            return type;
        }
        return null;
    }

    public Type getPrimitiveType(String name) {
        Type type;
        if (this.umlLibrary == null) {
            this.umlLibrary = (Model)this.loadPackage(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"));
        }
        if ((type = this.umlLibrary.getOwnedType(name)) != null) {
            logger.debug((Object)("Type '" + type.getQualifiedName() + "' found."));
            logger.debug((Object)("Type object'" + type + "' found."));
            return type;
        }
        return null;
    }

    public Constraint getExistingDelegationConstraint(EList<Constraint> delegationConstraints, String variableIdText, String constraintText, String iterConditionText) {
        String formalPropertyText = this.createDelegationConstraintText(variableIdText, constraintText, iterConditionText);
        for (Constraint delegationConstraint : delegationConstraints) {
            LiteralString specification = (LiteralString)delegationConstraint.getSpecification();
            if (!specification.getValue().equals(formalPropertyText)) continue;
            return delegationConstraint;
        }
        return null;
    }

    public Parameter getExistingFunctionBehaviorParameter(EList<Parameter> parameters, Type functionBehaviourType, boolean isInput) {
        for (Parameter parameter : parameters) {
            if (parameter.getType() != functionBehaviourType || (!isInput || parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) && (isInput || parameter.getDirection() != ParameterDirectionKind.OUT_LITERAL)) continue;
            return parameter;
        }
        return null;
    }

    public EList<DataType> getDataTypes(Class owner) {
        BasicEList contractRefinements = new BasicEList();
        for (Classifier classifier : owner.getNestedClassifiers()) {
            if (!(classifier instanceof DataType)) continue;
            contractRefinements.add((Object)((DataType)classifier));
        }
        return contractRefinements;
    }

    public Port getExistingUmlPort(String portName, EList<NamedElement> existingPorts) {
        for (Object object : existingPorts) {
            Port tmpPort = (Port)object;
            if (!tmpPort.getName().equals(portName)) continue;
            return tmpPort;
        }
        return null;
    }

    public Port getExistingUmlPort(String portName, String typeName, EList<NamedElement> existingPorts) {
        for (Object object : existingPorts) {
            Port tmpPort = (Port)object;
            if (!tmpPort.getName().equals(portName) || !tmpPort.getType().getName().equals(typeName)) continue;
            return tmpPort;
        }
        return null;
    }

    public Stereotype findStereotype(Package pkg, String stereotypeName) {
        logger.debug((Object)("findStereotype " + stereotypeName));
        try {
            if (stereotypeName.startsWith("CHESSContract")) {
                return StereotypeUtil.getCHESSContractStereotype(stereotypeName, (Element)pkg);
            }
            if (stereotypeName.startsWith("CHESS")) {
                return StereotypeUtil.getCHESSStereotype(stereotypeName, (Element)pkg);
            }
            if (stereotypeName.startsWith("SysML")) {
                return StereotypeUtil.getSysMLStereotype(stereotypeName, (Element)pkg);
            }
            if (stereotypeName.startsWith("MARTE")) {
                return StereotypeUtil.getMarteStereotype(stereotypeName, (Element)pkg);
            }
            for (Stereotype sub : UMLUtil.findSubstereotypes((Element)pkg, (String)stereotypeName)) {
                if (!sub.getQualifiedName().equals(stereotypeName)) continue;
                return sub;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void updateUmlStaticPort(Port port, String[] newMultiplicityRange) {
        String[] multiplicityRange = this.getAttributeMultiplicity((MultiplicityElement)port);
        if (!this.equalMultiplicityBoundaries(newMultiplicityRange, multiplicityRange)) {
            this.setAttributeMultiplicity((MultiplicityElement)port, newMultiplicityRange);
        }
    }

    public void updateUmlNonStaticPort(Port port, Type newType, String[] newMultiplicityRange) {
        String[] multiplicityRange;
        if (!port.getType().getName().equals(newType.getName())) {
            port.setType(newType);
        }
        if (!this.equalMultiplicityBoundaries(newMultiplicityRange, multiplicityRange = this.getAttributeMultiplicity((MultiplicityElement)port))) {
            this.setAttributeMultiplicity((MultiplicityElement)port, newMultiplicityRange);
        }
    }

    public FunctionBehavior createUmlFunctionBehaviour(Class owner, String functionBehaviourName, EList<Type> inputTypes, EList<String[]> inputMultiplicities, Type outputType, String[] outputMultiplicity) {
        FunctionBehavior functionBehavior = this.createFunctionBehavior(owner, functionBehaviourName);
        this.createUmlFunctionBehaviorParameters(functionBehavior, inputTypes, inputMultiplicities, outputType, outputMultiplicity);
        return functionBehavior;
    }

    public Parameter createUmlFunctionBehaviorParameters(FunctionBehavior owner, EList<Type> inputTypes, EList<String[]> inputMultiplicities, Type outputType, String[] outputMultiplicity) {
        int i = 0;
        while (i < inputTypes.size()) {
            Type parameterType = (Type)inputTypes.get(i);
            String[] parameterMultiplicity = (String[])inputMultiplicities.get(i);
            this.createFunctionBehaviorParameter(owner, parameterType, parameterMultiplicity, true);
            ++i;
        }
        return this.createFunctionBehaviorParameter(owner, outputType, outputMultiplicity, false);
    }

    public Constraint createDelegationConstraint(Class owner, String variableIdText, String constraintText, String iterConditionText, Stereotype delegationConstraintStereotype) {
        String delegationName = DEFAULT_DELEGATION_PREFIX + variableIdText;
        logger.debug((Object)("\n\n\n Creating delegation constraint " + delegationName + " for owner " + owner));
        logger.debug((Object)"\n\n\n");
        Constraint newUMLConstraint = owner.createOwnedRule(delegationName.toString());
        newUMLConstraint.applyStereotype(delegationConstraintStereotype);
        LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
        literalString.setName("constraintSpec");
        String formalPropertyText = this.createDelegationConstraintText(variableIdText, constraintText, iterConditionText);
        literalString.setValue(formalPropertyText);
        newUMLConstraint.setSpecification((ValueSpecification)literalString);
        logger.debug((Object)("\n\nCreated " + delegationName + " Delegation Constraint\n\n"));
        return newUMLConstraint;
    }

    public Connector createUmlConnector(Class owner, String constraintName, Property partWithPortOfConstraint, Class portOwnerOfConstraint, String variableName, Property partWithPortOfVariable, Class portOwnerOfVariable) {
        String connectorName = DEFAULT_CONNECTOR_NAME + (owner.getOwnedConnectors().size() + 1);
        logger.debug((Object)("\n\n\n Creating connector " + connectorName + " for owner " + owner));
        logger.debug((Object)"\n\n\n");
        Connector connector = this.createConnector(connectorName);
        logger.debug((Object)("Creating source end :" + constraintName));
        this.createUmlConnectorEnd(portOwnerOfConstraint, connector, constraintName, partWithPortOfConstraint);
        logger.debug((Object)("Creating source end :" + variableName));
        this.createUmlConnectorEnd(portOwnerOfVariable, connector, variableName, partWithPortOfVariable);
        this.addConnector(owner, connector);
        return connector;
    }

    public Package getSystemView(UmlModel umlModel) {
        if (umlModel == null) {
            logger.error((Object)"No Models are open");
            return null;
        }
        logger.debug((Object)("UML Model name = " + umlModel.getIdentifier()));
        TreeIterator allElements = umlModel.getResource().getAllContents();
        if (allElements != null) {
            Collection packages = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getPackage());
            for (Package p : packages) {
                if (p.getAppliedStereotype(SYSTEM_VIEW) == null) continue;
                logger.debug((Object)"Found systemView!");
                return p;
            }
        }
        logger.error((Object)"SystemView not found!");
        return null;
    }

    public Package getAnalysisView(UmlModel umlModel) {
        if (umlModel == null) {
            logger.error((Object)"No Models are open");
            return null;
        }
        logger.debug((Object)("UML Model name = " + umlModel.getIdentifier()));
        TreeIterator allElements = umlModel.getResource().getAllContents();
        if (allElements != null) {
            Collection packages = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getPackage());
            for (Package p : packages) {
                if (p.getAppliedStereotype(ANALYSIS_VIEW) == null) continue;
                logger.debug((Object)"Found analysisView!");
                return p;
            }
        }
        logger.error((Object)"AnalysisView not found!");
        return null;
    }

    public Package getCurrentSystemView() {
        return this.getSystemView(UmlUtils.getUmlModel());
    }

    public Package getCurrentAnalysisView() {
        return this.getAnalysisView(UmlUtils.getUmlModel());
    }

    public Package createPackage(Package owner, String elementName) {
        return owner.createNestedPackage(elementName);
    }

    public Comment createComment(Package owner, String content) {
        Comment comment = owner.createOwnedComment();
        comment.setBody(content);
        return comment;
    }

    public Dependency createDependency(Package owner, NamedElement supplierElement, NamedElement clientElement) {
        Dependency dependency = owner.createDependency(supplierElement);
        dependency.getClients().add((Object)clientElement);
        return dependency;
    }

    public Property createInstantiatedArchitecture(Class owner, Class instantiatedRootComponent, ArrayList<String> parameters) {
        int numInstantiatedArchitecures = this.getInstantiatedArchitecureConfigurations(owner).size();
        Property property = owner.createOwnedAttribute("InstantiateArc_" + (numInstantiatedArchitecures + 1), null);
        UMLUtils.applyStereotype((Element)property, (String)INSTANTIATED_ARCHITECTURE_CONFIGURATION);
        InstantiatedArchitectureConfiguration instantiatedArchitecture = this.getInstantiatedArchitectureConfiguration(property);
        if (instantiatedRootComponent != null) {
            instantiatedArchitecture.setInstantiatedRootComponent(instantiatedRootComponent);
        }
        instantiatedArchitecture.getParameterList().addAll(parameters);
        return property;
    }

    public InstantiatedArchitectureConfiguration getInstantiatedArchitectureConfiguration(Property umlProperty) {
        Stereotype instantiatedArchitectureStereotype = StereotypeUtil.getCHESSStereotype(INSTANTIATED_ARCHITECTURE_CONFIGURATION, (Element)umlProperty);
        return (InstantiatedArchitectureConfiguration)umlProperty.getStereotypeApplication(instantiatedArchitectureStereotype);
    }

    public String getInstantiatedArchitectureConfigurationName(InstantiatedArchitectureConfiguration instantiatedArchitecture) {
        return instantiatedArchitecture.getBase_Property().getName();
    }

    public Class createBlock(Package owner, String elementName, Stereotype blockStereotype) {
        Class umlClass = owner.createOwnedClass(elementName, false);
        umlClass.applyStereotype(blockStereotype);
        logger.debug((Object)("\n\nCreated " + elementName + " Block\n\n"));
        return umlClass;
    }

    public Class createSystemBlock(Package owner, String elementName, Stereotype blockStereotype, Stereotype sytemblockStereotype) {
        Class umlClass = this.createBlock(owner, elementName, blockStereotype);
        umlClass.applyStereotype(sytemblockStereotype);
        return umlClass;
    }

    private ConnectorEnd createUmlConnectorEnd(Class owner, Connector connector, String sourcePort, Property partWithPort) {
        Port role = owner.getOwnedPort(sourcePort, null);
        if (role != null) {
            return this.createConnectorEnd(connector, partWithPort, (ConnectableElement)role);
        }
        return null;
    }

    public Type createBoundedSubType(Package pkg, String typeName, String lowerBoundValue, String upperBoundValue, Stereotype boundedTypeStereotype) {
        Type dataType = pkg.createOwnedType(typeName, UMLPackage.Literals.DATA_TYPE);
        dataType.applyStereotype(boundedTypeStereotype);
        BoundedSubtype boundedType = (BoundedSubtype)dataType.getStereotypeApplication(boundedTypeStereotype);
        boundedType.setMinValue(lowerBoundValue);
        boundedType.setMaxValue(upperBoundValue);
        boundedType.setBaseType((DataType)this.getPrimitiveType("Integer"));
        logger.debug((Object)("Type '" + dataType.getQualifiedName() + "' created."));
        return dataType;
    }

    public Enumeration createEnumerationFromEnumType(Package owner, Set<String> enumValues) {
        String enumerationName = DEFAULT_ENUMERATION_NAME + (this.getEnumerations(owner).size() + 1);
        Enumeration enumeration = owner.createOwnedEnumeration(enumerationName);
        for (String string : enumValues) {
            enumeration.createOwnedLiteral(string);
        }
        logger.debug((Object)("Type '" + enumeration.getQualifiedName() + "' created."));
        return enumeration;
    }

    public EList<Enumeration> getEnumerations(Package pkg) {
        BasicEList enumerations = new BasicEList();
        EList types = pkg.getOwnedTypes();
        for (Type type : types) {
            if (!(type instanceof Enumeration)) continue;
            enumerations.add((Object)((Enumeration)type));
        }
        return enumerations;
    }

    public Enumeration getEnumeration(Package pkg, String enumName, boolean ignoreCase) {
        return (Enumeration)pkg.getOwnedMember(enumName, ignoreCase, UMLFactory.eINSTANCE.createEnumeration().eClass());
    }

    public EList<Enumeration> getEnumerationsInOrder(Package pkg) {
        EList<Enumeration> enumerations = this.getEnumerations(pkg);
        Collections.sort(enumerations, new Comparator<Enumeration>(){

            @Override
            public int compare(Enumeration o1, Enumeration o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return enumerations;
    }

    public Signal createSignalType(Package owner) {
        Type type = owner.createOwnedType(DEFAULT_SIGNAL_NAME, UMLPackage.Literals.SIGNAL);
        logger.debug((Object)("Type '" + type.getQualifiedName() + "' created."));
        return (Signal)type;
    }

    public Signal getExistingSignalType(Package pkg) {
        EList types = pkg.getOwnedTypes();
        for (Type type : types) {
            if (!(type instanceof Signal)) continue;
            return (Signal)type;
        }
        return null;
    }

    public Enumeration getExistingEnumerationForEnumType(Package pkg, Set<String> enumValues) {
        EList<Enumeration> enumerations = this.getEnumerations(pkg);
        if (enumerations.size() > 0) {
            for (Enumeration enumeration : enumerations) {
                if (!enumValues.equals(this.getListValuesForEnumeration(enumeration))) continue;
                return enumeration;
            }
        }
        return null;
    }

    public Type getOrCreateSignalType(Package pkg) {
        Signal type = this.getExistingSignalType(pkg);
        if (type != null) {
            logger.debug((Object)("Type '" + type.getQualifiedName() + "' found."));
            return type;
        }
        return this.createSignalType(pkg);
    }

    public Type getOrCreateEnumerationType(Set<String> enumValues, Package pkg) {
        Enumeration type = this.getExistingEnumerationForEnumType(pkg, enumValues);
        if (type != null) {
            logger.debug((Object)("Type '" + type.getQualifiedName() + "' found."));
            return type;
        }
        return this.createEnumerationFromEnumType(pkg, enumValues);
    }

    public Type getOrCreateBoundedSubType(String[] boundaries, Package pkg, Stereotype boundedTypeStereotype) {
        String lowerBound = boundaries[0];
        String upperBound = boundaries[1];
        String typeName = DEFAULT_BOUNDEDTYPE_NAME + lowerBound + "_" + upperBound;
        return this.getOrCreateBoundedSubType(typeName, pkg, lowerBound, upperBound, boundedTypeStereotype);
    }

    public Type getOrCreateBoundedSubType(String typeName, Package pkg, String lowerBoundValue, String upperBoundValue, Stereotype boundedTypeStereotype) {
        Type type = pkg.getOwnedType(typeName);
        if (type != null) {
            logger.debug((Object)("Type '" + type.getQualifiedName() + "' found."));
            return type;
        }
        return this.createBoundedSubType(pkg, typeName, lowerBoundValue, upperBoundValue, boundedTypeStereotype);
    }

    private Set<String> getListValuesForEnumeration(Enumeration enumeration) {
        TreeSet<String> enumValuesNames = new TreeSet<String>();
        for (EnumerationLiteral enumLit : enumeration.getOwnedLiterals()) {
            enumValuesNames.add(enumLit.getName());
        }
        return enumValuesNames;
    }

    public String getFormalPropertyStr(FormalProperty formalProperty, String language) {
        String str = null;
        if (formalProperty != null) {
            str = this.getConstraintBodyStr(formalProperty.getBase_Constraint(), language);
        }
        return str;
    }

    public void updateUmlAssociation(Property componentInstance, Type newType, String[] newMultiplicity) throws Exception {
        String[] componentInstanceMultiplicity;
        if (!componentInstance.getType().equals(newType)) {
            componentInstance.setType(newType);
        }
        if (!this.equalMultiplicityBoundaries(componentInstanceMultiplicity = this.getComponentInstanceMultiplicity(componentInstance), newMultiplicity)) {
            this.setAttributeMultiplicity((MultiplicityElement)componentInstance, newMultiplicity);
        }
    }

    public void updateUmlConstraint(Constraint umlConstraint, String updatedText, String language) {
        String formalPropertyText = this.getConstraintBodyStr(umlConstraint, language);
        if (!updatedText.equals(formalPropertyText)) {
            this.setTextInUMLConstraint(umlConstraint, updatedText, language);
        }
    }

    public String getValueSpecificationValue(ValueSpecification valueSpecification, String language) {
        String res = this.getValueSpecificationValue(valueSpecification);
        if (res == null && valueSpecification instanceof OpaqueExpression) {
            res = this.getBodyForLanguageOfBodyOwner((BodyOwner)((OpaqueExpression)valueSpecification), language);
        }
        return res;
    }

    public String getConstraintBodyStr(Constraint formalProperty, String language) {
        String str = null;
        if (formalProperty != null && formalProperty.getSpecification() != null) {
            if (formalProperty.getSpecification() instanceof LiteralString) {
                str = formalProperty.getSpecification().stringValue();
            } else if (formalProperty.getSpecification() instanceof OpaqueExpression) {
                str = this.getBodyForLanguageOfBodyOwner((BodyOwner)((OpaqueExpression)formalProperty.getSpecification()), language);
            }
        }
        return str;
    }

    public String getStateInvariantBodyStr(State state, String language) {
        String str = null;
        Constraint constraint = state.getStateInvariant();
        if (constraint != null && constraint.getSpecification() != null) {
            if (constraint.getSpecification() instanceof LiteralString) {
                str = constraint.getSpecification().stringValue();
            } else if (constraint.getSpecification() instanceof OpaqueExpression) {
                str = this.getBodyForLanguageOfBodyOwner((BodyOwner)((OpaqueExpression)constraint.getSpecification()), language);
            }
        }
        return str;
    }

    public Property getSubComponentInstance(Class owner, String componentName) {
        for (Property umlProperty : owner.getAttributes()) {
            if (!umlProperty.getName().equals(componentName) || !this.isComponentInstance((Element)umlProperty)) continue;
            return umlProperty;
        }
        return null;
    }

    public String getSystemElementURIFragment(Model model) throws Exception {
        TreeIterator allElements;
        if (model != null && (allElements = model.eResource().getAllContents()) != null) {
            Collection classes = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getClass_());
            for (Class c : classes) {
                if (!this.isSystem((Element)c)) continue;
                return c.eResource().getURIFragment((EObject)c);
            }
        }
        throw new Exception("Element does not exist.");
    }

    public String getSystemViewPackageURIFragment(Model model) throws Exception {
        Package p = this.getSystemViewPackage(model);
        return p.eResource().getURIFragment((EObject)p);
    }

    public Package getSystemViewPackage(Model model) throws Exception {
        TreeIterator allElements;
        if (model != null && (allElements = model.eResource().getAllContents()) != null) {
            Collection packages = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getPackage());
            for (Package p : packages) {
                if (!this.isSystemViewPackage((Element)p)) continue;
                return p;
            }
        }
        throw new Exception("Element does not exist.");
    }

    public Package getAnalysisViewPackage(Model model) throws Exception {
        TreeIterator allElements;
        if (model != null && (allElements = model.eResource().getAllContents()) != null) {
            Collection packages = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getPackage());
            for (Package p : packages) {
                if (!this.isAnalysisView((Element)p)) continue;
                return p;
            }
        }
        throw new Exception("Element does not exist.");
    }

    public EObject getElement(String projectName, String umlFileModelName, String elementID) throws Exception {
        Model model = this.loadModel(projectName, umlFileModelName);
        return this.getElement(model, elementID);
    }

    public EObject getElement(Model model, String elementURI) throws Exception {
        if (model != null) {
            EObject umlElement = model.eResource().getEObject(elementURI.trim());
            return umlElement;
        }
        return null;
    }

    public String getUmlElementName(String projectName, String fileModelPath, String elementID) throws Exception {
        Model model = this.loadModel(projectName, fileModelPath);
        if (model != null) {
            EObject umlElement = model.eResource().getEObject(elementID.trim());
            return ((Class)umlElement).getName();
        }
        return null;
    }

    public EList<Element> getSubComponentsOfOwner(Constraint constraint) {
        Element element = constraint.getOwner();
        BasicEList subComponents = new BasicEList();
        for (Property umlProperty : this.getSubComponentsInstances((Class)element)) {
            subComponents.add((Object)this.getUmlType(umlProperty));
        }
        return subComponents;
    }

    public Element getSubComponent(Element element, String componentName) {
        for (Property umlProperty : this.getSubComponentsInstances((Class)element)) {
            if (umlProperty.getName().compareTo(componentName) != 0) continue;
            return this.getUmlType(umlProperty);
        }
        return null;
    }

    public String[] getSubComponentsNameOfConstraintOwner(Constraint constraint) {
        Element umlElement = constraint.getOwner();
        Set<String> subCompArr = this.getSubComponentsNames((Class)umlElement);
        return this.toArray(subCompArr);
    }

    private String[] toArray(Set<String> set) {
        String[] strArray = new String[set.size()];
        return set.toArray(strArray);
    }

    private String[] toArray(EList<String> eList) {
        Object[] strArray = new String[eList.size()];
        return (String[])eList.toArray(strArray);
    }

    public String getQualifiedName(NamedElement element) {
        return element.getQualifiedName();
    }

    public String getComponentName(Element umlComponent) {
        if (this.isBlock(umlComponent)) {
            return ((Class)umlComponent).getName();
        }
        if (this.isComponentInstance(umlComponent)) {
            return ((Property)umlComponent).getName();
        }
        return null;
    }

    public EList<Property> getInstantiatedArchitecureElementsAsProperties(Class umlComponent) {
        BasicEList instantiatedArchitecureList = new BasicEList();
        for (Property umlProperty : umlComponent.getAttributes()) {
            if (umlProperty.getAppliedStereotype(INSTANTIATED_ARCHITECTURE_CONFIGURATION) == null) continue;
            instantiatedArchitecureList.add((Object)umlProperty);
        }
        return instantiatedArchitecureList;
    }

    public EList<InstantiatedArchitectureConfiguration> getInstantiatedArchitecureConfigurations(Class umlComponent) {
        BasicEList instantiatedArchitecureList = new BasicEList();
        for (Property umlProperty : umlComponent.getAttributes()) {
            if (umlProperty.getAppliedStereotype(INSTANTIATED_ARCHITECTURE_CONFIGURATION) == null) continue;
            instantiatedArchitecureList.add((Object)this.getInstantiatedArchitectureConfiguration(umlProperty));
        }
        return instantiatedArchitecureList;
    }

    public List<Property> getSubComponentsInstances(Class umlComponent) {
        ArrayList<Property> subComponents = new ArrayList<Property>();
        EList umlProperties = umlComponent.getAttributes();
        if (umlProperties != null) {
            for (Property umlProperty : umlProperties) {
                if (!this.isComponentInstance((Element)umlProperty)) continue;
                subComponents.add(umlProperty);
            }
        }
        return subComponents;
    }

    public Property getUmlComponentInstance(Class umlComponent, String componentName) {
        for (Property umlProperty : umlComponent.getAttributes()) {
            if (!umlProperty.getName().equals(componentName) || !this.isComponentInstance((Element)umlProperty)) continue;
            return umlProperty;
        }
        return null;
    }

    public String[] getEnumValuesFromComponentPorts(Class umlComponent) {
        BasicEList enumValuesEList = new BasicEList();
        for (Port port : this.getUmlPortsFromClass(umlComponent)) {
            if (!this.isEnumerationAttribute((Property)port)) continue;
            Set<String> currValues = this.getListValuesForEnumeratorType(port.getType());
            enumValuesEList.addAll(currValues);
        }
        return this.toArray((EList<String>)enumValuesEList);
    }

    public EList<String> getEnumValuesFromComponentAttributes(Element umlComponent) {
        BasicEList enumValuesEList = new BasicEList();
        if (this.isComponentInstance(umlComponent)) {
            umlComponent = this.getUmlType((Property)umlComponent);
        }
        if (this.isBlock(umlComponent) || this.isCompType(umlComponent) || this.isComponentImplementation(umlComponent)) {
            Class umlClass = (Class)umlComponent;
            for (Property umlProperty : umlClass.getOwnedAttributes()) {
                Set<String> currValues;
                if (!this.isEnumerationAttribute(umlProperty) || (currValues = this.getListValuesForEnumeratorType(umlProperty.getType())) == null) continue;
                enumValuesEList.addAll(currValues);
            }
            EList<FunctionBehavior> functionBehaviors = this.getUmlFunctionBehaviors((Element)umlClass);
            if (functionBehaviors != null) {
                for (FunctionBehavior functionBehavior : functionBehaviors) {
                    Set<String> currValues;
                    for (Parameter parameter : functionBehavior.inputParameters()) {
                        currValues = this.getListValuesForEnumeratorType(parameter.getType());
                        if (currValues == null) continue;
                        enumValuesEList.addAll(currValues);
                    }
                    for (Parameter parameter : functionBehavior.outputParameters()) {
                        currValues = this.getListValuesForEnumeratorType(parameter.getType());
                        if (currValues == null) continue;
                        enumValuesEList.addAll(currValues);
                    }
                }
            }
        }
        return enumValuesEList;
    }

    public ArrayList<Class> getBlocks(Package umlSelectedPackage) {
        EList packageChildren = umlSelectedPackage.getOwnedElements();
        ArrayList<Object> blocksAsClasses = new ArrayList<Class>();
        if (!packageChildren.isEmpty()) {
            blocksAsClasses = new ArrayList();
            for (Element element : packageChildren) {
                if (element.getAppliedStereotype(BLOCK) == null || element.getAppliedStereotype("CHESSContract::Contract") != null) continue;
                blocksAsClasses.add((Class)element);
            }
        }
        return blocksAsClasses;
    }

    public Set<String> getSubComponentsNames(Class umlComponent) {
        HashSet<String> subComponentsNames = new HashSet<String>();
        for (Property umlProperty : this.getSubComponentsInstances(umlComponent)) {
            subComponentsNames.add(umlProperty.getName());
        }
        return subComponentsNames;
    }

    public String[] getSubComponentsName(Class umlComponent) {
        return this.toArray(this.getSubComponentsNames(umlComponent));
    }

    public EList<Port> getUmlPorts(Element umlElement, boolean isStaticPort) {
        BasicEList portsArr = new BasicEList();
        if (this.isBlock(umlElement) || this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            portsArr.addAll(this.getUmlPortsFromClass((Class)umlElement, isStaticPort));
        }
        if (this.isComponentInstance(umlElement)) {
            portsArr.addAll(this.getUmlPortsFromProperty((Property)umlElement, isStaticPort));
        }
        return portsArr;
    }

    private EList<Port> getUmlPortsFromProperty(Property umlElement, boolean isStaticPort) {
        return this.getUmlPortsFromClass((Class)this.getUmlType(umlElement), isStaticPort);
    }

    public EList<Port> getUmlPorts(Element umlElement, int portDirection, boolean isStaticPort) {
        BasicEList portsArr = new BasicEList();
        if (this.isBlock(umlElement)) {
            portsArr.addAll(this.getUmlPortsFromClass((Class)umlElement, portDirection, isStaticPort));
        }
        if (this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            portsArr.addAll(this.getUmlPortsFromComponent((Component)umlElement, portDirection, isStaticPort));
        }
        if (this.isComponentInstance(umlElement)) {
            portsArr.addAll(this.getUmlPorts(this.getUmlType((Property)umlElement), portDirection, isStaticPort));
        }
        return portsArr;
    }

    private EList<Port> getUmlPortsFromClass(Class umlComponent, int portDirection, boolean isStatic) {
        BasicEList ports = new BasicEList();
        Stereotype stereotype = StereotypeUtil.getSysMLStereotype(FLOW_Port, (Element)umlComponent);
        for (Port umlPort : umlComponent.getOwnedPorts()) {
            org.eclipse.papyrus.sysml.portandflows.FlowPort fp = (org.eclipse.papyrus.sysml.portandflows.FlowPort)umlPort.getStereotypeApplication(stereotype);
            if (fp.getDirection().getValue() != portDirection || umlPort.isStatic() != isStatic) continue;
            ports.add((Object)umlPort);
        }
        return ports;
    }

    public boolean isInputPort(Element umlPort) {
        return umlPort instanceof Property && this.getPortDirection(umlPort) != null && this.getPortDirection(umlPort) == 0;
    }

    public boolean isInOutPort(Element umlPort) {
        return umlPort instanceof Property && this.getPortDirection(umlPort) != null && this.getPortDirection(umlPort) == 2;
    }

    public boolean isOutputPort(Element umlPort) {
        return umlPort instanceof Property && this.getPortDirection(umlPort) != null && this.getPortDirection(umlPort) == 1;
    }

    public Integer getPortDirection(Element umlPort) {
        if (this.isFlowPort(umlPort)) {
            return this.getFlowPort((Port)umlPort).getDirection().getValue();
        }
        if (this.isFlowPortMarte(umlPort)) {
            return this.getFlowPortMarte((Port)umlPort).getDirection().getValue();
        }
        return null;
    }

    private Set<Port> getUmlPortsFromComponent(Component umlComponent, int portDirection, boolean isStaticPort) {
        HashSet<Port> ports = new HashSet<Port>();
        Stereotype stereotype = StereotypeUtil.getMarteStereotype(FLOW_Port_MARTE, (Element)umlComponent);
        for (Port umlPort : umlComponent.getOwnedPorts()) {
            FlowPort fp = (FlowPort)umlPort.getStereotypeApplication(stereotype);
            if (fp.getDirection().getValue() != portDirection || umlPort.isStatic() != isStaticPort) continue;
            ports.add(umlPort);
        }
        return ports;
    }

    private EList<Port> getUmlPortsFromClass(Class umlComponent, boolean isStaticPort) {
        BasicEList ports = new BasicEList();
        for (Port umlPort : umlComponent.getOwnedPorts()) {
            if (umlPort.isStatic() != isStaticPort) continue;
            ports.add((Object)umlPort);
        }
        return ports;
    }

    private Set<Port> getUmlPortsFromClass(Class umlComponent) {
        HashSet<Port> ports = new HashSet<Port>();
        for (Port umlPort : umlComponent.getOwnedPorts()) {
            ports.add(umlPort);
        }
        return ports;
    }

    public Package getToPackage(Element umlElememt) {
        Package tmp = umlElememt.getNearestPackage();
        while (tmp.getOwner() != null && tmp.getOwner() instanceof Package) {
            tmp = (Package)tmp.getOwner();
        }
        return tmp;
    }

    public Package getContainingPackage(Element umlElement) {
        return umlElement.getNearestPackage();
    }

    private org.eclipse.papyrus.sysml.portandflows.FlowPort getFlowPort(Port umlPort) {
        Stereotype stereotype = StereotypeUtil.getSysMLStereotype(FLOW_Port, (Element)umlPort);
        return (org.eclipse.papyrus.sysml.portandflows.FlowPort)umlPort.getStereotypeApplication(stereotype);
    }

    private FlowPort getFlowPortMarte(Port umlPort) {
        Stereotype stereotype = StereotypeUtil.getMarteStereotype(FLOW_Port_MARTE, (Element)umlPort);
        return (FlowPort)umlPort.getStereotypeApplication(stereotype);
    }

    public boolean isPort(Element umlElement) {
        return umlElement instanceof Property && (this.isFlowPort(umlElement) || this.isFlowPortMarte(umlElement));
    }

    private boolean isFlowPort(Element umlElement) {
        return umlElement instanceof Property && umlElement.getAppliedStereotype(FLOW_Port) != null;
    }

    private boolean isFlowPortMarte(Element umlElement) {
        return umlElement instanceof Property && umlElement.getAppliedStereotype(FLOW_Port_MARTE) != null;
    }

    public void deleteComponentContract(Class clazz) {
        clazz.destroy();
    }

    public boolean isComponentImplementation(Element umlElement) {
        return umlElement instanceof Class && umlElement.getAppliedStereotype(COMP_IMPL) != null;
    }

    public boolean isInstantiatedArchitecuture(Element umlElement) {
        return umlElement instanceof Property && umlElement.getAppliedStereotype(INSTANTIATED_ARCHITECTURE_CONFIGURATION) != null;
    }

    public boolean isComponentInstance(Element umlProperty) {
        if (!(umlProperty instanceof Property)) {
            return false;
        }
        Property property = (Property)umlProperty;
        if (property.getAssociation() == null) {
            return false;
        }
        if (ContractEntityUtil.getInstance().isContractProperty((Element)property)) {
            return false;
        }
        if (this.isInstantiatedArchitecuture((Element)property)) {
            return false;
        }
        Element owner = this.getOwner(umlProperty);
        Association association = property.getAssociation();
        int associationEndsSize = association.getEndTypes().size();
        if (associationEndsSize != 2) {
            return false;
        }
        boolean End1TypeIsOwner = ((Type)association.getEndTypes().get(0)).equals(owner);
        boolean End2TypeIsOwner = ((Type)association.getEndTypes().get(1)).equals(owner);
        return associationEndsSize == 2 && (End1TypeIsOwner || End2TypeIsOwner);
    }

    public boolean isBooleanAttribute(Property umlProperty) {
        return this.isBooleanType(umlProperty.getType());
    }

    public boolean isBooleanType(Type type) {
        if (type != null) {
            return type.getQualifiedName().compareTo(BOOLEAN_TYPE) == 0 || type.getQualifiedName().compareTo(MARTE_BOOLEAN_TYPE) == 0;
        }
        return false;
    }

    public String[] getLowerUpperBoundsForRangeType(Type umlType) {
        BoundedSubtype boundedSubtype = this.getRangeAttribute(umlType);
        String[] bounds = new String[]{boundedSubtype.getMinValue(), boundedSubtype.getMaxValue()};
        return bounds;
    }

    private BoundedSubtype getRangeAttribute(Type umlType) {
        Stereotype stereotype = StereotypeUtil.getMarteStereotype(BOUNDED_TYPE, (Element)umlType);
        return (BoundedSubtype)umlType.getStereotypeApplication(stereotype);
    }

    public boolean isRangeAttribute(Property umlProperty) {
        return this.isRangeType(umlProperty.getType());
    }

    public boolean isRangeType(Type umlType) {
        return umlType != null && umlType.getAppliedStereotype(BOUNDED_TYPE) != null;
    }

    public boolean isDoubleAttribute(Property umlProperty) {
        if (umlProperty.getType() != null) {
            return umlProperty.getType().getName().compareTo("Double") == 0;
        }
        return false;
    }

    public boolean isStringAttribute(Property umlProperty) {
        return this.isStringType(umlProperty.getType());
    }

    public boolean isRealAttribute(Property umlProperty) {
        return this.isRealType(umlProperty.getType());
    }

    public boolean isIntegerAttribute(Property umlProperty) {
        return this.isIntegerType(umlProperty.getType());
    }

    public boolean isIdealClockAttribute(Property umlProperty) {
        return this.isIdealClockType(umlProperty.getType());
    }

    public boolean isContinuousAttribute(Property umlProperty) {
        if (umlProperty.getType() != null) {
            return this.isContinuousType(umlProperty.getType());
        }
        return false;
    }

    public boolean isContinuousType(Type type) {
        if (type != null) {
            return type.getQualifiedName().compareTo(CHESS_CONTINUOUS_TYPE) == 0;
        }
        return false;
    }

    public Type getAttributeType(Property umlProperty) {
        return umlProperty.getType();
    }

    public boolean isEnumerationAttribute(Property umlProperty) {
        return this.isEnumerationType(umlProperty.getType());
    }

    public boolean isEnumerationType(Type umlType) {
        if (umlType != null) {
            return umlType instanceof Enumeration;
        }
        return false;
    }

    public boolean isIdealClockType(Type type) {
        if (type != null) {
            System.out.println(type.getQualifiedName());
            return type.getQualifiedName().compareTo(MARTE_IDEALCLOCK_TYPE) == 0;
        }
        return false;
    }

    public Set<String> getListValuesForEnumeratorType(Type umlType) {
        HashSet<String> enumValuesNames = new HashSet<String>();
        if (umlType instanceof Enumeration) {
            for (EnumerationLiteral enumLit : ((Enumeration)umlType).getOwnedLiterals()) {
                enumValuesNames.add(enumLit.getName());
            }
            return enumValuesNames;
        }
        return null;
    }

    public boolean isEnumValue(String value, Type umlType) {
        if (umlType instanceof Enumeration) {
            return this.getListValuesForEnumeratorType(umlType).contains(value);
        }
        return false;
    }

    public String[] getValuesForEnumeratorType(Type umlType) {
        Set<String> enumValuesNames = this.getListValuesForEnumeratorType(umlType);
        if (enumValuesNames != null) {
            return this.toArray(enumValuesNames);
        }
        return null;
    }

    public Element getUmlType(Property umlProperty) {
        return umlProperty.getType();
    }

    public boolean isBlock(Element umlClass) {
        if (umlClass instanceof Class) {
            return umlClass.getAppliedStereotype(BLOCK) != null;
        }
        return false;
    }

    public boolean isCompType(Element umlComponent) {
        if (umlComponent instanceof Class) {
            return umlComponent.getAppliedStereotype(COMP_TYPE) != null;
        }
        return false;
    }

    public boolean isSystem(Element umlElement) {
        if (umlElement instanceof Class) {
            return umlElement.getAppliedStereotype(SYSTEM) != null;
        }
        return false;
    }

    public boolean isFaultyStateMachine(Element umlElement) {
        if (umlElement instanceof StateMachine) {
            return umlElement.getAppliedStereotype(FAULTY_STATE_MACHINE) != null;
        }
        return false;
    }

    public boolean isNominalStateMachine(Element umlElement) {
        if (umlElement instanceof StateMachine) {
            return umlElement.getAppliedStereotype(FAULTY_STATE_MACHINE) == null;
        }
        return false;
    }

    public boolean isPrioritizedTransition(Element umlElement) {
        if (umlElement instanceof Transition) {
            return umlElement.getAppliedStereotype(PRIORITIZED_TRANSITION) != null;
        }
        return false;
    }

    public Element getOwner(Element umlElement) {
        return umlElement.getOwner();
    }

    public String getName(Class umlClass) {
        return umlClass.getName();
    }

    public String[] getPortsNames(Element umlElement, int portDirection, boolean isStaticPort) {
        BasicEList portsNames = new BasicEList();
        for (Port umlPort : this.getUmlPorts(umlElement, portDirection, isStaticPort)) {
            portsNames.add((Object)umlPort.getName());
        }
        return this.toArray((EList<String>)portsNames);
    }

    public EList<String> getPortsName(EList<Port> ports) {
        BasicEList portsNames = new BasicEList();
        for (Port umlPort : ports) {
            portsNames.add((Object)umlPort.getName());
        }
        return portsNames;
    }

    public String[] getInputPortsNames(Element umlElement, boolean isStaticPort) {
        return this.getPortsNames(umlElement, 0, isStaticPort);
    }

    public String[] getOutputPortsNames(Element umlElement, boolean isStaticPort) {
        return this.getPortsNames(umlElement, 1, isStaticPort);
    }

    public String[] getInputOutputPortsNames(Element umlElement, boolean isStaticPort) {
        return this.getPortsNames(umlElement, 2, isStaticPort);
    }

    public Set<Property> getSupportedAttributes(Element umlElement, Boolean isStaticAttribute) {
        HashSet<Property> simpleAttributes = new HashSet<Property>();
        if (this.isComponentInstance(umlElement)) {
            umlElement = this.getUmlType((Property)umlElement);
        }
        if (this.isBlock(umlElement) || this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            Class umlClass = (Class)umlElement;
            for (Property umlProperty : umlClass.getOwnedAttributes()) {
                if (isStaticAttribute != null && umlProperty.isStatic() != isStaticAttribute.booleanValue() || !this.isBooleanAttribute(umlProperty) && !this.isContinuousAttribute(umlProperty) && !this.isDoubleAttribute(umlProperty) && !this.isRangeAttribute(umlProperty) && !this.isEnumerationAttribute(umlProperty) && !this.isIntegerAttribute(umlProperty) && !this.isRealAttribute(umlProperty) && !this.isStringAttribute(umlProperty) && !this.isIdealClockAttribute(umlProperty)) continue;
                simpleAttributes.add(umlProperty);
            }
        }
        return simpleAttributes;
    }

    private Set<Property> getIntegerAttributes(Element umlElement) {
        HashSet<Property> integerAttributes = new HashSet<Property>();
        if (this.isBlock(umlElement) || this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            Class umlClass = (Class)umlElement;
            EList attributes = umlClass.getOwnedAttributes();
            for (Property umlProperty : attributes) {
                if (!this.isIntegerAttribute(umlProperty)) continue;
                integerAttributes.add(umlProperty);
            }
        }
        if (this.isComponentInstance(umlElement)) {
            integerAttributes.addAll(this.getIntegerAttributes(this.getUmlType((Property)umlElement)));
        }
        return integerAttributes;
    }

    public Set<Property> getAttributesExceptPorts(Element umlElement, Boolean isStaticAttribute) {
        HashSet<Property> attributes = new HashSet<Property>();
        for (Property umlProperty : this.getSupportedAttributes(umlElement, isStaticAttribute)) {
            if (this.isPort((Element)umlProperty)) continue;
            attributes.add(umlProperty);
        }
        return attributes;
    }

    public Set<Property> getIntegerAttributesExceptPorts(Element umlElement) {
        HashSet<Property> integerAttributes = new HashSet<Property>();
        for (Property umlProperty : this.getIntegerAttributes(umlElement)) {
            if (this.isPort((Element)umlProperty)) continue;
            integerAttributes.add(umlProperty);
        }
        return integerAttributes;
    }

    public Collection<StateMachine> getNominalStateMachines() {
        UmlModel umlModel = UmlUtils.getUmlModel();
        Set<StateMachine> stateMachines = this.getNominalStateMachines(umlModel);
        return stateMachines;
    }

    public Set<StateMachine> getNominalStateMachines(Model umlModel) {
        TreeIterator allElements;
        HashSet<StateMachine> stateMachines = new HashSet<StateMachine>();
        if (umlModel != null && (allElements = umlModel.eResource().getAllContents()) != null) {
            Collection classes = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getClass_());
            for (Class c : classes) {
                if (!(c instanceof StateMachine) || c.getAppliedStereotype(FAULTY_STATE_MACHINE) != null) continue;
                stateMachines.add((StateMachine)c);
            }
        }
        return stateMachines;
    }

    public Set<StateMachine> getNominalStateMachines(UmlModel umlModel) {
        TreeIterator allElements;
        HashSet<StateMachine> stateMachines = new HashSet<StateMachine>();
        if (umlModel != null && (allElements = umlModel.getResource().getAllContents()) != null) {
            Collection classes = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getClass_());
            for (Class c : classes) {
                if (!this.isNominalStateMachine((Element)c)) continue;
                stateMachines.add((StateMachine)c);
            }
        }
        return stateMachines;
    }

    public Set<StateMachine> getNominalStateMachines(Class umlSelectedComponent, boolean fromSubComponent) {
        Set<StateMachine> stateMachines = this.getNominalStateMachines(umlSelectedComponent);
        if (fromSubComponent) {
            for (Property subComponentInstance : this.getSubComponentsInstances(umlSelectedComponent)) {
                stateMachines.addAll(this.getNominalStateMachines((Class)subComponentInstance.getType(), true));
            }
        }
        return stateMachines;
    }

    public StateMachine getFirstNominalStateMachine(Class umlSelectedComponent) {
        Set<StateMachine> stateMachines = this.getNominalStateMachines(umlSelectedComponent);
        if (stateMachines != null && stateMachines.size() > 0) {
            return stateMachines.iterator().next();
        }
        return null;
    }

    public Set<StateMachine> getNominalStateMachines(Class umlSelectedComponent) {
        EList behaviours;
        HashSet<StateMachine> stateMachines = new HashSet<StateMachine>();
        if (umlSelectedComponent != null && (behaviours = umlSelectedComponent.getOwnedBehaviors()) != null) {
            for (Class c : behaviours) {
                if (!(c instanceof StateMachine) || c.getAppliedStereotype(FAULTY_STATE_MACHINE) != null) continue;
                stateMachines.add((StateMachine)c);
            }
        }
        return stateMachines;
    }

    public StateMachine getNominalStateMachine(Class umlSelectedComponent, String stateMachineName) {
        for (StateMachine stateMachine : this.getNominalStateMachines(umlSelectedComponent)) {
            if (!stateMachine.getName().equals(stateMachineName)) continue;
            return stateMachine;
        }
        return null;
    }

    private <T> Collection<T> iterator2Collection(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            T item = iter.next();
            list.add(item);
        }
        return list;
    }

    public EList<Transition> getTranstitions(StateMachine stateMachine) {
        Region region = (Region)stateMachine.getRegions().get(0);
        return region.getTransitions();
    }

    public EList<Vertex> getStates(StateMachine stateMachine) {
        Region region = (Region)stateMachine.getRegions().get(0);
        return region.getSubvertices();
    }

    public Vertex getState(StateMachine stateMachine, String stateName) {
        Region region = (Region)stateMachine.getRegions().get(0);
        return region.getSubvertex(stateName);
    }

    public EList<Region> getRegions(StateMachine stateMachine) {
        return stateMachine.getRegions();
    }

    public boolean isInitialState(Vertex state) {
        return state instanceof Pseudostate && ((Pseudostate)state).getKind().equals((Object)PseudostateKind.INITIAL_LITERAL);
    }

    public boolean isFinalState(Vertex state) {
        return state instanceof Pseudostate && ((Pseudostate)state).getKind().getName().compareTo("Terminate") == 0;
    }

    public EList<Vertex> getIntermediateStates(StateMachine stateMachine) {
        BasicEList intermediateStates = new BasicEList();
        for (Vertex state : this.getStates(stateMachine)) {
            if (this.isInitialState(state) || this.isFinalState(state)) continue;
            intermediateStates.add((Object)state);
        }
        return intermediateStates;
    }

    public EList<String> getStatesNameList(EList<Vertex> states) {
        BasicEList names = new BasicEList();
        for (Vertex state : states) {
            names.add((Object)state.getName());
        }
        return names;
    }

    public EList<String> getTransitionNameList(EList<Transition> transitions) throws Exception {
        BasicEList transNames = new BasicEList();
        for (Transition trans : transitions) {
            if (trans.getName() == null) {
                throw new Exception("In " + trans.containingStateMachine().getQualifiedName() + ", one transition has name == null.");
            }
            transNames.add((Object)trans.getName());
        }
        return transNames;
    }

    public String getStateMachineName(StateMachine stateMachine) {
        return stateMachine.getName();
    }

    public String getTransitionName(Transition transition) {
        return transition.getName();
    }

    public Vertex getInitialState(StateMachine stateMachine) {
        for (Vertex state : this.getStates(stateMachine)) {
            if (!this.isInitialState(state)) continue;
            return state;
        }
        return null;
    }

    public EList<Transition> getInitialTransitions(StateMachine stateMachine) throws Exception {
        Vertex initialState = this.getInitialState(stateMachine);
        if (initialState != null) {
            return initialState.getOutgoings();
        }
        throw new Exception("The state machine of " + ((Class)stateMachine.getOwner()).getName() + " does not have the initial state.");
    }

    public EList<Transition> getNonInitialTransitions(StateMachine stateMachine) {
        EList<Vertex> states = this.getIntermediateStates(stateMachine);
        BasicEList transitions = new BasicEList();
        for (Vertex state : states) {
            if (this.isInitialState(state)) continue;
            transitions.addAll((Collection)state.getOutgoings());
        }
        return transitions;
    }

    public EList<Transition> getOutgoingTransitions(Vertex state) {
        return state.getOutgoings();
    }

    public EList<Transition> getIncomingTransitions(Vertex state) {
        return state.getIncomings();
    }

    public String getSignalEventName(Trigger trigger) {
        if (trigger.getEvent() instanceof SignalEvent) {
            return ((SignalEvent)trigger.getEvent()).getSignal().getName();
        }
        return null;
    }

    public Vertex getTransitionNextState(Transition transition) {
        return transition.getTarget();
    }

    public Vertex getTransitionSourceState(Transition transition) {
        return transition.getSource();
    }

    public Constraint getTransitionGuard(Transition transition) {
        return transition.getGuard();
    }

    public String getTransitionGuardText(Transition transition, String language) {
        Constraint condition = this.getTransitionGuard(transition);
        if (condition != null) {
            return this.getConditionExpression(condition, language);
        }
        return null;
    }

    public OpaqueBehavior getTransitionEffect(Transition transition) {
        if (transition.getEffect() instanceof OpaqueBehavior) {
            return (OpaqueBehavior)transition.getEffect();
        }
        return null;
    }

    public EList<String> getTransitionEffectParameters(Transition transition) {
        OpaqueBehavior effect = this.getTransitionEffect(transition);
        BasicEList paramsNames = new BasicEList();
        for (Parameter par : effect.getOwnedParameters()) {
            paramsNames.add((Object)par.getName());
        }
        return paramsNames;
    }

    public String getTransitionEffectText(Transition transition, String language) {
        OpaqueBehavior effect = this.getTransitionEffect(transition);
        if (effect != null) {
            return this.getBodyForLanguageOfBodyOwner((BodyOwner)this.getTransitionEffect(transition), language);
        }
        return null;
    }

    public Integer getTransitionPriority(Transition transition) {
        if (this.isPrioritizedTransition((Element)transition)) {
            Stereotype prioritizedTransitionStereotype = StereotypeUtil.getCHESSStereotype(PRIORITIZED_TRANSITION, (Element)transition);
            PrioritizedTransition prioritizedTransition = (PrioritizedTransition)transition.getStereotypeApplication(prioritizedTransitionStereotype);
            return prioritizedTransition.getPriority();
        }
        return null;
    }

    public void setTransitionEffectText(Transition transition, String effectText, String language) {
        OpaqueBehavior effect = this.getTransitionEffect(transition);
        if (effect != null) {
            effect.getLanguages().add(0, (Object)language);
            effect.getBodies().add(0, (Object)effectText);
        }
    }

    public String getGuardName(Constraint guard) {
        return guard.getName();
    }

    public String getStateName(Vertex state) {
        return state.getName();
    }

    public String getEffectName(Behavior effect) {
        return effect.getName();
    }

    public boolean isFinalTransition(Transition transition) {
        return this.isFinalState(transition.getTarget());
    }

    public EList<Port> getEvents(StateMachine stateMachine) {
        EList<Port> eventsPort = this.getEventPorts(this.getOwner((Element)stateMachine));
        return eventsPort;
    }

    public Constraint createTransitionGuard(Transition owner, String guardName, String guardText, String language) {
        Constraint guard = owner.createGuard(guardName);
        OpaqueExpression opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
        guard.createSpecification(null, null, opaqueExpression.eClass());
        this.setOpaqueExpressionTextInUMLConstraint(guard, guardText, language);
        return guard;
    }

    public OpaqueBehavior createTransitionEffect(Transition owner, String effectName, String effectText, String language) {
        OpaqueBehavior opaqueBehavior = (OpaqueBehavior)owner.createEffect(effectName, UMLPackage.eINSTANCE.getOpaqueBehavior());
        this.setTransitionEffectText(owner, effectText, language);
        return opaqueBehavior;
    }

    public EList<Port> getEventPorts(Element umlElement) {
        BasicEList eventPorts = new BasicEList();
        if (this.isComponentInstance(umlElement)) {
            umlElement = this.getUmlType((Property)umlElement);
        }
        if (this.isBlock(umlElement) || this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            Class umlClass = (Class)umlElement;
            for (Property umlProperty : umlClass.getOwnedAttributes()) {
                if (!this.isEventPortAttribute(umlProperty)) continue;
                eventPorts.add((Object)((Port)umlProperty));
            }
        }
        return eventPorts;
    }

    public boolean isEventPortAttribute(Property umlProperty) {
        return umlProperty.getType() != null && this.isEventType(umlProperty.getType());
    }

    public boolean isEventType(Type type) {
        return type instanceof Signal;
    }

    public EList<Port> getTransitionEvents(Transition transition) {
        if (!this.isTransitionWithNoEvent(transition)) {
            return ((Trigger)transition.getTriggers().get(0)).getPorts();
        }
        return null;
    }

    public String getPortName(Port port) {
        return port.getName();
    }

    public String getAttributeName(Property attribute) {
        return attribute.getName();
    }

    public String getParameterName(Parameter parameter) {
        return parameter.getName();
    }

    public Element getParameterOwner(Parameter parameter) {
        return parameter.getOwner();
    }

    public Element getUmlFunctionBehaviorOwner(FunctionBehavior function) {
        return function.getOwner();
    }

    public boolean isTransitionWithNoEvent(Transition transition) {
        return transition.getTriggers() == null || transition.getTriggers().size() == 0 || ((Trigger)transition.getTriggers().get(0)).getPorts() == null || ((Trigger)transition.getTriggers().get(0)).getPorts().size() == 0;
    }

    public boolean isRealType(Type type) {
        if (type != null) {
            return type.getQualifiedName().compareTo(REAL_TYPE) == 0 || type.getQualifiedName().compareTo(MARTE_REAL_TYPE) == 0;
        }
        return false;
    }

    public boolean isIntegerType(Type type) {
        if (type != null) {
            return type.getQualifiedName().compareTo(INTEGER_TYPE) == 0 || type.getQualifiedName().compareTo(MARTE_INTEGER_TYPE) == 0;
        }
        return false;
    }

    public boolean isClockType(Type type) {
        if (type != null) {
            return type.getQualifiedName().compareTo(INTEGER_TYPE) == 0 || type.getQualifiedName().compareTo(MARTE_INTEGER_TYPE) == 0;
        }
        return false;
    }

    public boolean isStringType(Type type) {
        if (type != null) {
            return type.getQualifiedName().compareTo(STRING_TYPE) == 0;
        }
        return false;
    }

    public EList<? extends Port> getUmlPortsExceptEvents(Element umlElement, int portDirection) {
        if (this.isComponentInstance(umlElement)) {
            umlElement = this.getUmlType((Property)umlElement);
        }
        BasicEList portsArr = new BasicEList();
        if (this.isBlock(umlElement)) {
            portsArr.addAll(this.getUmlPortsExceptEventsFromClass((Class)umlElement, portDirection));
        }
        if (this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            portsArr.addAll(this.getUmlPortsExceptEventsFromComponent((Component)umlElement, portDirection));
        }
        return portsArr;
    }

    private Collection<? extends Port> getUmlPortsExceptEventsFromComponent(Component umlComponent, int portDirection) {
        HashSet<Port> ports = new HashSet<Port>();
        for (Port umlPort : umlComponent.getOwnedPorts()) {
            FlowPort fp = this.getFlowPortMarte(umlPort);
            if (fp.getDirection().getValue() != portDirection || this.isEventPortAttribute((Property)umlPort)) continue;
            ports.add(umlPort);
        }
        return ports;
    }

    private EList<? extends Port> getUmlPortsExceptEventsFromClass(Class umlElement, int portDirection) {
        BasicEList ports = new BasicEList();
        for (Port umlPort : umlElement.getOwnedPorts()) {
            org.eclipse.papyrus.sysml.portandflows.FlowPort fp = this.getFlowPort(umlPort);
            if (fp.getDirection().getValue() != portDirection || this.isEventPortAttribute((Property)umlPort)) continue;
            ports.add((Object)umlPort);
        }
        return ports;
    }

    public String getConditionExpression(Constraint condition, String language) {
        if (condition.getSpecification() != null && condition.getSpecification() instanceof OpaqueExpression && ((OpaqueExpression)condition.getSpecification()).getBodies() != null) {
            return this.getBodyForLanguageOfBodyOwner((BodyOwner)((OpaqueExpression)condition.getSpecification()), language);
        }
        return null;
    }

    public boolean isSystemViewPackage(Element obj) {
        if (obj instanceof Package) {
            Package pkg = (Package)obj;
            if (pkg.getAppliedStereotype(SYSTEM_VIEW) != null) {
                return true;
            }
            EList owningPackages = pkg.allOwningPackages();
            for (Package owningPackage : owningPackages) {
                if (owningPackage.getAppliedStereotype(SYSTEM_VIEW) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAnalysisView(Element obj) {
        if (obj instanceof Package) {
            Package pkg = (Package)obj;
            if (pkg.getAppliedStereotype(ANALYSIS_VIEW) != null) {
                return true;
            }
            EList owningPackages = pkg.allOwningPackages();
            for (Package owningPackage : owningPackages) {
                if (owningPackage.getAppliedStereotype(ANALYSIS_VIEW) == null) continue;
                return true;
            }
        }
        return false;
    }

    public EList<Constraint> getRefinementFormalPropertiesAsConstraints(Element component) {
        if (component instanceof Class) {
            return this.getRefinementFormalPropertiesAsConstraintsFromClass((Class)component);
        }
        if (component instanceof Property) {
            return this.getRefinementFormalPropertiesAsConstraintsFromProperty((Property)component);
        }
        return null;
    }

    private EList<Constraint> getRefinementFormalPropertiesAsConstraintsFromClass(Class component) {
        BasicEList formalProperties = new BasicEList();
        for (Constraint umlConstraint : component.getOwnedRules()) {
            if (!this.isRefinementFormalProperty((Element)umlConstraint)) continue;
            formalProperties.add((Object)umlConstraint);
        }
        return formalProperties;
    }

    private EList<Constraint> getRefinementFormalPropertiesAsConstraintsFromProperty(Property componentInstance) {
        return this.getRefinementFormalPropertiesAsConstraintsFromClass((Class)componentInstance.getType());
    }

    public EList<Constraint> getInterfaceFormalPropertiesAsConstraints(Element component) {
        if (component instanceof Class) {
            return this.getInterfaceFormalPropertiesAsConstraintsFromClass((Class)component);
        }
        if (component instanceof Property) {
            return this.getInterfaceFormalPropertiesAsConstraintsFromProperty((Property)component);
        }
        return null;
    }

    private EList<Constraint> getInterfaceFormalPropertiesAsConstraintsFromClass(Class component) {
        BasicEList formalProperties = new BasicEList();
        for (Constraint umlConstraint : component.getOwnedRules()) {
            if (!this.isInterfaceFormalProperty((Element)umlConstraint)) continue;
            formalProperties.add((Object)umlConstraint);
        }
        return formalProperties;
    }

    private EList<Constraint> getInterfaceFormalPropertiesAsConstraintsFromProperty(Property componentInstance) {
        return this.getInterfaceFormalPropertiesAsConstraintsFromClass((Class)componentInstance.getType());
    }

    public boolean isFormalProperty(Element umlConstraint) {
        if (umlConstraint instanceof Constraint) {
            return umlConstraint.getAppliedStereotype(FORMAL_PROP) != null;
        }
        return false;
    }

    public boolean isInterfaceFormalProperty(Element umlConstraint) {
        return this.isFormalProperty(umlConstraint) && ((Constraint)umlConstraint).getVisibility() == VisibilityKind.PUBLIC_LITERAL;
    }

    public boolean isRefinementFormalProperty(Element umlConstraint) {
        return this.isFormalProperty(umlConstraint) && ((Constraint)umlConstraint).getVisibility() == VisibilityKind.PRIVATE_LITERAL;
    }

    public EList<Constraint> getMacroDefinitionsAsUMLConstraints(Element umlElement) {
        BasicEList constraints = new BasicEList();
        if (this.isBlock(umlElement) || this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            for (Constraint umlConstraint : ((Class)umlElement).getOwnedRules()) {
                if (umlConstraint.getAppliedStereotype(MACRO_DEFINITION) == null) continue;
                constraints.add((Object)umlConstraint);
            }
        }
        if (this.isComponentInstance(umlElement)) {
            constraints.addAll(this.getMacroDefinitionsAsUMLConstraints(this.getUmlType((Property)umlElement)));
        }
        return constraints;
    }

    public boolean isMacroDefinition(Element umlConstraint) {
        if (umlConstraint instanceof Constraint) {
            return umlConstraint.getAppliedStereotype(MACRO_DEFINITION) != null;
        }
        return false;
    }

    public String getConstraintQualifiedName(Constraint formalProperty) {
        if (formalProperty != null) {
            return formalProperty.getQualifiedName();
        }
        return null;
    }

    public String getConstraintName(Constraint constraint) {
        if (constraint != null) {
            return constraint.getName();
        }
        return null;
    }

    public FormalProperty getFormalProperty(Constraint umlConstraint) {
        Stereotype stereotype = StereotypeUtil.getCHESSContractStereotype(FORMAL_PROP, (Element)umlConstraint);
        return (FormalProperty)umlConstraint.getStereotypeApplication(stereotype);
    }

    public boolean isDelegationConstraint(Element umlProperty) {
        return umlProperty instanceof Constraint && umlProperty.getAppliedStereotype(DELEGATION_CONST) != null;
    }

    public EList<Constraint> getDelegationConstraintsAsUMLConstraints(Element umlElement) {
        BasicEList constraints = new BasicEList();
        if (this.isBlock(umlElement) || this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            for (Constraint umlConstraint : ((Class)umlElement).getOwnedRules()) {
                if (umlConstraint.getAppliedStereotype(DELEGATION_CONST) == null) continue;
                constraints.add((Object)umlConstraint);
            }
        }
        if (this.isComponentInstance(umlElement)) {
            constraints.addAll(this.getDelegationConstraintsAsUMLConstraints(this.getUmlType((Property)umlElement)));
        }
        return constraints;
    }

    public EList<FunctionBehavior> getUmlFunctionBehaviors(Element umlElement) {
        BasicEList functionBehaviours = null;
        if (this.isComponentInstance(umlElement)) {
            umlElement = ((Property)umlElement).getType();
        }
        if (umlElement instanceof Class) {
            Class umlClass = (Class)umlElement;
            EList behaviours = umlClass.getOwnedBehaviors();
            for (Behavior behavior : behaviours) {
                if (!(behavior instanceof FunctionBehavior)) continue;
                if (functionBehaviours == null) {
                    functionBehaviours = new BasicEList();
                }
                functionBehaviours.add((Object)((FunctionBehavior)behavior));
            }
        }
        return functionBehaviours;
    }

    public String getUmlFunctionBehaviorName(FunctionBehavior uninterpretedFunction) {
        return uninterpretedFunction.getName();
    }

    public Type getUmlFunctionBehaviorOutputType(FunctionBehavior uninterpretedFunction) {
        for (Parameter parameter : uninterpretedFunction.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.OUT_LITERAL) continue;
            return parameter.getType();
        }
        return null;
    }

    public EList<Type> getUmlFunctionBehaviorInputTypes(FunctionBehavior uninterpretedFunction) {
        BasicEList inputTypes = new BasicEList();
        for (Parameter parameter : uninterpretedFunction.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
            inputTypes.add((Object)parameter.getType());
        }
        return inputTypes;
    }

    public EList<Parameter> getUmlFunctionBehaviorInputParameters(FunctionBehavior function) {
        BasicEList inputParameters = new BasicEList();
        EList parameters = function.getOwnedParameters();
        for (Parameter parameter : parameters) {
            if (parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
            inputParameters.add((Object)parameter);
        }
        return inputParameters;
    }

    public Parameter getUmlFunctionBehaviorOutputParameter(FunctionBehavior function) {
        EList parameters = function.getOwnedParameters();
        for (Parameter parameter : parameters) {
            if (parameter.getDirection() != ParameterDirectionKind.OUT_LITERAL) continue;
            return parameter;
        }
        return null;
    }

    public Object getParameterType(Parameter parameter) {
        return parameter.getType();
    }

    public String[] getComponentInstanceMultiplicity(Property component) throws Exception {
        if (this.isComponentInstance((Element)component)) {
            return this.getAttributeMultiplicity((MultiplicityElement)component);
        }
        throw new Exception(component.getName() + " is not a component instance");
    }

    public String[] getAttributeMultiplicity(MultiplicityElement attribute) {
        ValueSpecification upperValueSpecification = attribute.getUpperValue();
        ValueSpecification lowerValueSpecification = attribute.getLowerValue();
        String upperValue = this.getValueSpecificationValue(upperValueSpecification);
        String lowerValue = this.getValueSpecificationValue(lowerValueSpecification);
        String[] boundaries = new String[]{lowerValue, upperValue};
        return boundaries;
    }

    public String getValueSpecificationValue(ValueSpecification valueSpecification) {
        String strValue = null;
        Object value = null;
        if (valueSpecification instanceof LiteralInteger) {
            value = ((LiteralInteger)valueSpecification).getValue();
        } else if (valueSpecification instanceof LiteralUnlimitedNatural) {
            value = ((LiteralUnlimitedNatural)valueSpecification).getValue();
        } else if (valueSpecification instanceof LiteralString) {
            value = ((LiteralString)valueSpecification).getValue();
        }
        logger.debug((Object)("value: " + value));
        strValue = String.valueOf(value);
        if (strValue == "null") {
            strValue = null;
        }
        return strValue;
    }

    private void addConnector(Class owner, Connector connector) {
        owner.getOwnedConnectors().add((Object)connector);
    }

    private Connector createConnector(String connectorName) {
        Connector connector = UMLFactory.eINSTANCE.createConnector();
        connector.setName(connectorName);
        logger.debug((Object)("\n\nCreated " + connectorName + " Connector\n\n"));
        return connector;
    }

    public ConnectorEnd createConnectorEnd(Connector owner, Property sourceOwner, ConnectableElement sourcePort) {
        ConnectorEnd end = owner.createEnd();
        end.setRole(sourcePort);
        end.setPartWithPort(sourceOwner);
        return end;
    }

    public Parameter createFunctionBehaviorParameter(FunctionBehavior owner, String parameterName, Type parameterType, String[] multiplicity, boolean isInput) {
        logger.debug((Object)("\n\n\n Creating functionBehaviorParameter " + parameterName + " for owner " + owner));
        logger.debug((Object)"\n\n\n");
        Parameter parameter = owner.createOwnedParameter(parameterName, parameterType);
        parameter.setDirection(isInput ? ParameterDirectionKind.IN_LITERAL : ParameterDirectionKind.OUT_LITERAL);
        this.setAttributeMultiplicity((MultiplicityElement)parameter, multiplicity);
        logger.debug((Object)("\n\nCreated " + parameterName + " functionBehaviorParameter\n\n"));
        return parameter;
    }

    public Object clone(Object original) {
        EObject context = (EObject)original;
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject copy = copier.copy(context);
        copier.copyReferences();
        return copy;
    }

    public Constraint createFormalProperty(Namespace owner, String formalPropertyName) {
        String propertyName = formalPropertyName;
        Constraint umlNewConstraint = owner.createOwnedRule(propertyName);
        UMLUtils.applyStereotype((Element)umlNewConstraint, (String)FORMAL_PROP);
        return owner.getOwnedRule(propertyName);
    }

    public FunctionBehavior createFunctionBehavior(Class owner, String functionBehaviorName) {
        logger.debug((Object)("\n\n\n Creating functionBehavior " + functionBehaviorName + " for owner " + owner));
        logger.debug((Object)"\n\n\n");
        FunctionBehavior functionBehavior = (FunctionBehavior)owner.createOwnedBehavior(functionBehaviorName, UMLPackage.eINSTANCE.getFunctionBehavior());
        logger.debug((Object)("\n\nCreated " + functionBehaviorName + " FunctionBehavior\n\n"));
        return functionBehavior;
    }

    public PrioritizedTransition createPrioritizedTransition(Transition transition, Integer priority) {
        Stereotype prioritizedTransitionStereotype = this.findStereotype(transition.getNearestPackage(), PRIORITIZED_TRANSITION);
        if (prioritizedTransitionStereotype != null) {
            if (!transition.isStereotypeApplied(prioritizedTransitionStereotype)) {
                transition.applyStereotype(prioritizedTransitionStereotype);
            }
            PrioritizedTransition prioritizedTransition = (PrioritizedTransition)transition.getStereotypeApplication(prioritizedTransitionStereotype);
            prioritizedTransition.setPriority(priority.intValue());
            return prioritizedTransition;
        }
        return null;
    }

    public EList<Parameter> getOwnedInputParameters(FunctionBehavior owner) {
        BasicEList inputParameters = new BasicEList();
        for (Parameter parameter : owner.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
            inputParameters.add((Object)parameter);
        }
        return inputParameters;
    }

    public Parameter createFunctionBehaviorParameter(FunctionBehavior owner, Type parameterType, String[] multiplicity, boolean isInput) {
        String parameterName = null;
        parameterName = isInput ? DEFAULT_PARAMETER_IN_NAME + (this.getOwnedInputParameters(owner).size() + 1) : DEFAULT_PARAMETER_OUT_NAME;
        return this.createFunctionBehaviorParameter(owner, parameterName, parameterType, multiplicity, isInput);
    }

    public Port createNonStaticPort(Class owner, String portName, Type portType, String[] multiplicityBounds, boolean isInput, Stereotype flowportStereotype) {
        Port umlPort = UMLFactory.eINSTANCE.createPort();
        umlPort.setName(portName);
        umlPort.setType(portType);
        owner.getOwnedPorts().add((Object)umlPort);
        umlPort.applyStereotype(flowportStereotype);
        umlPort.setAggregation(AggregationKind.get((int)2));
        org.eclipse.papyrus.sysml.portandflows.FlowPort flowPort = (org.eclipse.papyrus.sysml.portandflows.FlowPort)umlPort.getStereotypeApplication(flowportStereotype);
        flowPort.setDirection(isInput ? FlowDirection.IN : FlowDirection.OUT);
        this.setAttributeMultiplicity((MultiplicityElement)umlPort, multiplicityBounds);
        logger.debug((Object)("\n\nCreated " + portName + " Port\n\n"));
        return umlPort;
    }

    public Port createStaticPort(Class owner, String portName, Type portType, String[] multiplicityBounds, Stereotype flowPortStereotype) {
        Port umlPort = UMLFactory.eINSTANCE.createPort();
        umlPort.setName(portName);
        umlPort.setType(portType);
        owner.getOwnedPorts().add((Object)umlPort);
        umlPort.applyStereotype(flowPortStereotype);
        umlPort.setAggregation(AggregationKind.get((int)2));
        org.eclipse.papyrus.sysml.portandflows.FlowPort flowPort = (org.eclipse.papyrus.sysml.portandflows.FlowPort)umlPort.getStereotypeApplication(flowPortStereotype);
        flowPort.setDirection(FlowDirection.INOUT);
        umlPort.setIsStatic(true);
        this.setAttributeMultiplicity((MultiplicityElement)umlPort, multiplicityBounds);
        return umlPort;
    }

    public RedefinableTemplateSignature createRedefinableTemplateSignature(Class owner, String parameterName) {
        RedefinableTemplateSignature redefinableTemplateSignature = UMLFactory.eINSTANCE.createRedefinableTemplateSignature();
        redefinableTemplateSignature.setName("redefinableTemplateSignature");
        TemplateParameter templateParameter = UMLFactory.eINSTANCE.createTemplateParameter();
        redefinableTemplateSignature.getOwnedParameters().add((Object)templateParameter);
        LiteralString stringParameter = UMLFactory.eINSTANCE.createLiteralString();
        stringParameter.setName(parameterName);
        stringParameter.setOwningTemplateParameter(templateParameter);
        stringParameter.setTemplateParameter(templateParameter);
        stringParameter.setValue("0");
        templateParameter.setDefault((ParameterableElement)stringParameter);
        templateParameter.setParameteredElement((ParameterableElement)stringParameter);
        owner.setOwnedTemplateSignature((TemplateSignature)redefinableTemplateSignature);
        return redefinableTemplateSignature;
    }

    public String createDelegationConstraintText(String variableIdTextName, String constraintText, String iterConditionText) {
        StringBuffer delegationText = new StringBuffer();
        delegationText.append(String.valueOf(variableIdTextName) + " := " + constraintText);
        if (iterConditionText != null && iterConditionText.length() > 0) {
            delegationText.append(" " + iterConditionText);
        }
        return delegationText.toString();
    }

    public Connector getExistingConnector(EList<Connector> connectors, String variablePortOwner, String variablePortName, String constraintPortOwner, String constraintPortName) {
        for (Connector connector : connectors) {
            EList ends = connector.getEnds();
            if (ends.size() != 2) continue;
            Property sourceOwner = ((ConnectorEnd)ends.get(0)).getPartWithPort();
            Port sourcePort = (Port)((ConnectorEnd)ends.get(0)).getRole();
            if (!sourcePort.getName().equals(constraintPortName) || (sourceOwner == null || !sourceOwner.getName().equals(constraintPortOwner)) && (sourceOwner != null || constraintPortOwner != null)) continue;
            Property targetOwner = ((ConnectorEnd)ends.get(1)).getPartWithPort();
            Port targetPort = (Port)((ConnectorEnd)ends.get(1)).getRole();
            if (!targetPort.getName().equals(variablePortName) || (targetOwner == null || !targetOwner.getName().equals(variablePortOwner)) && (targetOwner != null || variablePortOwner != null)) continue;
            return connector;
        }
        return null;
    }

    public Constraint createInterfaceFormalProperty(Class owner, String assertionName, String assertionText) {
        Constraint umlConstraint = this.createFormalProperty((Namespace)owner, assertionName);
        LiteralString newLs = UMLFactory.eINSTANCE.createLiteralString();
        ValueSpecification vs = umlConstraint.createSpecification("ConstraintSpec", null, newLs.eClass());
        umlConstraint.setSpecification(vs);
        this.setLiteralStringTextInUMLConstraint(umlConstraint, assertionText);
        return umlConstraint;
    }

    public Constraint createRefinementFormalProperty(Class owner, String assertionName, String assertionText) {
        Constraint umlConstraint = this.createFormalProperty((Namespace)owner, assertionName);
        LiteralString newLs = UMLFactory.eINSTANCE.createLiteralString();
        ValueSpecification vs = umlConstraint.createSpecification("ConstraintSpec", null, newLs.eClass());
        umlConstraint.setSpecification(vs);
        umlConstraint.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        this.setLiteralStringTextInUMLConstraint(umlConstraint, assertionText);
        return umlConstraint;
    }

    public void setTextInUMLConstraint(Constraint umlConstraint, String formalPropertyText, String language) {
        logger.debug((Object)("saveFormalProperty: " + formalPropertyText));
        if (umlConstraint.getSpecification() instanceof LiteralString) {
            this.setLiteralStringTextInUMLConstraint(umlConstraint, formalPropertyText);
        } else if (umlConstraint.getSpecification() instanceof OpaqueExpression) {
            this.setOpaqueExpressionTextInUMLConstraint(umlConstraint, formalPropertyText, language);
        }
    }

    public void setLiteralStringTextInUMLConstraint(Constraint umlConstraint, String formalPropertyText) {
        if (umlConstraint.getSpecification() instanceof LiteralString) {
            LiteralString litString = (LiteralString)umlConstraint.getSpecification();
            litString.setValue(formalPropertyText);
            umlConstraint.setSpecification((ValueSpecification)litString);
        }
    }

    public void setOpaqueExpressionTextInUMLConstraint(Constraint umlConstraint, String formalPropertyText, String language) {
        if (umlConstraint.getSpecification() instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpr = (OpaqueExpression)umlConstraint.getSpecification();
            this.setOpaqueExpressionBodyForLanguage(opaqueExpr, language, formalPropertyText);
        }
    }

    private void setOpaqueExpressionBodyForLanguage(OpaqueExpression opaqueExpression, String language, String body) {
        this.checkAndCorrectListsOfBodyOwner((BodyOwner)opaqueExpression);
        if (!opaqueExpression.getLanguages().contains((Object)language)) {
            opaqueExpression.getLanguages().add((Object)language);
            opaqueExpression.getBodies().add((Object)body);
        } else {
            int index = opaqueExpression.getLanguages().indexOf((Object)language);
            opaqueExpression.getBodies().set(index, (Object)body);
        }
    }

    public void deleteElementInTheModel(NamedElement element) throws Exception {
        ModelExplorerView modelExplorerView = this.getModelExplorerView();
        modelExplorerView.setFocus();
        ArrayList<NamedElement> elements = new ArrayList<NamedElement>();
        elements.add(element);
        modelExplorerView.revealSemanticElement(elements);
        IHandler deleteHandler = this.getActiveHandlerFor("org.eclipse.ui.edit.delete");
        deleteHandler.execute(new ExecutionEvent());
    }

    private IHandler getActiveHandlerFor(String commandId) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
        Command cmd = commandService.getCommand(commandId);
        return cmd.getHandler();
    }

    private ModelExplorerView getModelExplorerView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart modelexplorer;
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    modelexplorer = activeWorkbenchWindow.getActivePage().showView("org.eclipse.papyrus.views.modelexplorer.modelexplorer");
                }
                catch (PartInitException ex) {
                    ex.printStackTrace(System.out);
                    return;
                }
                ModelExplorerPageBookView view = (ModelExplorerPageBookView)modelexplorer;
                ModelExplorerPage page = (ModelExplorerPage)view.getCurrentPage();
                IViewPart viewer = page.getViewer();
                EntityUtil.this.modelExplorerView = (ModelExplorerView)viewer;
            }
        });
        return this.modelExplorerView;
    }

    public void removeElement(EList<Class> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public void removeFunctionBehavior(EList<Behavior> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public void removeFunctionBehaviorParameter(EList<Parameter> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public void removeFormalProperty(EList<Constraint> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public void removeNamedElement(EList<?> members, String qualifiedElement) {
        for (Object object : members) {
            NamedElement element = (NamedElement)object;
            if (!element.getQualifiedName().equals(qualifiedElement)) continue;
            try {
                this.deleteElementInTheModel(element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            members.remove((Object)element);
            break;
        }
    }

    public void removeProperty(EList<Property> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public void removeConnector(EList<Connector> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public void removePort(EList<NamedElement> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public void removeMacroDefinition(EList<Constraint> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public Association createUmlAssociation(Class owner, String subComponentName, Type type, String[] multiplicity) {
        String associationName = DEFAULT_ASSOCIATION_NAME + (this.countPackageAssociations(owner.getNearestPackage()) + 1);
        return this.createAssociation(owner, associationName, subComponentName, type, multiplicity);
    }

    private int countPackageAssociations(Package pkg) {
        int counter = 0;
        EList namedList = pkg.getOwnedMembers();
        for (NamedElement namedElement : namedList) {
            if (!(namedElement instanceof Association)) continue;
            ++counter;
        }
        return counter;
    }

    public Association createAssociation(Class owner, String associationName, String elementName, Type elementType, String[] multiplicity) {
        logger.debug((Object)"createAssociation");
        logger.debug((Object)("\n\n\n Creating association " + associationName + " for owner " + owner));
        logger.debug((Object)("elementName = " + elementName + " with type " + elementType.getName() + " [" + multiplicity[0] + "," + multiplicity[1] + "]"));
        logger.debug((Object)"\n\n\n");
        Package package_ = owner.getNearestPackage();
        Association association = (Association)package_.createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
        Property subComponentInstance = this.buildAssociationEndInternal(association, elementName, elementType, null, true, AggregationKind.get((int)2));
        this.buildAssociationEndInternal(association, owner.getName().toLowerCase(), (Type)owner, null, false, AggregationKind.get((int)0));
        if (associationName != null) {
            association.setName(associationName);
        }
        owner.getOwnedAttributes().add((Object)subComponentInstance);
        logger.debug((Object)"createAssociation done");
        if (!this.isOneInstance(multiplicity)) {
            logger.debug((Object)"!isOneInstance");
            this.setAttributeMultiplicity((MultiplicityElement)subComponentInstance, multiplicity);
        }
        ElementUtil.addNature((Element)association, (String)"SysML_Nature");
        logger.debug((Object)("\n\nCreated " + associationName + " Association\n\n"));
        return association;
    }

    private Property buildAssociationEndInternal(Association assoc, String name, Type type, Integer[] multi, Boolean navigable, AggregationKind aggregation) {
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setType(type);
        property.setAssociation(assoc);
        if (name != null) {
            property.setName(name);
        }
        if (navigable != null) {
            property.setIsNavigable(navigable.booleanValue());
            if (!navigable.booleanValue()) {
                assoc.getOwnedEnds().add((Object)property);
            }
        }
        if (aggregation != null) {
            property.setAggregation(aggregation);
        }
        if (multi != null) {
            if (multi[0] != null) {
                property.setLower(multi[0].intValue());
            }
            if (multi[1] != null) {
                property.setUpper(multi[1].intValue());
            }
        }
        return property;
    }

    private boolean isOneInstance(String[] multiplicityBoundariesAsExpressons) {
        logger.debug((Object)"isOneInstance");
        return multiplicityBoundariesAsExpressons[0] == null && multiplicityBoundariesAsExpressons[1] == null || multiplicityBoundariesAsExpressons[0] == "" && multiplicityBoundariesAsExpressons[1] == "" || this.isEqualToOne(multiplicityBoundariesAsExpressons[0]) && this.isEqualToOne(multiplicityBoundariesAsExpressons[1]);
    }

    private boolean isEqualToOne(String expression) {
        return EntityUtil.isInteger(expression) && Integer.valueOf(expression) == 1;
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public void removeDelegationConstraint(EList<Constraint> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public boolean equalMultiplicityBoundaries(String[] newMultiplicityRange, String[] multiplicityRange) {
        logger.debug((Object)("equalMultiplicityBoundaries [0]: " + newMultiplicityRange[0] + " " + multiplicityRange[0]));
        logger.debug((Object)("equalMultiplicityBoundaries [1]: " + newMultiplicityRange[1] + " " + multiplicityRange[1]));
        boolean equalLowerValue = this.equals(newMultiplicityRange[0], multiplicityRange[0]);
        boolean equalUpperValue = this.equals(newMultiplicityRange[1], multiplicityRange[1]);
        logger.debug((Object)(String.valueOf(equalLowerValue) + " - " + equalUpperValue));
        return equalLowerValue && equalUpperValue;
    }

    private boolean equals(String text1, String text2) {
        return text1 == text2 && text2 == null || text1 != null && text2 != null && text1.equals(text2);
    }

    public void setAttributeMultiplicity(MultiplicityElement property, String[] newMultiplicityRange) {
        logger.debug((Object)("setAttributeMultiplicity: " + newMultiplicityRange[0] + " " + newMultiplicityRange[1]));
        if (newMultiplicityRange[0] != null) {
            property.setLowerValue((ValueSpecification)this.createLiteralStringWithValue(newMultiplicityRange[0]));
        } else {
            property.setLowerValue(null);
        }
        if (newMultiplicityRange[1] != null) {
            property.setUpperValue((ValueSpecification)this.createLiteralStringWithValue(newMultiplicityRange[1]));
        } else {
            property.setUpperValue(null);
        }
    }

    private LiteralString createLiteralStringWithValue(String value) {
        LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
        literalString.setValue(value);
        return literalString;
    }

    public EList<Constraint> getParameterAssumptionsAsConstraintsUml(Element umlElement) {
        BasicEList constraints = new BasicEList();
        if (this.isBlock(umlElement) || this.isCompType(umlElement) || this.isComponentImplementation(umlElement)) {
            for (Constraint umlConstraint : ((Class)umlElement).getOwnedRules()) {
                if (umlConstraint.getAppliedStereotype(PARAMETER_ASSUMPTIONS) == null) continue;
                constraints.add((Object)umlConstraint);
            }
        }
        if (this.isComponentInstance(umlElement)) {
            constraints.addAll(this.getParameterAssumptionsAsConstraintsUml(this.getUmlType((Property)umlElement)));
        }
        return constraints;
    }

    public boolean isParameterAssumptions(Element umlConstraint) {
        if (umlConstraint instanceof Constraint) {
            return umlConstraint.getAppliedStereotype(PARAMETER_ASSUMPTIONS) != null;
        }
        return false;
    }

    public Constraint createParameterAssumptions(Class owner, String parameterAssumptionsExpression, Stereotype parameterAssumptionsStereotype) {
        int numParameterAssumptions = this.getParameterAssumptionsAsConstraintsUml((Element)owner).size();
        String parameterAssumptionsName = DEFAULT_PAR_ASSUMPTION_PREFIX + (numParameterAssumptions + 1);
        logger.debug((Object)("\n\n\n Creating Parameter Assumption " + parameterAssumptionsName + " for owner " + owner));
        logger.debug((Object)"\n\n\n");
        Constraint newUMLConstraint = owner.createOwnedRule(parameterAssumptionsName);
        newUMLConstraint.applyStereotype(parameterAssumptionsStereotype);
        LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
        literalString.setName("constraintSpec");
        literalString.setValue(parameterAssumptionsExpression);
        newUMLConstraint.setSpecification((ValueSpecification)literalString);
        logger.debug((Object)("\n\nCreated " + parameterAssumptionsName + " Parameter Assumption\n\n"));
        return newUMLConstraint;
    }

    public Element createUmlConstraint(Class owner, String parameterAssumptionsText) {
        int numParameterAssumptions = this.getParameterAssumptionsAsConstraintsUml((Element)owner).size();
        String parameterAssumptionsName = DEFAULT_PAR_ASSUMPTION_PREFIX + (numParameterAssumptions + 1);
        logger.debug((Object)("\n\n\n Creating constraint " + parameterAssumptionsName + " for owner " + owner));
        logger.debug((Object)"\n\n\n");
        Constraint newUMLConstraint = owner.createOwnedRule(parameterAssumptionsName);
        LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
        literalString.setName("constraintSpec");
        literalString.setValue(parameterAssumptionsText);
        newUMLConstraint.setSpecification((ValueSpecification)literalString);
        logger.debug((Object)("\n\nCreated " + parameterAssumptionsName + " Constraint\n\n"));
        return newUMLConstraint;
    }

    public Constraint getParameterAssumptionsFromExpression(String parameterAssumptionsExpression, Class owner) {
        for (Constraint umlConstraint : owner.getOwnedRules()) {
            if (umlConstraint.getAppliedStereotype(PARAMETER_ASSUMPTIONS) == null || !this.getConstraintBodyStr(umlConstraint, null).equals(parameterAssumptionsExpression)) continue;
            return umlConstraint;
        }
        return null;
    }

    public void removeParameterAssumptions(EList<Constraint> members, String qualifiedElement) {
        this.removeNamedElement(members, qualifiedElement);
    }

    public String[] getUmlFunctionBehaviorOutputMultiplicity(FunctionBehavior uninterpretedFunction) {
        for (Parameter parameter : uninterpretedFunction.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.OUT_LITERAL) continue;
            return this.getAttributeMultiplicity((MultiplicityElement)parameter);
        }
        return null;
    }

    public EList<String[]> getUmlFunctionBehaviorInputMultiplicities(FunctionBehavior uninterpretedFunction) {
        BasicEList inputMultiplicities = new BasicEList();
        for (Parameter parameter : uninterpretedFunction.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
            inputMultiplicities.add((Object)this.getAttributeMultiplicity((MultiplicityElement)parameter));
        }
        return inputMultiplicities;
    }

    public EList<Property> getLocalProperties(Element component) {
        BasicEList localProperties = new BasicEList();
        if (this.isComponentInstance(component)) {
            component = this.getUmlType((Property)component);
        }
        if (this.isBlock(component) || this.isCompType(component) || this.isComponentImplementation(component)) {
            Class umlClass = (Class)component;
            EList attributes = umlClass.getOwnedAttributes();
            for (Property umlProperty : attributes) {
                if (umlProperty == null || this.isComponentInstance((Element)umlProperty) || this.isPort((Element)umlProperty) || ContractEntityUtil.getInstance().isContractProperty((Element)umlProperty)) continue;
                localProperties.add((Object)umlProperty);
            }
        }
        return localProperties;
    }

    public String getLocalPropertyName(Property property) {
        if (property != null) {
            return property.getName();
        }
        return null;
    }

    private String getEnumTypeValuesAsStr(Enumeration enumeration) {
        StringJoiner enumValues = new StringJoiner(", ", "[", "]");
        for (String value : this.getListValuesForEnumeratorType((Type)enumeration)) {
            enumValues.add(value);
        }
        return enumValues.toString();
    }

    public String getLocalPropertyType(Property property) {
        Type propertyType;
        if (property != null && (propertyType = property.getType()) != null) {
            if (this.isRangeType(propertyType)) {
                String[] range = this.getLowerUpperBoundsForRangeType(propertyType);
                return String.valueOf(propertyType.getName()) + " - Range [" + range[0] + " .. " + range[1] + "]";
            }
            if (this.isEnumerationType(propertyType)) {
                return String.valueOf(propertyType.getName()) + " - Enum " + this.getEnumTypeValuesAsStr((Enumeration)propertyType);
            }
            return propertyType.getName();
        }
        return null;
    }

    public Constraint createMacroDefinition(Class owner, String macroDefinitionName, String macroDefinitionExpression, Stereotype macroDefinitionStereotype) {
        logger.debug((Object)("\n\n\n Creating Macro Definition " + macroDefinitionName + " for owner " + owner));
        logger.debug((Object)"\n\n\n");
        Constraint newUMLConstraint = owner.createOwnedRule(macroDefinitionName);
        newUMLConstraint.applyStereotype(macroDefinitionStereotype);
        LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
        literalString.setName("constraintSpec");
        literalString.setValue(macroDefinitionExpression);
        newUMLConstraint.setSpecification((ValueSpecification)literalString);
        logger.debug((Object)("\n\nCreated " + macroDefinitionName + " Macro Definition\n\n"));
        return newUMLConstraint;
    }

    public void updateMacroDefinition(Constraint umlConstraint, String macroDefinitionExpression, String language) {
        String constraintExpression = this.getConstraintBodyStr(umlConstraint, language);
        if (!macroDefinitionExpression.equals(constraintExpression)) {
            this.setLiteralStringTextInUMLConstraint(umlConstraint, macroDefinitionExpression);
        }
    }

    public Class getSystemElement(Model model) throws Exception {
        TreeIterator allElements;
        if (model != null && (allElements = model.eResource().getAllContents()) != null) {
            Collection classes = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getClass_());
            for (Class c : classes) {
                if (c.getAppliedStereotype(SYSTEM) == null) continue;
                return c;
            }
        }
        return null;
    }

    public Class getSystemComponent(Package pkg) {
        boolean found = false;
        Element systemElement = null;
        if (pkg != null) {
            EList ownedElements = pkg.getOwnedElements();
            for (Element element : ownedElements) {
                if (element.getAppliedStereotype(SYSTEM) == null) continue;
                if (!found) {
                    systemElement = element;
                    found = true;
                    continue;
                }
                return null;
            }
        }
        if (found) {
            return (Class)systemElement;
        }
        return null;
    }

    public EList<String> getParametersListFromInstantiatedArchitectureConfiguration(InstantiatedArchitectureConfiguration instantiatedArchitectureConfiguration) {
        return instantiatedArchitectureConfiguration.getParameterList();
    }

    public EList<Operation> getUmlOperations(Element umlElement) {
        if (this.isComponentInstance(umlElement)) {
            umlElement = ((Property)umlElement).getType();
        }
        if (umlElement instanceof Class) {
            Class umlClass = (Class)umlElement;
            return umlClass.getOwnedOperations();
        }
        return null;
    }

    public EList<Operation> getUmlOperations(Element umlElement, String language) {
        BasicEList operations = null;
        if (this.isComponentInstance(umlElement)) {
            umlElement = ((Property)umlElement).getType();
        }
        if (umlElement instanceof Class) {
            Class umlClass = (Class)umlElement;
            if (!umlClass.getOwnedOperations().isEmpty()) {
                operations = new BasicEList();
            }
            for (Operation operation : umlClass.getOwnedOperations()) {
                if (this.getUmlOperationBody(operation, language) == null) continue;
                operations.add((Object)operation);
            }
        }
        return operations;
    }

    public String getUmlOperationName(Operation operation) {
        return operation.getName();
    }

    public EList<?> getUmlOperationInputTypes(Operation operation) {
        BasicEList inputTypes = new BasicEList();
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
            inputTypes.add((Object)parameter.getType());
        }
        return inputTypes;
    }

    public String getUmlOperationBody(Operation operation, String language) {
        if (!operation.getMethods().isEmpty()) {
            Behavior behavior = (Behavior)operation.getMethods().get(0);
            if (behavior instanceof OpaqueBehavior) {
                return this.getOpaqueBehaviorBody((OpaqueBehavior)behavior, language);
            }
            if (behavior instanceof FunctionBehavior) {
                return this.getFunctionBehaviorBody((FunctionBehavior)behavior, language);
            }
        }
        return null;
    }

    public Type getUmlOperationOutputType(Operation operation) {
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            return parameter.getType();
        }
        return null;
    }

    public String getFunctionBehaviorBody(FunctionBehavior functionBehavior, String language) {
        return this.getBodyForLanguageOfBodyOwner((BodyOwner)functionBehavior, language);
    }

    public String getOpaqueBehaviorBody(OpaqueBehavior opaqueBehavior, String language) {
        return this.getBodyForLanguageOfBodyOwner((BodyOwner)opaqueBehavior, language);
    }

    public String getBodyForLanguageOfBodyOwner(BodyOwner bodyOwner, String language) {
        String body = null;
        if (language == null) {
            if (!bodyOwner.getBodies().isEmpty()) {
                body = (String)bodyOwner.getBodies().get(0);
            }
        } else {
            int index = bodyOwner.getLanguages().indexOf((Object)language);
            if (index != -1 && index < bodyOwner.getBodies().size()) {
                body = (String)bodyOwner.getBodies().get(index);
            }
        }
        return body;
    }

    public void setBodyForLanguageOfBodyOwner(BodyOwner bodyOwner, String language, String body) {
        this.checkAndCorrectListsOfBodyOwner(bodyOwner);
        if (!bodyOwner.getLanguages().contains((Object)language)) {
            bodyOwner.getLanguages().add((Object)language);
            bodyOwner.getBodies().add((Object)body);
        } else {
            int index = bodyOwner.getLanguages().indexOf((Object)language);
            bodyOwner.getBodies().set(index, (Object)body);
        }
    }

    private boolean checkAndCorrectListsOfBodyOwner(BodyOwner bodyOwner) {
        int languageSize;
        int bodySize = bodyOwner.getBodies().size();
        if (bodySize == (languageSize = bodyOwner.getLanguages().size())) {
            return true;
        }
        int difference = languageSize - bodySize;
        if (difference > 0) {
            int i = 0;
            while (i < difference) {
                bodyOwner.getBodies().add((Object)"");
                ++i;
            }
        } else {
            int i = 0;
            while (i < -difference) {
                bodyOwner.getLanguages().add((Object)"");
                ++i;
            }
        }
        return false;
    }

    public EList<Property> getBlockTypeAttributes(Class blockAsClass) {
        BasicEList attributes = new BasicEList();
        for (Property umlProperty : blockAsClass.getOwnedAttributes()) {
            if (this.isPort((Element)umlProperty) || !this.isBlockTypeAttribute(umlProperty)) continue;
            attributes.add((Object)umlProperty);
        }
        return attributes;
    }

    public String getAttributeVisibility(Property attribute) {
        return attribute.getVisibility().getName();
    }

    public boolean isBlockTypeAttribute(String attributeName, Class blockAsClass) {
        if (blockAsClass != null) {
            for (Property umlProperty : blockAsClass.getOwnedAttributes()) {
                if (this.isPort((Element)umlProperty) || !this.isBlockTypeAttribute(umlProperty) || !umlProperty.getName().equals(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBlockTypeAttribute(Property umlProperty) {
        return umlProperty.getType() != null && this.isBlock((Element)umlProperty.getType());
    }

    public Class getBlockType(Package currPackage, String blockName, boolean ignoreCase) {
        PackageableElement element = currPackage.getPackagedElement(blockName, ignoreCase, UMLPackage.eINSTANCE.getClass_(), false);
        if (this.isBlock((Element)element)) {
            return (Class)element;
        }
        return null;
    }

    public Class getAttributeBlockType(String attributeName, Class block) {
        for (Property property : block.getAttributes()) {
            if (!property.getName().equals(attributeName) || !this.isBlockTypeAttribute(property)) continue;
            return (Class)property.getType();
        }
        return null;
    }

    public Type getOperationType(String operationName, Class block) {
        Operation operation = this.getOperation(operationName, block);
        if (operation != null) {
            return this.getUmlOperationOutputType(operation);
        }
        return null;
    }

    public Operation getOperation(String operationName, Class block) {
        return block.getOwnedOperation(operationName, null, null);
    }

    public Property getProperty(String propertyName, Class block) {
        return block.getOwnedAttribute(propertyName, null);
    }

    public EList<Property> getProperties(Class block) {
        return block.getOwnedAttributes();
    }

    public boolean isAttribute(String attributeName, Class blockAsClass) {
        Property umlProperty;
        return blockAsClass != null && (umlProperty = blockAsClass.getOwnedAttribute(attributeName, null)) != null && !this.isPort((Element)umlProperty);
    }

    public boolean isOperation(String operationName, Class blockAsClass) {
        Operation umlOperation;
        return blockAsClass != null && (umlOperation = blockAsClass.getOwnedOperation(operationName, null, null)) != null;
    }

    public boolean containsEnumeration(Package currPackage, boolean searchInNestedPackages) {
        EList types = currPackage.getOwnedTypes();
        for (Type type : types) {
            if (!(type instanceof Enumeration)) continue;
            return true;
        }
        if (searchInNestedPackages) {
            for (Package nestedPackage : currPackage.getNestedPackages()) {
                if (!this.containsEnumeration(nestedPackage, searchInNestedPackages)) continue;
                return true;
            }
        }
        return false;
    }

    public Type getAttributeType(String attributeName, Class block) {
        for (Property property : block.getAttributes()) {
            if (!property.getName().equals(attributeName)) continue;
            return property.getType();
        }
        return null;
    }

    public Type getParameterType(int paramIndex, String methodName, Class retrieveBlockType) {
        Parameter par;
        EList params;
        Operation operation = this.getOperation(methodName, retrieveBlockType);
        if (operation != null && operation.inputParameters() != null && !(params = operation.inputParameters()).isEmpty() && (par = (Parameter)params.get(paramIndex)) != null) {
            return par.getType();
        }
        return null;
    }

    public String getCallEventOperationName(Trigger trigger) {
        if (trigger.getEvent() instanceof CallEvent) {
            return ((CallEvent)trigger.getEvent()).getOperation().getName();
        }
        return null;
    }

    public Collection<CallEvent> getAllCallEvent(Class currBlock) {
        Model model = currBlock.getModel();
        TreeIterator allElements = model.eResource().getAllContents();
        if (allElements != null) {
            Collection callEvents = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getCallEvent());
            return callEvents;
        }
        return null;
    }

    public String getCallEventOperationName(CallEvent callEvent) throws Exception {
        if (callEvent.getOperation() != null) {
            return callEvent.getOperation().getName();
        }
        throw new Exception("The callEvent " + callEvent.getQualifiedName() + " has no associated operation");
    }

    public EList<String> getOperationsNames(Class component) {
        BasicEList operationsNames = new BasicEList();
        for (Operation operation : component.getOwnedOperations()) {
            String operationName = operation.getName();
            operationsNames.add((Object)operationName);
        }
        return operationsNames;
    }

    public EList<String> getAttributesNames(Class component) {
        BasicEList attributesNames = new BasicEList();
        for (Property attribute : component.getOwnedAttributes()) {
            String attributeName = attribute.getName();
            if (this.isPort((Element)attribute)) continue;
            attributesNames.add((Object)attributeName);
        }
        return attributesNames;
    }

    public EList<Parameter> getOperationParameters(String operationName, Class parentClass) {
        Operation op = parentClass.getOwnedOperation(operationName, null, null);
        if (op != null) {
            return op.getOwnedParameters();
        }
        return null;
    }

    public Operation getCallEventOperation(CallEvent callEvent) throws Exception {
        if (callEvent.getOperation() != null) {
            return callEvent.getOperation();
        }
        throw new Exception("The callEvent " + callEvent.getQualifiedName() + " has no associated operation");
    }

    public EList<String> getParametersNames(Operation operation) {
        BasicEList parametersNames = new BasicEList();
        for (Parameter par : operation.getOwnedParameters()) {
            parametersNames.add((Object)par.getName());
        }
        return parametersNames;
    }

    public Object getParameterType(String paramName, String methodName, Class retrieveBlockType) {
        Parameter par;
        Operation operation = this.getOperation(methodName, retrieveBlockType);
        if (operation != null && operation.inputParameters() != null && (par = operation.getOwnedParameter(paramName, null)) != null) {
            return par.getType();
        }
        return null;
    }

    public List<String> getMethodArgumentNames(String methodName, Class retrieveBlockType) {
        ArrayList<String> args = new ArrayList<String>();
        Operation operation = this.getOperation(methodName, retrieveBlockType);
        if (operation != null && operation.inputParameters() != null) {
            for (Parameter par : operation.inputParameters()) {
                args.add(par.getName());
            }
        }
        return args;
    }

    public Collection<Enumeration> getAllEnumeratives(Package packageElement) throws Exception {
        return EObjectUtil.getAllElements((EClass)UMLPackage.eINSTANCE.getEnumeration(), (EObject)packageElement);
    }

    public Collection<Class> getAllClasses(Package packageElement) throws Exception {
        Collection classElements = null;
        if (packageElement != null) {
            TreeIterator allElements = packageElement.eResource().getAllContents();
            if (allElements != null) {
                classElements = EntityUtil.getClassObjects(this.iterator2Collection((Iterator)allElements));
            }
            return classElements;
        }
        throw new Exception("Element does not exist.");
    }

    public Object getParameterType(String paramName, Operation operation) {
        Parameter par;
        if (operation != null && operation.inputParameters() != null && (par = operation.getOwnedParameter(paramName, null)) != null) {
            return par.getType();
        }
        return null;
    }

    public Collection<Operation> getAllOperations(Package packageElement) throws Exception {
        if (packageElement != null) {
            TreeIterator allElements = packageElement.eResource().getAllContents();
            Collection operations = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getOperation());
            return operations;
        }
        throw new Exception("Element does not exist.");
    }

    public static <T> Collection<T> getClassObjects(Collection<EObject> objects) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject object : objects) {
            if (!UMLPackage.eINSTANCE.getClass_().isInstance((Object)object) || !(object.eContainer() instanceof Package)) continue;
            EObject t = object;
            result.add(t);
        }
        return result;
    }

    public boolean isVisibilityPrivate(NamedElement e) throws Exception {
        if (e.isSetVisibility()) {
            return e.getVisibility() == VisibilityKind.PRIVATE_LITERAL;
        }
        throw new Exception("Element does not have any visibility");
    }

    public boolean isVisibilityProtected(NamedElement e) throws Exception {
        if (e.isSetVisibility()) {
            return e.getVisibility() == VisibilityKind.PROTECTED_LITERAL;
        }
        throw new Exception("Element does not have any visibility");
    }

    public boolean isVisibilityPublic(NamedElement e) throws Exception {
        if (e.isSetVisibility()) {
            return e.getVisibility() == VisibilityKind.PUBLIC_LITERAL;
        }
        throw new Exception("Element does not have any visibility");
    }

    public EList<Element> getAllPackageElements(Package pkg) {
        return pkg.allOwnedElements();
    }

    public List<String> getClassNames(List<?> classes) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object block : classes) {
            if (!(block instanceof Class)) continue;
            names.add(((Class)block).getName());
        }
        return names;
    }

    public Block getTriggeredBlock(Event event) {
        Block res = null;
        Stereotype functionTriggerEventStereotype = UMLUtil.getAppliedStereotype((Element)event, (String)FUNCTION_TRIGGER_EVENT, (boolean)false);
        FunctionTriggerEvent functionTriggerEvent = (FunctionTriggerEvent)event.getStereotypeApplication(functionTriggerEventStereotype);
        if (functionTriggerEvent != null) {
            res = functionTriggerEvent.getTriggeredBlock();
        }
        return res;
    }

    public EList<TimeEvent> getTimeEvents(Element component) {
        if (this.isComponentInstance(component)) {
            component = this.getUmlType((Property)component);
        }
        BasicEList events = new BasicEList();
        TreeIterator allElements = component.eResource().getAllContents();
        if (allElements != null) {
            Collection changeEventElements = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getTimeEvent());
            for (EObject element : changeEventElements) {
                if (!(element instanceof TimeEvent) || !component.equals(this.getTriggeredBlock((Event)((TimeEvent)element)).getBase_Class())) continue;
                events.add((Object)((TimeEvent)element));
            }
        }
        return events;
    }

    public EList<ChangeEvent> getChangeEvents(Element component) {
        if (this.isComponentInstance(component)) {
            component = this.getUmlType((Property)component);
        }
        BasicEList events = new BasicEList();
        TreeIterator allElements = component.eResource().getAllContents();
        if (allElements != null) {
            Collection changeEventElements = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getChangeEvent());
            for (EObject element : changeEventElements) {
                if (!(element instanceof ChangeEvent) || !component.equals(this.getTriggeredBlock((Event)((ChangeEvent)element)).getBase_Class())) continue;
                events.add((Object)((ChangeEvent)element));
            }
        }
        return events;
    }

    public String getPeriod(TimeEvent event) {
        ValueSpecification expr = event.getWhen().getExpr();
        return this.getValueSpecificationValue(expr, "OCRA");
    }

    public String getChangeExpression(ChangeEvent event) {
        ValueSpecification expr = event.getChangeExpression();
        return this.getValueSpecificationValue(expr, "OCRA");
    }
}

