/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagram.ui.services;

import eu.fbk.eclipse.standardtools.diagram.ContainerDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContractFtaResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContractImplementationResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContractRefinementResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.DocumentGenerator;
import eu.fbk.eclipse.standardtools.diagram.FmeaResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.FtaResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ModelCheckingResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.PropertyValidationResultDescriptor;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import eu.fbk.tools.adapter.nusmv.CounterExample;
import eu.fbk.tools.adapter.nuxmv.CheckBehaviourResultBuilder;
import eu.fbk.tools.adapter.ocra.CheckContractResultBuilder;
import eu.fbk.tools.adapter.ocra.OcraOutput;
import eu.fbk.tools.adapter.results.CheckResult;
import eu.fbk.tools.adapter.results.ContractCheckResult;
import eu.fbk.tools.adapter.results.ContractPropertyValidationResult;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.xsap.ComputeFmeaTableResultBuilder;
import eu.fbk.tools.adapter.xsap.table.FmeaTable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.AnalysisContextElement;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;

public class ResultsGeneratorService {
    private static final Logger logger = Logger.getLogger(ResultsGeneratorService.class);
    private AnalysisResultUtil analysisResultUtil = AnalysisResultUtil.getInstance();
    private boolean showAnalysisResults;
    private String outputDirectoryName;
    private String imageExtension;

    public void setParametersBeforeDocumentGeneration(String outputDirectoryName, boolean showAnalysisResults, String imageExtension) {
        this.outputDirectoryName = outputDirectoryName;
        this.showAnalysisResults = showAnalysisResults;
        this.imageExtension = imageExtension;
    }

    private FmeaResultDescriptor createFmeaResultDescriptor(AnalysisContextElement resultElement) {
        FmeaResultDescriptor fmeaResultDescriptor = new FmeaResultDescriptor();
        fmeaResultDescriptor.conditions = (String)resultElement.getConditions().get(0);
        fmeaResultDescriptor.rootClass = EntityUtil.getInstance().getName(resultElement.getRoot());
        ComputeFmeaTableResultBuilder resultBuilder = new ComputeFmeaTableResultBuilder();
        FmeaTable fmeaTable = resultBuilder.unmarshalResult(resultElement.getResult());
        if (fmeaTable == null || fmeaTable.getRow() == null || fmeaTable.getRow().isEmpty()) {
            logger.debug((Object)"Internal error while unmarshalling the result. For more info see the console");
            return null;
        }
        List rows = fmeaTable.getRow();
        for (FmeaTable.Row row : rows) {
            String[] line = new String[]{row.getEntry(), row.getFailureMode(), row.getFailureEffects()};
            fmeaResultDescriptor.lines.add(line);
        }
        return fmeaResultDescriptor;
    }

    private ContractRefinementResultDescriptor createContractRefinementResultDescriptor(AnalysisContextElement resultElement) {
        ContractRefinementResultDescriptor contractRefinementResultDescriptor = new ContractRefinementResultDescriptor();
        contractRefinementResultDescriptor.rootClass = EntityUtil.getInstance().getName(resultElement.getRoot());
        CheckContractResultBuilder resultBuilder = new CheckContractResultBuilder();
        OcraOutput ocraOutput = resultBuilder.unmarshalResult(resultElement.getResult());
        if (ocraOutput == null || ocraOutput.getOcraResult() == null || ocraOutput.getOcraResult().isEmpty()) {
            logger.debug((Object)"Error while unmarshalling the result. For more info see the console");
            return null;
        }
        ModelCheckResult contractCheckResult = resultBuilder.buildResult(ocraOutput);
        if (contractCheckResult == null) {
            logger.debug((Object)"Internal error while building the result. For more info see the console");
            return null;
        }
        EList contractCheckResults = contractCheckResult.getContractCheckResults();
        for (ContractCheckResult result : contractCheckResults) {
            if (!result.getCheckType().equals("ocra_check_refinement")) continue;
            String[] line = new String[]{"[" + result.getComponentType() + "] " + result.getContractName(), result.getFailed() != false ? "NOT OK" : "Success"};
            contractRefinementResultDescriptor.lines.add(line);
        }
        return contractRefinementResultDescriptor;
    }

    private ContractImplementationResultDescriptor createContractImplementationResultDescriptor(AnalysisContextElement resultElement) {
        ContractImplementationResultDescriptor contractImplementationResultDescriptor = new ContractImplementationResultDescriptor();
        contractImplementationResultDescriptor.rootClass = EntityUtil.getInstance().getName(resultElement.getRoot());
        CheckContractResultBuilder resultBuilder = new CheckContractResultBuilder();
        OcraOutput ocraOutput = resultBuilder.unmarshalResult(resultElement.getResult());
        if (ocraOutput == null || ocraOutput.getOcraResult() == null || ocraOutput.getOcraResult().isEmpty()) {
            logger.error((Object)"Error while unmarshalling the result. For more info see the console");
            return null;
        }
        ModelCheckResult contractCheckResult = resultBuilder.buildResult(ocraOutput);
        if (contractCheckResult == null) {
            logger.error((Object)"Internal error while building the result. For more info see the console");
            return null;
        }
        EList contractCheckResults = contractCheckResult.getContractCheckResults();
        for (ContractCheckResult result : contractCheckResults) {
            if (!result.getCheckType().equals("ocra_check_refinement") && !result.getCheckType().equals("ocra_check_implementation")) continue;
            String[] line = new String[]{"[" + result.getComponentType() + "] " + result.getContractName(), result.getFailed() != false ? "NOT OK" : "Success"};
            contractImplementationResultDescriptor.lines.add(line);
        }
        return contractImplementationResultDescriptor;
    }

    private PropertyValidationResultDescriptor createPropertyValidationResultDescriptor(AnalysisContextElement resultElement) {
        CheckContractResultBuilder resultBuilder;
        OcraOutput ocraOutput;
        PropertyValidationResultDescriptor propertyValidationResultDescriptor = new PropertyValidationResultDescriptor();
        propertyValidationResultDescriptor.rootClass = EntityUtil.getInstance().getName(resultElement.getRoot());
        EList conditions = resultElement.getConditions();
        propertyValidationResultDescriptor.validationType = StringArrayUtil.getConditionValue((EList)conditions, (String)"check_type");
        if (StringArrayUtil.getConditionValue((EList)conditions, (String)"selected_components") != null) {
            propertyValidationResultDescriptor.selectedComponent = StringArrayUtil.getConditionValue((EList)conditions, (String)"selected_components");
        }
        if (StringArrayUtil.getConditionValue((EList)conditions, (String)"selected_properties") != null) {
            propertyValidationResultDescriptor.selectedProperties = StringArrayUtil.getConditionValue((EList)conditions, (String)"selected_properties").replace(",", ", ");
        }
        if (StringArrayUtil.getConditionValue((EList)conditions, (String)"property") != null) {
            propertyValidationResultDescriptor.conditions = StringArrayUtil.getConditionValue((EList)conditions, (String)"property");
        }
        if ((ocraOutput = (resultBuilder = new CheckContractResultBuilder()).unmarshalResult(resultElement.getResult())) == null || ocraOutput.getOcraResult() == null || ocraOutput.getOcraResult().isEmpty()) {
            logger.error((Object)"Error while unmarshalling the result. For more info see the console");
            return null;
        }
        ModelCheckResult contractCheckResult = resultBuilder.buildResult(ocraOutput);
        if (contractCheckResult == null) {
            logger.error((Object)"Internal error while building the result. For more info see the console");
            return null;
        }
        EList propertyValidationResults = contractCheckResult.getPropertyValidationResults();
        for (ContractPropertyValidationResult result : propertyValidationResults) {
            String checkValue;
            EList checkResults;
            if (!result.getCheckType().contains("ocra_check_validation_prop") || (checkResults = result.getCheckResults()).size() <= 0) continue;
            String[] line = new String[]{"[" + result.getName() + "]", (checkValue = ((CheckResult)checkResults.get(0)).getValue()).equals("OK") ? "Success" : (checkValue.equals("NOT_OK") ? "NOT OK" : (checkValue.equals("UNKNOWN") ? "Unknown" : checkValue))};
            propertyValidationResultDescriptor.lines.add(line);
        }
        return propertyValidationResultDescriptor;
    }

    private ModelCheckingResultDescriptor createModelCheckingResultDescriptor(AnalysisContextElement resultElement) {
        ModelCheckingResultDescriptor modelCheckingResultDescriptor = new ModelCheckingResultDescriptor();
        modelCheckingResultDescriptor.rootClass = EntityUtil.getInstance().getName(resultElement.getRoot());
        EList conditions = resultElement.getConditions();
        modelCheckingResultDescriptor.checkType = StringArrayUtil.getConditionValue((EList)conditions, (String)"check_type");
        if (StringArrayUtil.getConditionValue((EList)conditions, (String)"property") != null) {
            modelCheckingResultDescriptor.conditions = StringArrayUtil.getConditionValue((EList)conditions, (String)"property");
        }
        if (resultElement.getResult() == null) {
            modelCheckingResultDescriptor.result = "Success";
            return modelCheckingResultDescriptor;
        }
        CheckBehaviourResultBuilder resultBuilder = new CheckBehaviourResultBuilder();
        CounterExample counterExample = resultBuilder.unmarshalResult(resultElement.getResult());
        if (counterExample == null || counterExample.getDesc() == null || counterExample.getId() == null || counterExample.getNode() == null) {
            logger.error((Object)"Internal error while processing the result. For more info see the console");
            return null;
        }
        modelCheckingResultDescriptor.result = "NOT OK";
        return modelCheckingResultDescriptor;
    }

    private String getEmftaFile(String fullPath) {
        String emftaFile = fullPath.substring(fullPath.lastIndexOf(File.separator) + 1, fullPath.length());
        return String.valueOf(emftaFile) + ".emfta";
    }

    private String removeExtension(String fileName) {
        return fileName.substring(0, fileName.indexOf("."));
    }

    private String exportSiriusDiagramToFile(String diagramPath) {
        Collection s = SessionUIManager.INSTANCE.getUISessions();
        for (IEditingSession iEditingSession : s) {
            Session openSession = iEditingSession.getSession();
            openSession.save((IProgressMonitor)new NullProgressMonitor());
        }
        String currentPath = "";
        try {
            currentPath = DirectoryUtil.getInstance().getCurrentProjectDir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        URI sessionResourceURI = URI.createFileURI((String)(String.valueOf(currentPath) + File.separator + "representations.aird"));
        Session session = null;
        try {
            session = SessionFactory.INSTANCE.createSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            logger.error((Object)"Error in creating session for sirius diagram export");
            return "notFound.gif";
        }
        session.open((IProgressMonitor)new NullProgressMonitor());
        String diagramName = this.getEmftaFile(diagramPath);
        ArrayList<DRepresentation> myRepresentations = new ArrayList<DRepresentation>();
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        for (DRepresentation dRepresentation : allRepresentations) {
            if (!dRepresentation.getName().equals(diagramName)) continue;
            logger.debug((Object)("\nfound the requested representation: " + diagramName));
            myRepresentations.add(dRepresentation);
        }
        if (myRepresentations.size() != 0) {
            String fileName = String.valueOf(this.outputDirectoryName) + File.separator + this.removeExtension(diagramName);
            String extension = this.imageExtension.equals(".svg") ? this.imageExtension : ".png";
            fileName = String.valueOf(fileName) + extension;
            ExportFormat exportFormat = null;
            exportFormat = extension.equals(".svg") ? new ExportFormat(ExportFormat.ExportDocumentFormat.NONE, ImageFileFormat.SVG) : new ExportFormat(ExportFormat.ExportDocumentFormat.NONE, ImageFileFormat.PNG);
            try {
                DialectUIManager.INSTANCE.export((DRepresentation)myRepresentations.get(0), session, (IPath)new Path(fileName), exportFormat, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (SizeTooLargeException sizeTooLargeException) {
                logger.error((Object)"Sirius diagram too large for export");
                return "notFound.gif";
            }
            return String.valueOf(this.removeExtension(diagramName)) + extension;
        }
        logger.error((Object)"No sirius diagram found for export");
        return "notFound.gif";
    }

    private FtaResultDescriptor createFtaResultDescriptor(AnalysisContextElement resultElement) {
        FtaResultDescriptor ftaResultDescriptor = new FtaResultDescriptor();
        ftaResultDescriptor.conditions = (String)resultElement.getConditions().get(0);
        ftaResultDescriptor.rootClass = EntityUtil.getInstance().getName(resultElement.getRoot());
        ftaResultDescriptor.url = "notFound.gif";
        ftaResultDescriptor.url = this.exportSiriusDiagramToFile(resultElement.getResult());
        return ftaResultDescriptor;
    }

    private ContractFtaResultDescriptor createContractFtaResultDescriptor(AnalysisContextElement resultElement) {
        ContractFtaResultDescriptor contractFtaResultDescriptor = new ContractFtaResultDescriptor();
        contractFtaResultDescriptor.rootClass = EntityUtil.getInstance().getName(resultElement.getRoot());
        contractFtaResultDescriptor.url = this.exportSiriusDiagramToFile(resultElement.getResult());
        return contractFtaResultDescriptor;
    }

    public void addResultsDescriptors(Class selectedComponent, Package activePackage, DocumentGenerator documentGenerator) {
        if (selectedComponent != EntityUtil.getInstance().getSystemComponent(activePackage)) {
            logger.debug((Object)"The selected element is not the System element, results section won't be created");
            return;
        }
        if (!this.showAnalysisResults) {
            return;
        }
        ContainerDescriptor rootContainer = documentGenerator.getRootContainerDescriptor();
        rootContainer.showAnalysisResults = this.showAnalysisResults;
        Package dependabilityView = this.analysisResultUtil.getDependabilityViewFromPackage(activePackage);
        if (dependabilityView == null) {
            return;
        }
        Package resultsPackage = dependabilityView.getNestedPackage(this.analysisResultUtil.getPackageName(activePackage));
        if (resultsPackage == null) {
            return;
        }
        EList members = resultsPackage.getOwnedMembers();
        boolean isRefinementPresent = false;
        for (NamedElement namedElement : members) {
            AnalysisContextElement resultElement = this.analysisResultUtil.getAnalysisContextElementFromUmlElement((Element)namedElement);
            if (resultElement == null) continue;
            Analysis resultType = resultElement.getType();
            if (resultType.equals((Object)Analysis.FMEA_ANALYSIS)) {
                FmeaResultDescriptor fmeaResultDescriptor = this.createFmeaResultDescriptor(resultElement);
                rootContainer.fmeaResultDescriptors.add(fmeaResultDescriptor);
                continue;
            }
            if (resultType.equals((Object)Analysis.FTA_ANALYSIS)) {
                FtaResultDescriptor ftaResultDescriptor = this.createFtaResultDescriptor(resultElement);
                rootContainer.ftaResultDescriptors.add(ftaResultDescriptor);
                continue;
            }
            if (resultType.equals((Object)Analysis.CONTRACT_BASED_FTA_ANALYSIS)) {
                ContractFtaResultDescriptor contractFtaResultDescriptor = this.createContractFtaResultDescriptor(resultElement);
                rootContainer.contractFtaResultDescriptors.add(contractFtaResultDescriptor);
                continue;
            }
            if (resultType.equals((Object)Analysis.CONTRACT_REFINEMENT_ANALYSIS)) {
                ContractRefinementResultDescriptor contractRefinementResultDescriptor = this.createContractRefinementResultDescriptor(resultElement);
                rootContainer.contractRefinementResultDescriptors.clear();
                rootContainer.contractRefinementResultDescriptors.add(contractRefinementResultDescriptor);
                isRefinementPresent = true;
                continue;
            }
            if (resultType.equals((Object)Analysis.CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS)) {
                ContractImplementationResultDescriptor contractImplementationResultDescriptor = this.createContractImplementationResultDescriptor(resultElement);
                rootContainer.contractImplementationResultDescriptors.add(contractImplementationResultDescriptor);
                if (isRefinementPresent) continue;
                ContractRefinementResultDescriptor contractRefinementResultDescriptor = this.createContractRefinementResultDescriptor(resultElement);
                rootContainer.contractRefinementResultDescriptors.clear();
                rootContainer.contractRefinementResultDescriptors.add(contractRefinementResultDescriptor);
                continue;
            }
            if (resultType.equals((Object)Analysis.PROPERTY_VALIDATION_ANALYSIS)) {
                PropertyValidationResultDescriptor propertyValidationResultDescriptor = this.createPropertyValidationResultDescriptor(resultElement);
                rootContainer.propertyValidationResultDescriptors.add(propertyValidationResultDescriptor);
                continue;
            }
            if (resultType.equals((Object)Analysis.CONTRACT_PROPERTY_VALIDATION_ANALYSIS)) {
                PropertyValidationResultDescriptor contractPropertyValidationResultDescriptor = this.createPropertyValidationResultDescriptor(resultElement);
                rootContainer.contractPropertyValidationResultDescriptors.add(contractPropertyValidationResultDescriptor);
                continue;
            }
            if (!resultType.equals((Object)Analysis.MODEL_CHECKING_ANALYSIS)) continue;
            ModelCheckingResultDescriptor modelCheckingResultDescriptor = this.createModelCheckingResultDescriptor(resultElement);
            rootContainer.modelCheckingResultDescriptors.add(modelCheckingResultDescriptor);
        }
    }
}

