/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flamm;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.chess.fla.flamm.Component;
import org.polarsys.chess.fla.flamm.Failure;
import org.polarsys.chess.fla.flamm.FlammPackage;
import org.polarsys.chess.fla.flamm.Port;
import org.polarsys.chess.fla.flamm.PortFailureTuple;
import org.polarsys.chess.fla.flamm.Rule;
import org.polarsys.chess.fla.flamm.analysis.FlaSystem;

public class SimpleComponent
extends Component {
    protected EList<Rule> rules;
    List<Set<PortFailureTuple>> propagatedInputPortFailures = null;

    @Override
    protected EClass eStaticClass() {
        return FlammPackage.Literals.SIMPLE_COMPONENT;
    }

    public List<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new EObjectContainmentEList(Rule.class, (InternalEObject)this, 5);
        }
        return this.rules;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getRules()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    private List<Set<PortFailureTuple>> getPropagatedInputPortFailures() {
        if (this.propagatedInputPortFailures == null) {
            this.propagatedInputPortFailures = new ArrayList<Set<PortFailureTuple>>();
            int i = 0;
            while (i < this.getInputPorts().size()) {
                this.propagatedInputPortFailures.add(new HashSet());
                ++i;
            }
        }
        return this.propagatedInputPortFailures;
    }

    @Override
    public void propagateFailures() {
        this.propagateInputFailures();
        this.propagateOutputFailures();
    }

    void propagateInputFailures() {
        int i = 0;
        while (i < this.inputPorts.size()) {
            Port port = (Port)((Object)this.inputPorts.get(i));
            Set<PortFailureTuple> newPortFailures = PortFailureTuple.fromCollection(port, port.getNewFailures());
            Set<PortFailureTuple> oldPortFailures = this.getPropagatedInputPortFailures().get(i);
            this.propagatedInputPortFailures.set(i, newPortFailures);
            Set<List<PortFailureTuple>> newFailureCombinations = this.getNewInputFailureCombinations(this.propagatedInputPortFailures);
            for (List<PortFailureTuple> portFailureCombination : newFailureCombinations) {
                this.propagateFailureCombination(portFailureCombination);
            }
            port.clearNewFailures();
            this.propagatedInputPortFailures.set(i, (Set<PortFailureTuple>)Sets.union(oldPortFailures, newPortFailures));
            ++i;
        }
    }

    protected void propagateOutputFailures() {
        for (Port port : this.outputPorts) {
            for (Failure failure : port.getNewFailures()) {
                for (Port connectedPort : port.getConnectedPorts()) {
                    if (!connectedPort.addFailure(failure, failure)) continue;
                    FlaSystem.addUpdatedComponent(connectedPort.getOwner());
                }
            }
            port.clearNewFailures();
        }
    }

    Set<List<PortFailureTuple>> getNewInputFailureCombinations(List<Set<PortFailureTuple>> failures) {
        Set failureCombinations = Sets.cartesianProduct(failures);
        return failureCombinations;
    }

    void propagateFailureCombination(List<PortFailureTuple> failuresetToMatch) {
        List<Rule> rules = this.getMostSpecificMatchingRules(failuresetToMatch);
        if (rules != null && !rules.isEmpty()) {
            List<Failure> previousFailures = this.portfailuresToFailureList(failuresetToMatch);
            for (Rule rule : rules) {
                rule.fire(previousFailures);
            }
        } else {
            this.HandleUnmatchedFailureCombination(failuresetToMatch);
        }
    }

    List<Failure> portfailuresToFailureList(List<PortFailureTuple> failureSet) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (PortFailureTuple portFailure : failureSet) {
            failures.add(portFailure.getFailure());
        }
        return failures;
    }

    protected void HandleUnmatchedFailureCombination(List<PortFailureTuple> failuresetToMatch) {
        if (FlaSystem.propagateUnmatchedFailures()) {
            for (Port port : this.outputPorts) {
                for (PortFailureTuple portFailure : failuresetToMatch) {
                    port.addFailure(portFailure.getFailure(), portFailure.getFailure());
                }
            }
        } else {
            this.log("Unmatched failure set: " + failuresetToMatch);
        }
    }

    List<Rule> getMostSpecificMatchingRules(List<PortFailureTuple> failuresetToMatch) {
        List<Rule> matchingRules = this.getAllMatchingRules(failuresetToMatch);
        if (matchingRules == null || matchingRules.isEmpty()) {
            return null;
        }
        int highestSpecificity = matchingRules.get(0).getSpecificity();
        for (Rule matchingRule : matchingRules) {
            if (matchingRule.getSpecificity() <= highestSpecificity) continue;
            highestSpecificity = matchingRule.getSpecificity();
        }
        ArrayList<Rule> mostSpecificRules = new ArrayList<Rule>();
        for (Rule matchingRule : matchingRules) {
            if (matchingRule.getSpecificity() != highestSpecificity) continue;
            mostSpecificRules.add(matchingRule);
        }
        return mostSpecificRules;
    }

    List<Rule> getAllMatchingRules(List<PortFailureTuple> failuresetToMatch) {
        ArrayList<Rule> matchingRules = new ArrayList<Rule>();
        if (this.rules != null) {
            for (Rule rule : this.rules) {
                if (!rule.matchFailure(failuresetToMatch)) continue;
                matchingRules.add(rule);
            }
        }
        return matchingRules;
    }

    protected void log(String message) {
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getRules();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.getRules().clear();
                this.getRules().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.getRules().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.rules != null && !this.rules.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

