/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.monitoring.traceanalyser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.monitoring.monitoringxml.AnalysisContext;
import org.polarsys.chess.monitoring.monitoringxml.BlockingTime;
import org.polarsys.chess.monitoring.monitoringxml.ExecutionTime;
import org.polarsys.chess.monitoring.monitoringxml.MeasuredValue;
import org.polarsys.chess.monitoring.monitoringxml.Monitoring;
import org.polarsys.chess.monitoring.monitoringxml.MonitoringxmlFactory;
import org.polarsys.chess.monitoring.monitoringxml.Period;
import org.polarsys.chess.monitoring.monitoringxml.ResponseTime;
import org.polarsys.chess.monitoring.monitoringxml.Thread;
import org.polarsys.chess.monitoring.traceanalyser.Parameters;
import org.polarsys.chess.monitoring.traceanalyser.TraceReader;

public class TraceAnalyser {
    private IFile inputFile;
    private IFile inTraceFile;
    private IFolder traceExtractionPath;
    private String delimiter = " ";
    private Shell shell;
    private String unitName = "ms";
    private double unitFactor = 0.001;

    public TraceAnalyser(Shell shell, IFile inXMLFile, String outXMLFileName, IFile traceFile) {
        this.shell = shell;
        this.inputFile = inXMLFile;
        this.inTraceFile = traceFile;
        this.traceExtractionPath = traceFile.getProject().getFolder(String.valueOf(traceFile.getParent().getName()) + File.separator + "traces");
        try {
            CHESSProjectSupport.createFolder((IFolder)this.traceExtractionPath);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    public void doTraceAnalysis() {
        try {
            ProgressMonitorDialog progDialog = new ProgressMonitorDialog(this.shell);
            progDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Analyzing measured values ...", 100);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    TraceReader trace = new TraceReader(TraceAnalyser.this.inTraceFile, TraceAnalyser.this.inputFile, TraceAnalyser.this.delimiter);
                    monitor.worked(45);
                    Parameters parameters = new Parameters(trace, TraceAnalyser.this.traceExtractionPath);
                    parameters.ComputeParameters();
                    monitor.worked(45);
                    String[] actxName = trace.GetAnalysisContext().split("::");
                    String outputName = String.valueOf(actxName[actxName.length - 1]) + "_monitoring.xml";
                    try {
                        double factor = trace.GetClockRate() * (double)parameters.getCounterScaleFactor().intValue();
                        TraceAnalyser.CreateMonitoringXMLOutput(TraceAnalyser.this.inputFile, outputName, trace.GetAnalysisContext(), trace.GetThreadIDs(), parameters, TraceAnalyser.this.unitFactor, TraceAnalyser.this.unitName, factor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    monitor.worked(10);
                    monitor.done();
                }
            });
        }
        catch (Exception ex) {
            throw new OperationCanceledException(ex.getMessage());
        }
    }

    public static void CreateMonitoringXMLOutput(IFile inputFile, String outXMLFileName, String saAnalysisName, ArrayList<String> threadNames, Parameters parameters, double unitFactor, String unitName, double clockRate) throws Exception {
        MonitoringxmlFactory factory = MonitoringxmlFactory.eINSTANCE;
        Monitoring mon = factory.createMonitoring();
        AnalysisContext analysisContext = factory.createAnalysisContext();
        analysisContext.setName(saAnalysisName);
        mon.setAnalysisContext(analysisContext);
        int i = 0;
        while (i < threadNames.size()) {
            Thread thread = factory.createThread();
            thread.setName(threadNames.get(i));
            ExecutionTime executionTime = factory.createExecutionTime();
            MeasuredValue maximumET = factory.createMeasuredValue();
            maximumET.setUnit(unitName);
            maximumET.setValue(Float.valueOf((float)((double)parameters.GetWCETOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            executionTime.setMaximum(maximumET);
            MeasuredValue averageET = factory.createMeasuredValue();
            averageET.setUnit(unitName);
            averageET.setValue(Float.valueOf((float)(parameters.GetACETOfAllThreads().get(i) * unitFactor / clockRate)));
            executionTime.setAverage(averageET);
            MeasuredValue minimumET = factory.createMeasuredValue();
            minimumET.setUnit(unitName);
            minimumET.setValue(Float.valueOf((float)((double)parameters.GetBCETOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            executionTime.setMinimum(minimumET);
            thread.setExecutiontime(executionTime);
            Period period = factory.createPeriod();
            MeasuredValue maximumP = factory.createMeasuredValue();
            maximumP.setUnit(unitName);
            maximumP.setValue(Float.valueOf((float)((double)parameters.GetMaximumInterArrivalTimeOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            period.setMaximum(maximumP);
            MeasuredValue averageP = factory.createMeasuredValue();
            averageP.setUnit(unitName);
            averageP.setValue(Float.valueOf((float)(parameters.GetAverageInterArrivalTimeOfAllThreads().get(i) * unitFactor / clockRate)));
            period.setAverage(averageP);
            MeasuredValue minimumP = factory.createMeasuredValue();
            minimumP.setUnit(unitName);
            minimumP.setValue(Float.valueOf((float)((double)parameters.GetMinimumInterArrivalTimeOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            period.setMinimum(minimumP);
            MeasuredValue jitterP = factory.createMeasuredValue();
            jitterP.setUnit(unitName);
            jitterP.setValue(Float.valueOf((float)((double)parameters.GetMinimumInterArrivalTimeOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            period.setJitter(jitterP);
            thread.setPeriod(period);
            BlockingTime blockingTime = factory.createBlockingTime();
            MeasuredValue maximumBT = factory.createMeasuredValue();
            maximumBT.setUnit(unitName);
            maximumBT.setValue(Float.valueOf((float)((double)parameters.GetMaximumBlockingTimeOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            blockingTime.setMaximum(maximumBT);
            MeasuredValue averageBT = factory.createMeasuredValue();
            averageBT.setUnit(unitName);
            averageBT.setValue(Float.valueOf((float)(parameters.GetAverageBlockingTimeOfAllThreads().get(i) * unitFactor / clockRate)));
            blockingTime.setAverage(averageBT);
            MeasuredValue minimumBT = factory.createMeasuredValue();
            minimumBT.setUnit(unitName);
            minimumBT.setValue(Float.valueOf((float)((double)parameters.GetMinimumBlockingTimeOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            blockingTime.setMinimum(minimumBT);
            thread.setBlockingtime(blockingTime);
            ResponseTime responseTime = factory.createResponseTime();
            MeasuredValue maximumRT = factory.createMeasuredValue();
            maximumRT.setUnit(unitName);
            maximumRT.setValue(Float.valueOf((float)((double)parameters.GetWorstCaseResponseTimeOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            responseTime.setMaximum(maximumRT);
            MeasuredValue averageRT = factory.createMeasuredValue();
            averageRT.setUnit(unitName);
            averageRT.setValue(Float.valueOf((float)(parameters.GetAverageCaseResponseTimeOfAllThreads().get(i) * unitFactor / clockRate)));
            responseTime.setAverage(averageRT);
            MeasuredValue minimumRT = factory.createMeasuredValue();
            minimumRT.setUnit(unitName);
            minimumRT.setValue(Float.valueOf((float)((double)parameters.GetBestCaseResponseTimeOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            responseTime.setMinimum(minimumRT);
            MeasuredValue jitterRT = factory.createMeasuredValue();
            jitterRT.setUnit(unitName);
            jitterRT.setValue(Float.valueOf((float)((double)parameters.GetJitterInResponseTimetOfAllThreads().get(i).longValue() * unitFactor / clockRate)));
            responseTime.setJitter(jitterRT);
            thread.setResponsetime(responseTime);
            mon.getThreadNames().add((Object)thread);
            ++i;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createURI((String)(inputFile.getParent().getLocationURI() + File.separator + outXMLFileName)));
        resource.getContents().add((Object)mon);
        try {
            resource.save(null);
            inputFile.getProject().refreshLocal(2, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

