/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.tradeoffAnalysis.commands;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.ui.services.OSSTranslatorServiceUI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageCommunicationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.ErrorsDialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import eu.fbk.tools.adapter.ocra.CheckContractResultBuilder;
import eu.fbk.tools.adapter.ocra.OcraOutput;
import eu.fbk.tools.adapter.results.ContractCheckResult;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;
import org.polarsys.chess.service.gui.utils.SelectionUtil;
import org.polarsys.chess.tradeoffAnalysis.dialogs.ConfigurationSelectionDialog;
import org.polarsys.chess.tradeoffAnalysis.views.TradeoffView;

public class TradeoffCommand
extends AbstractJobCommand {
    private static final Logger logger = Logger.getLogger(TradeoffCommand.class);
    private ConfigurationSelectionDialog configurationSelectionDialog;
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
    private final ErrorsDialogUtil errorsDialogUtil = ErrorsDialogUtil.getInstance();
    private DialogUtil dialogUtil = DialogUtil.getInstance();
    private OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
    private OSSTranslatorServiceUI ocraTranslatorService = OSSTranslatorServiceUI.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private Class umlSelectedComponent;
    private String checkType;
    private EList<InstantiatedArchitectureConfiguration> configurations;
    private int timeSpecification;
    private boolean isAsyncCommunication;
    private File ossFile;
    private boolean goAhead;
    private List<AnalysisResult> results;

    public TradeoffCommand() {
        super("Trade-off Analysis");
    }

    private File exportArchitectureAsOssFile(int timeSpecification, boolean isAsyncCommunication, ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        String ossFilepath = this.ocraDirectoryUtil.getOSSDirPath();
        Class umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        Resource umlSelectedResource = umlSelectedComponent.eResource();
        return this.ocraTranslatorService.exportRootComponentToOssFile((Object)umlSelectedComponent, umlSelectedResource, timeSpecification, isAsyncCommunication, true, false, ossFilepath, monitor);
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        this.umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        this.goAhead = false;
        if (!EntityUtil.getInstance().isSystem((Element)this.umlSelectedComponent)) {
            this.errorsDialogUtil.showMessage_GenericError("Please select a <<System>> component");
            return;
        }
        Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                TradeoffCommand.this.configurationSelectionDialog = new ConfigurationSelectionDialog(TradeoffCommand.this.umlSelectedComponent);
                TradeoffCommand.this.configurationSelectionDialog.open();
            }
        });
        this.goAhead = this.configurationSelectionDialog.goAhead();
        if (!this.goAhead) {
            return;
        }
        this.checkType = this.configurationSelectionDialog.getCheckType();
        this.configurations = this.configurationSelectionDialog.getConfigurations();
        this.timeSpecification = MessageTimeModelDialog.openQuestion((boolean)false);
        this.isAsyncCommunication = !MessageCommunicationDialog.openQuestion((boolean)false);
        this.ossFile = this.exportArchitectureAsOssFile(this.timeSpecification, this.isAsyncCommunication, event, monitor);
    }

    private String getConcerns(Class umlSelectedComponent, String contractName) {
        String concerns = null;
        EList contractProperties = this.contractEntityUtil.getContractProperties(umlSelectedComponent);
        for (ContractProperty contractProperty : contractProperties) {
            Class contractPropertyType = (Class)contractProperty.getBase_Property().getType();
            if (!contractPropertyType.getName().equals(contractName)) continue;
            FormalProperty assume = this.contractEntityUtil.getAssumeFromUmlContract(contractPropertyType);
            concerns = assume.getConcern().getName();
            FormalProperty guarantee = this.contractEntityUtil.getGuaranteeFromUmlContract(contractPropertyType);
            if (guarantee.getConcern().getName().equals(concerns)) continue;
            concerns = String.valueOf(concerns) + ", " + guarantee.getConcern().getName();
        }
        return concerns;
    }

    private void processResult(int index, AnalysisResult analysisResult, TradeoffView.Row row, List<String> labels, TradeoffView.Row concernsRow) {
        File resultFile;
        try {
            resultFile = new File(analysisResult.getResultFilePath());
        }
        catch (Exception e) {
            this.dialogUtil.showMessage_ExceptionError(e);
            e.printStackTrace();
            return;
        }
        CheckContractResultBuilder resultBuilder = new CheckContractResultBuilder();
        OcraOutput ocraOutput = resultBuilder.unmarshalResult(resultFile);
        if (ocraOutput == null || ocraOutput.getOcraResult() == null || ocraOutput.getOcraResult().isEmpty()) {
            logger.debug((Object)"Error while unmarshalling the result. For more info see the console");
            return;
        }
        ModelCheckResult contractCheckResult = resultBuilder.buildResult(ocraOutput);
        if (contractCheckResult == null) {
            logger.debug((Object)"Internal error while building the result. For more info see the console");
            return;
        }
        EList contractCheckResults = contractCheckResult.getContractCheckResults();
        for (ContractCheckResult result : contractCheckResults) {
            if (!result.getCheckType().equals("ocra_check_refinement") || !result.getComponentType().equals(this.umlSelectedComponent.getName())) continue;
            String contractName = result.getContractName();
            if (index == 0) {
                labels.add(contractName);
                concernsRow.addResult(this.getConcerns(this.umlSelectedComponent, contractName));
            }
            String checkResult = result.getFailed() != false ? "NOT OK" : "Success";
            row.addResult(checkResult);
        }
    }

    private void displayResult(List<AnalysisResult> results) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            try {
                TradeoffView viewPart = (TradeoffView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.chess.tradeoffAnalysis.views.TradeoffView", null, 2);
                if (viewPart != null) {
                    ArrayList<String> labels = new ArrayList<String>();
                    labels.add(this.configurationSelectionDialog.getCheckType());
                    labels.add("");
                    labels.add("");
                    ArrayList<TradeoffView.Row> rows = new ArrayList<TradeoffView.Row>();
                    TradeoffView.Row concernsRow = new TradeoffView.Row("Concerns");
                    rows.add(concernsRow);
                    int index = 0;
                    for (AnalysisResult analysisResult : results) {
                        TradeoffView.Row configuration = new TradeoffView.Row(analysisResult.getConfigurationName());
                        rows.add(configuration);
                        configuration.setAnalysisName(this.checkType);
                        configuration.setResultFilePath(analysisResult.getResultFilePath());
                        this.processResult(index++, analysisResult, configuration, labels, concernsRow);
                    }
                    viewPart.createColumns(viewPart.getViewer(), labels);
                    TableViewer tableViewer = viewPart.getViewer();
                    IContentProvider provider = tableViewer.getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    tableViewer.setInput(rows);
                    tableViewer.refresh();
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)viewPart);
                }
            }
            catch (Exception e) {
                this.dialogUtil.showMessage_ExceptionError(e);
                e.printStackTrace();
            }
        });
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        if (!this.goAhead || this.ossFile == null) {
            return;
        }
        this.results = new ArrayList<AnalysisResult>();
        if (this.configurations.size() > 0 && this.checkType.equals(ConfigurationSelectionDialog.CHECK_CONTRACT_REFINEMENT)) {
            this.checkType = "ocra_check_refinement";
            for (InstantiatedArchitectureConfiguration configuration : this.configurations) {
                String resultFilePath;
                File parametersValuesFile;
                String configurationName = configuration.getBase_Property().getName();
                File instantiatedOssFile = this.ocraExecService.executeInstantiateArchitecture(configurationName, this.ossFile, parametersValuesFile = this.ocraExecService.prepareParameterValuesFile(configuration.getParameterList(), this.ossFile.getName()), 1, this.timeSpecification, monitor);
                if (!this.ocraExecService.executeCheckContractRefinement(instantiatedOssFile, this.timeSpecification, resultFilePath = this.ocraDirectoryUtil.getCommandCheckRefinementResultPath(configurationName), monitor, true)) continue;
                AnalysisResult result = new AnalysisResult(configuration, resultFilePath);
                this.results.add(result);
            }
            this.displayResult(this.results);
        }
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
        if (!this.goAhead || this.ossFile == null) {
            return;
        }
        for (AnalysisResult currResult : this.results) {
            AnalysisResultUtil.getInstance().createOrUpdateAnalysisContext(Analysis.CONTRACT_REFINEMENT_ANALYSIS, ECollections.emptyEList(), currResult.getResultFilePath(), false, this.umlSelectedComponent, currResult.getConfiguration(), null);
        }
    }

    protected class AnalysisResult {
        private InstantiatedArchitectureConfiguration configuration;
        private String resultFilePath;

        public AnalysisResult(InstantiatedArchitectureConfiguration configuration, String resultFilePath) {
            this.configuration = configuration;
            this.resultFilePath = resultFilePath;
        }

        public InstantiatedArchitectureConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getConfigurationName() {
            return this.configuration.getBase_Property().getName();
        }

        public void setConfiguration(InstantiatedArchitectureConfiguration configurationName) {
            this.configuration = configurationName;
        }

        public String getResultFilePath() {
            return this.resultFilePath;
        }

        public void setResultFilePath(String resultFilePath) {
            this.resultFilePath = resultFilePath;
        }
    }
}

