/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.managers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerKind;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerPort;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.FlowPort;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ComponentOperationCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.ComponentCompositeCompartmentEditPart;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.internal.impl.DependencyImpl;
import org.polarsys.chess.core.profiles.MARTEProfileManager;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class AddDiagramElement {
    public static Command createDependencies(TransactionalEditingDomain domain, final Component comp, final ClientServerPort port) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                if (port.getKind() == ClientServerKind.PROVIDED || port.getKind() == ClientServerKind.PROREQ) {
                    for (Interface mInterface : port.getProvInterface()) {
                        if (this.exists(comp, mInterface, true)) continue;
                        StringBuilder s = new StringBuilder(25);
                        s.append(comp.getName()).append("_Rlz_").append(mInterface.getName());
                        comp.createInterfaceRealization(s.toString(), mInterface);
                    }
                }
                if (port.getKind() == ClientServerKind.REQUIRED || port.getKind() == ClientServerKind.PROREQ) {
                    for (Interface mInterface : port.getReqInterface()) {
                        if (this.exists(comp, mInterface, false)) continue;
                        Dependency dep = comp.createDependency((NamedElement)mInterface);
                        StringBuilder s = new StringBuilder(25);
                        s.append(comp.getName()).append("_Dpn_").append(mInterface.getName());
                        dep.setName(s.toString());
                    }
                }
            }

            private boolean exists(Component comp2, Interface mInterface, boolean interfaceRealization) {
                if (interfaceRealization) {
                    for (InterfaceRealization ir : comp2.getInterfaceRealizations()) {
                        if (!ir.getContract().equals(mInterface)) continue;
                        return true;
                    }
                } else {
                    for (Dependency dp : comp2.getClientDependencies()) {
                        if (!dp.getClass().equals(DependencyImpl.class)) continue;
                        for (NamedElement i : dp.getSuppliers()) {
                            if (!(i instanceof Interface) || !mInterface.equals(i)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        };
    }

    public static Command destroyDependencies(TransactionalEditingDomain domain, final EList<? extends Dependency> deps) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                for (Dependency dependency : deps) {
                    dependency.destroy();
                }
            }
        };
    }

    public static Command addOperationCommand(TransactionalEditingDomain domain, final Classifier interf, final Component comp) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                for (Operation operation : interf.getAllOperations()) {
                    if (UMLUtils.isOperationContained((Classifier)comp, (Operation)operation)) continue;
                    Operation newOp = comp.createOwnedOperation(operation.getName(), null, null);
                    UMLUtils.copyOperation((Operation)operation, (Operation)newOp);
                    AddDiagramElement.createGraphicalOperation(comp, newOp);
                }
            }
        };
    }

    public static Command addAllPortsCommand(TransactionalEditingDomain domain, final Component providerComp, final Component clientComp) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                Profile gcm = ViewUtils.getView((EObject)clientComp).getAppliedProfile("MARTE::MARTE_DesignModel::GCM");
                if (gcm == null) {
                    return;
                }
                Stereotype cspStereotype = gcm.getOwnedStereotype("ClientServerPort");
                for (Port supplierPort : providerComp.getOwnedPorts()) {
                    ClientServerPort cspSupplied = (ClientServerPort)UMLUtils.getStereotypeApplication((Element)supplierPort, ClientServerPort.class);
                    if (cspSupplied == null || clientComp.getOwnedPort(supplierPort.getName(), supplierPort.getType()) != null) continue;
                    Port clientPort = clientComp.createOwnedPort(supplierPort.getName(), supplierPort.getType());
                    ClientServerPort cspClient = (ClientServerPort)clientPort.applyStereotype(cspStereotype);
                    cspClient.setKind(cspSupplied.getKind());
                    clientPort.setValue(cspStereotype, "provInterface", supplierPort.getValue(cspStereotype, "provInterface"));
                    clientPort.setValue(cspStereotype, "reqInterface", supplierPort.getValue(cspStereotype, "reqInterface"));
                }
                EList typePortList = providerComp.getOwnedPorts();
                for (Port typePort : typePortList) {
                    Stereotype typeFlowPort = typePort.getAppliedStereotype("MARTE::MARTE_DesignModel::GCM::FlowPort");
                    if (clientComp.getOwnedPort(typePort.getName(), typePort.getType()) != null) continue;
                    Port implPort = clientComp.createOwnedPort(typePort.getName(), typePort.getType());
                    implPort.applyStereotype(typeFlowPort);
                    Stereotype implFlowPort = implPort.getAppliedStereotype("MARTE::MARTE_DesignModel::GCM::FlowPort");
                    implPort.setValue(implFlowPort, "direction", typePort.getValue(typeFlowPort, "direction"));
                }
            }
        };
    }

    public static Command addPortCommand(TransactionalEditingDomain domain, Component providerComp, final Component clientComp, final Port supplierPort) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                Profile gcm = ViewUtils.getView((EObject)clientComp).getAppliedProfile("MARTE::MARTE_DesignModel::GCM");
                if (gcm == null) {
                    return;
                }
                Stereotype cspStereotype = gcm.getOwnedStereotype("ClientServerPort");
                ClientServerPort cspSupplied = (ClientServerPort)UMLUtils.getStereotypeApplication((Element)supplierPort, ClientServerPort.class);
                if (cspSupplied == null) {
                    return;
                }
                if (clientComp.getOwnedPort(supplierPort.getName(), supplierPort.getType()) == null) {
                    Port clientPort = clientComp.createOwnedPort(supplierPort.getName(), supplierPort.getType());
                    ClientServerPort cspClient = (ClientServerPort)clientPort.applyStereotype(cspStereotype);
                    cspClient.setKind(cspSupplied.getKind());
                    clientPort.setValue(cspStereotype, "provInterface", supplierPort.getValue(cspStereotype, "provInterface"));
                    clientPort.setValue(cspStereotype, "reqInterface", supplierPort.getValue(cspStereotype, "reqInterface"));
                }
            }
        };
    }

    public static Command addOperationCommand1(TransactionalEditingDomain domain, final Interface interf, final Operation operation) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                EList relationships = UMLUtils.getInterfaceClients((Interface)interf);
                if (relationships != null && !relationships.isEmpty()) {
                    for (NamedElement element : relationships) {
                        if (!(element instanceof Component)) continue;
                        Component comp = (Component)element;
                        for (NamedElement compImpl : UMLUtils.getComponentImplementations((Component)comp)) {
                            if (!(compImpl instanceof Component)) continue;
                            Operation newOp = ((Class)compImpl).createOwnedOperation(operation.getName(), null, null);
                            UMLUtils.copyOperation((Operation)operation, (Operation)newOp);
                            AddDiagramElement.createGraphicalOperation((Component)compImpl, newOp);
                        }
                        System.out.println("DEBUG size: " + comp.getOperations().size());
                        Operation newOp = comp.createOwnedOperation(operation.getName(), null, null);
                        UMLUtils.copyOperation((Operation)operation, (Operation)newOp);
                        AddDiagramElement.createGraphicalOperation(comp, newOp);
                    }
                }
            }
        };
    }

    private static void createGraphicalOperation(Component containerComp, Operation newOp) {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        Diagram cfr_ignored_0 = (Diagram)editor.getAdapter(Diagram.class);
        DiagramEditPart diagramEP = (DiagramEditPart)editor.getAdapter(DiagramEditPart.class);
        IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)diagramEP.getViewer();
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        dropObjectsRequest.setLocation(new Point(1, 1));
        ArrayList<Operation> objectList = new ArrayList<Operation>();
        objectList.add(newOp);
        dropObjectsRequest.setObjects(objectList);
        List editParts = viewer.findEditPartsForElement(EMFCoreUtil.getProxyID((EObject)containerComp), INodeEditPart.class);
        StringBuilder s = new StringBuilder();
        s.delete(0, s.length());
        s.append("CREATING GUI OP");
        CHESSProjectSupport.CHESS_CONSOLE.println(s.toString());
        s.delete(0, s.length());
        s.append("EDITPARTS " + editParts);
        CHESSProjectSupport.CHESS_CONSOLE.println(s.toString());
        s.delete(0, s.length());
        s.append("EDITPARTS SIZE " + editParts.size());
        CHESSProjectSupport.CHESS_CONSOLE.println(s.toString());
        if (editParts.size() > 0) {
            List childrenEparts = ((EditPart)editParts.get(0)).getChildren();
            ComponentOperationCompartmentEditPart compAttrEpart = null;
            int i = 0;
            while (i < childrenEparts.size()) {
                if (childrenEparts.get(i) instanceof ComponentOperationCompartmentEditPart) {
                    compAttrEpart = (ComponentOperationCompartmentEditPart)childrenEparts.get(i);
                    org.eclipse.gef.commands.Command cmd = compAttrEpart.getTargetEditPart((Request)dropObjectsRequest).getCommand((Request)dropObjectsRequest);
                    s.delete(0, s.length());
                    s.append("EXEC GUI COMMAND" + editParts);
                    CHESSProjectSupport.CHESS_CONSOLE.println(s.toString());
                    diagramEP.getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
                }
                ++i;
            }
        }
    }

    private static void createGraphicalPort(Component containerComp, Port port) {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        Diagram cfr_ignored_0 = (Diagram)editor.getAdapter(Diagram.class);
        DiagramEditPart diagramEP = (DiagramEditPart)editor.getAdapter(DiagramEditPart.class);
        IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)diagramEP.getViewer();
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        dropObjectsRequest.setLocation(new Point(1, 1));
        ArrayList<Port> objectList = new ArrayList<Port>();
        objectList.add(port);
        dropObjectsRequest.setObjects(objectList);
        List editParts = viewer.findEditPartsForElement(EMFCoreUtil.getProxyID((EObject)containerComp), INodeEditPart.class);
        if (editParts.size() > 0) {
            List childrenEparts = ((EditPart)editParts.get(0)).getChildren();
            ComponentCompositeCompartmentEditPart compAttrEpart = null;
            int i = 0;
            while (i < childrenEparts.size()) {
                if (childrenEparts.get(i) instanceof ComponentCompositeCompartmentEditPart) {
                    compAttrEpart = (ComponentCompositeCompartmentEditPart)childrenEparts.get(i);
                    org.eclipse.gef.commands.Command cmd = compAttrEpart.getCommand((Request)dropObjectsRequest);
                    diagramEP.getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
                }
                ++i;
            }
        }
    }

    public static Command addCommentCommand(TransactionalEditingDomain domain, final Comment comm) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                if (editor == null) {
                    return;
                }
                if (comm.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") != null) {
                    try {
                        Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
                        Model umlModel = ResourceUtils.getModel((Resource)res);
                        Package deplViewPkg = (Package)umlModel.getPackagedElement("modelDeploymentView");
                        Stereotype deplView = deplViewPkg.getAppliedStereotype("CHESS::Core::CHESSViews::DeploymentView");
                        if (deplView != null) {
                            EList tmp = (EList)deplViewPkg.getValue(deplView, "AssignList");
                            tmp.add((Object)comm);
                        }
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public static Command removeCommentCommand(TransactionalEditingDomain domain, final Comment comm) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                if (editor == null) {
                    return;
                }
                if (comm.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") != null) {
                    try {
                        Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
                        Model umlModel = ResourceUtils.getModel((Resource)res);
                        Package deplViewPkg = (Package)umlModel.getPackagedElement("modelDeploymentView");
                        Stereotype deplView = deplViewPkg.getAppliedStereotype("CHESS::Core::CHESSViews::DeploymentView");
                        if (deplView != null) {
                            EList tmp = (EList)deplViewPkg.getValue(deplView, "AssignList");
                            tmp.remove((Object)comm);
                        }
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public static Command addParameterCommand(final Interface opCont, final Parameter param, final Operation operation, TransactionalEditingDomain domain) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                EList relationships = UMLUtils.getAllInterfaceComponents((Interface)opCont);
                if (relationships == null || relationships.isEmpty()) {
                    return;
                }
                for (Component comp : relationships) {
                    for (Operation op : comp.getOwnedOperations()) {
                        if (!UMLUtils.areOperationsEqual((Operation)operation, (Operation)op, (Parameter)param)) continue;
                        Parameter tmp = op.createOwnedParameter(param.getName(), param.getType());
                        tmp.setDirection(param.getDirection());
                        tmp.setEffect(param.getEffect());
                    }
                }
            }
        };
    }

    public static Command updateImplementationsPorts(TransactionalEditingDomain domain, final ClientServerPort cspSupplied) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                Port supplierPort = cspSupplied.getBase_Port();
                Element supplierComp = supplierPort.getOwner();
                if (!UMLUtils.isComponentType((Object)supplierComp)) {
                    return;
                }
                Profile gcm = ViewUtils.getView((EObject)supplierComp).getAppliedProfile("MARTE::MARTE_DesignModel::GCM");
                if (gcm == null) {
                    return;
                }
                Stereotype cspStereotype = gcm.getOwnedStereotype("ClientServerPort");
                for (Component clientComp : UMLUtils.getComponentImplementations((Component)((Component)supplierComp))) {
                    Port clientPort = clientComp.getOwnedPort(supplierPort.getName(), supplierPort.getType());
                    if (clientPort == null) {
                        clientPort = clientComp.createOwnedPort(supplierPort.getName(), supplierPort.getType());
                        MARTEProfileManager.applyStereotypeTo((String)"ClientServerPort", (Element)clientPort);
                    }
                    ClientServerPort cspClient = (ClientServerPort)clientPort.getStereotypeApplication(cspStereotype);
                    cspClient.setKind(cspSupplied.getKind());
                    clientPort.setValue(cspStereotype, "provInterface", supplierPort.getValue(cspStereotype, "provInterface"));
                    clientPort.setValue(cspStereotype, "reqInterface", supplierPort.getValue(cspStereotype, "reqInterface"));
                }
            }
        };
    }

    public static Command updateImplementationsFlowPorts(TransactionalEditingDomain domain, final FlowPort flPort) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                Port portType = flPort.getBase_Port();
                Element compType = portType.getOwner();
                if (!UMLUtils.isComponentType((Object)compType)) {
                    return;
                }
                Stereotype flpType = portType.getAppliedStereotype("MARTE::MARTE_DesignModel::GCM::FlowPort");
                for (Component compImpl : UMLUtils.getComponentImplementations((Component)((Component)compType))) {
                    Port portImpl = compImpl.getOwnedPort(portType.getName(), portType.getType());
                    if (portImpl == null) {
                        portImpl = compImpl.createOwnedPort(portType.getName(), portType.getType());
                        MARTEProfileManager.applyStereotypeTo((String)"FlowPort", (Element)portImpl);
                    }
                    Stereotype flpImpl = portImpl.getAppliedStereotype("MARTE::MARTE_DesignModel::GCM::FlowPort");
                    portImpl.setValue(flpImpl, "direction", portType.getValue(flpType, "direction"));
                }
            }
        };
    }

    public static Command removeImplementationsPorts(TransactionalEditingDomain domain, final Port supplierPort) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                Element supplierComp = supplierPort.getOwner();
                if (!UMLUtils.isComponentType((Object)supplierComp)) {
                    return;
                }
                for (Component clientComp : UMLUtils.getComponentImplementations((Component)((Component)supplierComp))) {
                    Port clientPort = clientComp.getOwnedPort(supplierPort.getName(), supplierPort.getType());
                    if (clientPort == null) {
                        return;
                    }
                    clientPort.destroy();
                }
            }
        };
    }
}

