/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.popup.commands;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.impl.EObjectTreeElementImpl;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.ConstraintPropertyChildLabelEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.PropertyForClassEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.PropertyForComponentEditPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.polarsys.chess.contracts.chessextension.dialogs.SetContractRefinementDialog;
import org.polarsys.chess.contracts.chessextension.managers.CHESSContractProfileManager;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinement;

public class SetContractRefinement
extends AbstractHandler {
    public static final String CONTRACT_PROPERTY = "CHESSContract::ContractProperty";
    protected static final String CONTRACT_REFINEMENt = "CHESSContract::ContractRefinement";
    public static final String COMPONENT_INSTANCE = "CHESSContract::ComponentInstance";
    private Shell shell;
    private TransactionalEditingDomain editdomain;
    private Property contrProp;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.shell = window.getShell();
        try {
            this.setSelection();
            if (this.contrProp != null) {
                Stereotype contrPropStereo = this.contrProp.getAppliedStereotype(CONTRACT_PROPERTY);
                if (contrPropStereo == null) {
                    throw new Exception("Select the ContractProperty element to set the contract refinement");
                }
                Object refinedByList = this.contrProp.getValue(contrPropStereo, "RefinedBy");
                if (refinedByList instanceof EList) {
                    final EList refineList = (EList)refinedByList;
                    final Class ownerClass = (Class)this.contrProp.getOwner();
                    final SetContractRefinementDialog dialog = new SetContractRefinementDialog(this.shell, ownerClass, (EList<ContractRefinement>)refineList);
                    dialog.populateRefineListAndCreateDialog();
                    if (dialog.open() == 0) {
                        this.editdomain.getCommandStack().execute((Command)new RecordingCommand(this.editdomain){

                            protected void doExecute() {
                                refineList.clear();
                                if (dialog.getSelected() != null) {
                                    for (SetContractRefinementDialog.ContractRefinementObj currContractRefinementObj : dialog.getSelected()) {
                                        Classifier existingContractRefinement = ownerClass.getNestedClassifier(currContractRefinementObj.getID());
                                        if (existingContractRefinement == null) {
                                            DataType dt = UMLFactory.eINSTANCE.createDataType();
                                            ownerClass.getNestedClassifiers().add((Object)dt);
                                            dt.setName(currContractRefinementObj.getID());
                                            Stereotype st = CHESSContractProfileManager.getContractRefinement();
                                            dt.applyStereotype(st);
                                            String partName = currContractRefinementObj.getSubComponentName();
                                            String contrName = currContractRefinementObj.getContractName();
                                            ContractRefinement contRef = (ContractRefinement)dt.getStereotypeApplication(st);
                                            Property instance = ownerClass.getPart(partName, null);
                                            contRef.setInstance(instance);
                                            Property contrProp = ((Classifier)instance.getType()).getAttribute(contrName, null);
                                            ContractProperty contract = (ContractProperty)contrProp.getStereotypeApplication(contrProp.getAppliedStereotype(SetContractRefinement.CONTRACT_PROPERTY));
                                            contRef.setContract(contract);
                                            contRef.setLowerIndexOfInstance(currContractRefinementObj.getLower());
                                            contRef.setUpperIndexOfInstance(currContractRefinementObj.getUpper());
                                            refineList.add((Object)contRef);
                                            continue;
                                        }
                                        ContractRefinement cr = (ContractRefinement)existingContractRefinement.getStereotypeApplication(existingContractRefinement.getAppliedStereotype(SetContractRefinement.CONTRACT_REFINEMENt));
                                        refineList.add((Object)cr);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DialogUtil.getInstance().showMessage_ExceptionError(e);
        }
        return null;
    }

    private void setSelection() throws Exception {
        IStructuredSelection strucSelection;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && (strucSelection = (IStructuredSelection)selection).size() == 1) {
            Object partSelected = strucSelection.iterator().next();
            if (partSelected instanceof ConstraintPropertyChildLabelEditPart) {
                ConstraintPropertyChildLabelEditPart sysmlEditPart = (ConstraintPropertyChildLabelEditPart)partSelected;
                Node notationNode = (Node)sysmlEditPart.getModel();
                this.contrProp = (Property)notationNode.getElement();
                this.editdomain = sysmlEditPart.getEditingDomain();
            } else if (partSelected instanceof PropertyForClassEditPart) {
                PropertyForClassEditPart umlClassEditPart = (PropertyForClassEditPart)partSelected;
                Node notationNode = (Node)umlClassEditPart.getModel();
                this.contrProp = (Property)notationNode.getElement();
                this.editdomain = umlClassEditPart.getEditingDomain();
            } else if (partSelected instanceof PropertyForComponentEditPart) {
                PropertyForComponentEditPart umlCompEditPart = (PropertyForComponentEditPart)partSelected;
                Node notationNode = (Node)umlCompEditPart.getModel();
                this.contrProp = (Property)notationNode.getElement();
                this.editdomain = umlCompEditPart.getEditingDomain();
            } else if (partSelected instanceof EObjectTreeElementImpl) {
                EObjectTreeElementImpl eObjectTreeElementImpl = (EObjectTreeElementImpl)partSelected;
                System.out.println("--> " + eObjectTreeElementImpl.getEObject());
                if (!(eObjectTreeElementImpl.getEObject() instanceof Property)) {
                    throw new Exception("Select the ContractProperty element to set the contract refinement");
                }
                this.contrProp = (Property)eObjectTreeElementImpl.getEObject();
                this.editdomain = TransactionUtil.getEditingDomain((EObject)this.contrProp);
            }
        }
    }
}

