/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagram.ui.commands;

import eu.fbk.eclipse.standardtools.diagram.ui.dialog.ComponentToImageDialog;
import eu.fbk.eclipse.standardtools.diagram.ui.docGenerators.InternalBlockDiagramGeneratorService;
import eu.fbk.eclipse.standardtools.diagram.ui.model.AbstractInternalBlockDiagramModel;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractAsyncJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.polarsys.chess.diagram.ui.docGenerators.CHESSInternalBlockDiagramModel;
import org.polarsys.chess.diagram.ui.utils.ExportDialogUtils;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class ExportComponentToImageCommand
extends AbstractAsyncJobCommand {
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private DirectoryUtil directoryUtils = DirectoryUtil.getInstance();
    private ExportDialogUtils exportDialogUtils = ExportDialogUtils.getInstance();
    private static final Logger logger = Logger.getLogger(ExportComponentToImageCommand.class);
    private InternalBlockDiagramGeneratorService diagramGeneratorService = InternalBlockDiagramGeneratorService.getInstance((AbstractInternalBlockDiagramModel)CHESSInternalBlockDiagramModel.getInstance());

    public ExportComponentToImageCommand() {
        super("Export Component To Image Command");
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        GraphicalEditPart selectedGraphicalComponent = this.selectionUtil.getSelectedGraphicalObject(event);
        logger.debug((Object)("selectedGraphicalComponent: " + selectedGraphicalComponent));
        if (selectedGraphicalComponent != null) {
            String imageName;
            ComponentToImageDialog parameterDialog = this.exportDialogUtils.getCompiledComponentToImageDialog();
            if (!parameterDialog.goAhead()) {
                return;
            }
            String projectDir = this.directoryUtils.getCurrentProjectDir();
            String imageFilePath = this.exportDialogUtils.openImageDialog(projectDir, imageName = String.valueOf(this.diagramGeneratorService.getImageName((Object)selectedGraphicalComponent)) + "." + parameterDialog.getImageFormat());
            if (imageFilePath == null || imageFilePath.isEmpty()) {
                return;
            }
            this.diagramGeneratorService.setParametersBeforeDiagramGenerator(parameterDialog.getShowPortLabels(), parameterDialog.getAutomaticPortLabelLayout());
            this.diagramGeneratorService.createDiagramFile(imageFilePath, (Object)selectedGraphicalComponent, monitor);
            this.exportDialogUtils.showMessage_ExportDone(imageFilePath);
        }
    }
}

