/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flamm.FailureTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FailureType implements Enumerator
{
    NO_FAILURE(0, "noFailure", "noFailure"),
    FAILURE(1, "failure", "failure"),
    VARIABLE(2, "variable", "variable"),
    WILDCARD(3, "wildcard", "wildcard");

    public static final int NO_FAILURE_VALUE = 0;
    public static final int FAILURE_VALUE = 1;
    public static final int VARIABLE_VALUE = 2;
    public static final int WILDCARD_VALUE = 3;
    private static final FailureType[] VALUES_ARRAY;
    public static final List<FailureType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FailureType[]{NO_FAILURE, FAILURE, VARIABLE, WILDCARD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FailureType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FailureType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FailureType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FailureType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FailureType get(int value) {
        switch (value) {
            case 0: {
                return NO_FAILURE;
            }
            case 1: {
                return FAILURE;
            }
            case 2: {
                return VARIABLE;
            }
            case 3: {
                return WILDCARD;
            }
        }
        return null;
    }

    private FailureType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

