/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.multicore.dialogs.SystemSelectionDialog;
import org.polarsys.chess.multicore.model.AbstractCommand;
import org.polarsys.chess.multicore.model.CHCore;
import org.polarsys.chess.multicore.model.CHTask;
import org.polarsys.chess.multicore.model.SupertaskInfo;
import org.polarsys.chess.multicore.partitioning.Bin;
import org.polarsys.chess.multicore.partitioning.BinPackerFactory;
import org.polarsys.chess.multicore.partitioning.Heuristic;
import org.polarsys.chess.multicore.partitioning.RUNReduction;
import org.polarsys.chess.multicore.partitioning.Task;
import org.polarsys.chess.multicore.utils.GeneratorUtils;
import org.polarsys.chess.multicore.utils.QueryUtils;
import org.polarsys.chess.validator.constraints.StringParser;

public class GenerateTask2CoreAssignmentsCommand
extends AbstractCommand {
    private HashMap<CHTask, EList<CHTask>> operationList;
    private Map<CHCore, LinkedHashSet<Object>> core2chtask;
    private EList<InstanceSpecification> processors;
    private EList<CHCore> cores = new BasicEList();
    private Set<CHTask> assignedOperations = new HashSet<CHTask>();
    private Map<Package, EList<InstanceSpecification>> processorsMap = new HashMap<Package, EList<InstanceSpecification>>();
    private Map<InstanceSpecification, EList<CHCore>> coresMap = new HashMap<InstanceSpecification, EList<CHCore>>();
    private static Component hwSystem;
    private EList<InstanceSpecification> hwSystemsList = new BasicEList();
    private boolean useRUN;
    private List<SupertaskInfo> supertaskInfoList;
    private HashMap<SupertaskInfo, LinkedHashSet<Object>> core2supertask;

    private static InstanceSpecification openSystemSelector(Model umlModel, EList<InstanceSpecification> hwSystemsList) {
        ArrayList<InstanceSpecification> systemSelection = new ArrayList<InstanceSpecification>();
        for (InstanceSpecification syst : hwSystemsList) {
            systemSelection.add(syst);
        }
        Shell activeShell = Display.getDefault().getActiveShell();
        SystemSelectionDialog systemDialog = new SystemSelectionDialog(activeShell, systemSelection, "Select System where to assign tasks");
        if (systemDialog.open() == 0) {
            String selectedSystemQN = systemDialog.getSystemName();
            EList allElems = umlModel.allOwnedElements();
            for (Element elem : allElems) {
                InstanceSpecification theSystem;
                if (!(elem instanceof InstanceSpecification) || (theSystem = (InstanceSpecification)elem).getQualifiedName() == null || !theSystem.getQualifiedName().equals(selectedSystemQN)) continue;
                Classifier classif = (Classifier)theSystem.getClassifiers().get(0);
                hwSystem = (Component)classif;
                return theSystem;
            }
        }
        return null;
    }

    @Override
    public void execute() throws ModelError {
        this.queryContent(this.umlModel);
        int howMany = this.hwSystemsList.size();
        InstanceSpecification theSystem = null;
        theSystem = howMany > 1 ? GenerateTask2CoreAssignmentsCommand.openSystemSelector(this.umlModel, this.hwSystemsList) : (InstanceSpecification)this.hwSystemsList.get(0);
        if (theSystem != null) {
            Package pack = QueryUtils.getOwnerCHGaResourcePlatformPackage(this.umlModel, theSystem);
            EList<InstanceSpecification> processorList = this.processorsMap.get(pack);
            this.cores = new BasicEList();
            if (processorList != null) {
                for (InstanceSpecification proc : processorList) {
                    EList<CHCore> coreList = this.coresMap.get(proc);
                    for (CHCore core : coreList) {
                        this.cores.add((Object)core);
                    }
                }
            }
            this.executeTask2CoreCalculator(false);
            if (this.core2chtask != null) {
                this.updateModel();
            }
        }
    }

    protected void executeTask2CoreCalculator(boolean forceUseOfRUN) throws ModelError {
        ArrayList<Bin> allBins = new ArrayList<Bin>();
        ArrayList<Task> allTasks = new ArrayList<Task>();
        System.out.format("We have %d cores\n", this.cores.size());
        int i = 0;
        while (i < this.cores.size()) {
            allBins.add(new Bin(i));
            ++i;
        }
        for (CHTask chRtSpecification : this.operationList.keySet()) {
            String occKind = chRtSpecification.getCHRtSpecification().getOccKind();
            QueryUtils.OccKindInfo info = QueryUtils.getOccKindInfo(occKind);
            double c_ = QueryUtils.getWCET(chRtSpecification.getCHRtSpecification());
            for (CHTask spec : this.operationList.get(chRtSpecification)) {
                double c_1 = QueryUtils.getWCET(spec.getCHRtSpecification());
                c_ += c_1;
            }
            StringParser sp = new StringParser();
            double d_ = sp.getValueNFP(chRtSpecification.getCHRtSpecification().getRlDl());
            double t_ = info.value;
            String name = this.getTaskID(chRtSpecification.getCHRtSpecification());
            float c = (float)c_;
            float d = (float)d_;
            float t = (float)t_;
            float o = 0.0f;
            double u_ = c / t;
            float u = (float)u_;
            System.out.println("Task " + name + " -> " + c + " " + d + " " + t + " -> " + u);
            allTasks.add(new Task(name, new Float(c), new Float(d), new Float(t), new Float(o), null));
        }
        Map<Bin, List<Task>> firstPack = BinPackerFactory.getBinPacker(Heuristic.WORST_FIT).pack(allBins, allTasks);
        Map<Bin, List<Task>> reductionTree = new Hashtable<Bin, List<Task>>(firstPack);
        boolean bl = this.useRUN = reductionTree.size() > allBins.size();
        if (forceUseOfRUN) {
            this.useRUN = true;
        }
        if (this.useRUN) {
            System.out.println("Starting RUN packing");
            allTasks = new ArrayList();
            for (Bin bin : reductionTree.keySet()) {
                allTasks.add(new Task(bin.getId().toString(), bin.getCapacity()));
            }
            reductionTree = new RUNReduction().pack(null, allTasks);
            for (Map.Entry row : reductionTree.entrySet()) {
                System.out.print("LEVEL " + ((Bin)row.getKey()).getLevel() + "-" + ((Bin)row.getKey()).getId() + "(U=" + ((Bin)row.getKey()).getCapacity() + ") -> {");
                for (Task t : (List)row.getValue()) {
                    System.out.print(" " + t.getId() + ",");
                }
                System.out.println("}");
            }
            this.buildRUNAssociations(firstPack, reductionTree);
        } else {
            this.buildAssociations(firstPack);
        }
    }

    private void buildRUNAssociations(Map<Bin, List<Task>> firstPack, Map<Bin, List<Task>> reductionTree) throws ModelError {
        this.core2supertask = new HashMap();
        Object[] firstPackSorted = firstPack.entrySet().toArray();
        Arrays.sort(firstPackSorted, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (((Bin)((Map.Entry)o1).getKey()).getId() > ((Bin)((Map.Entry)o2).getKey()).getId()) {
                    return 1;
                }
                if (((Bin)((Map.Entry)o1).getKey()).getId() < ((Bin)((Map.Entry)o2).getKey()).getId()) {
                    return -1;
                }
                return 0;
            }
        });
        Object[] allBins = reductionTree.keySet().toArray();
        Arrays.sort(allBins, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (((Bin)o1).getLevel() > ((Bin)o2).getLevel()) {
                    return -1;
                }
                if (((Bin)o1).getLevel() < ((Bin)o2).getLevel()) {
                    return 1;
                }
                return 0;
            }
        });
        CH_HwProcessor procInstance = (CH_HwProcessor)QueryUtils.getAllProcessorInstances(this.umlModel).get(0);
        ((Bin)allBins[0]).getLevel().intValue();
        System.out.println("-- Primary Schedulers\n");
        System.out.println("Scheduler (");
        System.out.println("\tType\t=> Primary_Scheduler,");
        System.out.println("\tName\t=> Scheduler_1,");
        System.out.println("\tPolicy\t=> ( Type => RUN ),");
        System.out.println("\tHost\t=> Multicore_1 );");
        System.out.println("\n-- Primary Scheduling Servers and Secondary Schedulers\n");
        int indexSupertask = 0;
        this.supertaskInfoList = new ArrayList<SupertaskInfo>();
        int i = 1;
        while (i < allBins.length && ((Bin)allBins[i]).getLevel() >= 0) {
            this.createSupertaskInfo(procInstance, indexSupertask, ((Bin)allBins[i]).getCapacity());
            this.assignedOperations = new HashSet<CHTask>();
            if (((Bin)allBins[i]).getLevel() == 0) {
                List<Task> tasks = reductionTree.get((Bin)allBins[i]);
                LinkedHashSet<Object> list = new LinkedHashSet<Object>();
                for (Task task : tasks) {
                    List leaves = (List)((Map.Entry)firstPackSorted[new Integer(task.getId())]).getValue();
                    for (Task leaf : leaves) {
                        System.out.println("Scheduling_Server (");
                        System.out.println("\tType\t\t\t\t=> Regular,");
                        System.out.println("\tName \t\t\t\t=> " + leaf.getId() + ",");
                        System.out.println("\tServer_Sched_Parameters\t\t=> (");
                        System.out.println("\t\tType\t\t\t=> EDF_policy,");
                        System.out.println("\t\tDeadline\t\t=> " + leaf.getT() + ",");
                        System.out.println("                Preassigned             => No),");
                        System.out.println("\tScheduler\t\t\t=> SecondaryScheduler_" + indexSupertask + ");");
                        System.out.println();
                        CHTask owningTask = this.getCHRTFromTask(leaf);
                        list.add(owningTask);
                        this.addRelatedOperations(owningTask, list);
                    }
                }
                this.core2supertask.put(this.supertaskInfoList.get(indexSupertask), list);
            }
            ++indexSupertask;
            ++i;
        }
    }

    private void createSupertaskInfo(CH_HwProcessor ch_HwProcessor, int indexSupertask, Float capacity) {
        SupertaskInfo si = new SupertaskInfo(ch_HwProcessor.getBase_InstanceSpecification(), "SuperTask_" + indexSupertask, capacity.floatValue());
        this.supertaskInfoList.add(si);
        System.out.println("--*************** BRANCH ***************");
        System.out.println("Scheduling_Server (");
        System.out.println("\tType\t\t\t\t=> Regular,");
        System.out.println("\tName\t\t\t\t=> SuperTask_" + indexSupertask + ",");
        System.out.println("\tServer_Sched_parameters\t\t=> ( Type => RUN_Supertask,");
        System.out.println("\t\t\t\t\t     Utilization => " + capacity + " ),");
        System.out.println("\tScheduler\t\t\t=> Scheduler_1 );");
        System.out.println();
        System.out.println("Scheduler (");
        System.out.println("\tType\t=> Secondary_Scheduler,");
        System.out.println("\tName\t=> SecondaryScheduler_" + indexSupertask + ",");
        System.out.println("\tPolicy\t=> ( \tType\t=> EDF,");
        System.out.println("\t\t\tWorst_Context_Switch\t=> 20 ),");
        System.out.println("\tServer\t=> SuperTask_" + indexSupertask + " );");
        System.out.println();
    }

    public void buildAssociations(Map<Bin, List<Task>> firstPack) {
        this.core2chtask = new HashMap<CHCore, LinkedHashSet<Object>>();
        int coreIndex = 0;
        for (Bin core : firstPack.keySet()) {
            this.assignedOperations = new HashSet<CHTask>();
            LinkedHashSet<Object> list = new LinkedHashSet<Object>();
            for (Task task : firstPack.get(core)) {
                CHTask owningTask = this.getCHRTFromTask(task);
                list.add(owningTask);
                this.addRelatedOperations(owningTask, list);
            }
            this.core2chtask.put((CHCore)this.cores.get(coreIndex++), list);
        }
    }

    private void addRelatedOperations(CHTask owningTask, LinkedHashSet<Object> list) {
        for (CHTask operation : this.operationList.get(owningTask)) {
            if (this.assignedOperations.contains(operation)) continue;
            list.add(operation);
            this.assignedOperations.add(operation);
        }
    }

    private String getTaskID(CHRtSpecification chRtSpecification) {
        return String.valueOf(chRtSpecification.getContext().getName()) + UMLUtils.getElementID((Element)chRtSpecification.getContext());
    }

    private CHTask getCHRTFromTask(Task task) {
        for (CHTask chtask : this.operationList.keySet()) {
            if (!this.getTaskID(chtask.getCHRtSpecification()).equals(task.getId())) continue;
            return chtask;
        }
        return null;
    }

    private void printContent() {
        System.out.println("Tasks:");
        for (CHTask chtask : this.operationList.keySet()) {
            System.out.println(chtask);
        }
    }

    protected void updateModel() {
        boolean b2;
        boolean b1 = this.core2chtask != null && !this.core2chtask.isEmpty();
        boolean bl = b2 = this.core2supertask != null && !this.core2supertask.isEmpty();
        if (b1 || b2) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlModel);
            editingDomain.getCommandStack().execute((Command)new Com(editingDomain));
        }
    }

    protected void queryContent(Model owner) throws ModelError {
        EList<CH_HwProcessor> x = QueryUtils.getAllProcessorInstances(this.umlModel);
        if ((x = QueryUtils.filterMultiCoreProcessors(x)).size() > 1) {
            throw new ModelError("Assignment generation works only on single processor systems");
        }
        EList<Package> packages = QueryUtils.getResourcePlatformPackages(this.umlModel, "DeploymentView");
        if (packages.size() == 0) {
            ModelError me = new ModelError("Error in model: no Package stereotyped as CHGAResourcePlatform in the Deployment View!");
            throw me;
        }
        this.hwSystemsList = new BasicEList();
        for (Package pack : packages) {
            BasicEList processors = new BasicEList();
            for (CH_HwProcessor ch_processor : QueryUtils.getAllProcessorInstancesInPackage(pack)) {
                InstanceSpecification instSpec = ch_processor.getBase_InstanceSpecification();
                processors.add((Object)instSpec);
                EList<CHCore> theCores = QueryUtils.getCores(ch_processor);
                this.coresMap.put(instSpec, theCores);
                this.cores.addAll(theCores);
            }
            InstanceSpecification theSystem = UMLUtils.getRootInstanceInPackage((Package)pack);
            this.hwSystemsList.add((Object)theSystem);
            this.processorsMap.put(pack, (EList<InstanceSpecification>)processors);
        }
        if (this.hwSystemsList.isEmpty()) {
            ModelError me = new ModelError("Error in model: no System in the Deployment View!");
            throw me;
        }
        EList instances = UMLUtils.getAllComponentInstances((Model)this.umlModel, (boolean)true);
        EList<CHTask> chtasks = QueryUtils.getCHTasksList((EList<InstanceSpecification>)instances);
        this.operationList = QueryUtils.getOperationChain(this.umlModel, chtasks);
    }

    class Com
    extends RecordingCommand {
        public Com(TransactionalEditingDomain domain) {
            super(domain);
        }

        protected void doExecute() {
            try {
                QueryUtils.deleteTask2CoreAssociations(hwSystem);
                if (!GenerateTask2CoreAssignmentsCommand.this.useRUN) {
                    GeneratorUtils.buildTask2CoreAssociations(hwSystem, GenerateTask2CoreAssignmentsCommand.this.core2chtask);
                } else {
                    GeneratorUtils.buildTask2SuperTaskAssociations(hwSystem, GenerateTask2CoreAssignmentsCommand.this.core2supertask, GenerateTask2CoreAssignmentsCommand.this.supertaskInfoList);
                }
            }
            catch (Exception e) {
                throw new OperationCanceledException(e.getMessage());
            }
        }
    }
}

